/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iomawaba.commands;

import com.google.common.collect.ImmutableSet;
import com.interordi.iomawaba.interfaces.PlayerActions;
import com.interordi.iomawaba.utilities.ControlCode;
import com.interordi.iomawaba.utilities.StringUtils;
import java.util.HashSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.TabExecutor;

public class GBan
extends Command
implements TabExecutor {
    PlayerActions actions;

    public GBan(PlayerActions actions) {
        super("GBan");
        this.actions = actions;
    }

    public void execute(CommandSender sender, String[] rawArgs) {
        if (!sender.hasPermission("iomawaba.admin")) {
            sender.sendMessage(new ComponentBuilder("You don't have permission to use this command.").color(ChatColor.RED).create());
            return;
        }
        String[] args = Stream.of(rawArgs).filter(item -> item != null && !"".equals(item)).collect(Collectors.toList()).toArray(new String[0]);
        if (args.length == 0) {
            sender.sendMessage(new ComponentBuilder("You must specify a target name.").color(ChatColor.RED).create());
            return;
        }
        UUID senderUuid = null;
        if (sender instanceof ProxiedPlayer) {
            ProxiedPlayer pSender = (ProxiedPlayer)sender;
            senderUuid = pSender.getUniqueId();
        }
        String targetRaw = args[0];
        String message = "";
        message = args.length > 1 ? String.valueOf(message) + StringUtils.strJoin(args, " ", 1) : String.valueOf(message) + "No reason was specified";
        ControlCode result = this.actions.banPlayer(targetRaw, senderUuid, sender.getName(), message);
        if (result == ControlCode.IS_ADMIN) {
            sender.sendMessage(new ComponentBuilder("You can't target other staff.").color(ChatColor.RED).create());
        } else if (result == ControlCode.ALREADY_BANNED) {
            sender.sendMessage(new ComponentBuilder(String.valueOf(targetRaw) + " is already banned.").color(ChatColor.RED).create());
        } else if (result == ControlCode.SUCCESS) {
            sender.sendMessage(new ComponentBuilder("Operation successful.").color(ChatColor.GREEN).create());
        }
    }

    public Iterable<String> onTabComplete(CommandSender sender, String[] args) {
        if (args.length == 0) {
            return ImmutableSet.of();
        }
        HashSet<String> matches = new HashSet<String>();
        if (args.length == 1) {
            String search = args[0].toLowerCase();
            for (ProxiedPlayer player : ProxyServer.getInstance().getPlayers()) {
                if (!player.getName().toLowerCase().startsWith(search)) continue;
                matches.add(player.getName());
            }
        }
        return matches;
    }
}

