/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iomawaba.modules;

import com.interordi.iomawaba.utilities.BanData;
import com.interordi.iomawaba.utilities.Database;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Bans {
    Database db;
    static Bans instance;

    public Bans(Database db) {
        this.db = db;
        instance = this;
    }

    public BanData isBanned(UUID uuid, String ip) {
        return this.db.getBan(uuid, ip, false);
    }

    public static String formatMessageTarget(BanData ban) {
        String message = "";
        message = ban.end != null ? String.valueOf(message) + "You have been temporarily banned: " : String.valueOf(message) + "You have been permanently banned: ";
        message = ban.reason != null && !ban.reason.isEmpty() ? String.valueOf(message) + ban.reason : String.valueOf(message) + "No reason was specified";
        if (ban.end != null) {
            message = String.valueOf(message) + "\n\nYour ban will end on " + ban.end.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z"));
        }
        return message;
    }

    public static String formatMessageGlobal(BanData ban) {
        String target = "";
        target = ban.ip != null && !ban.ip.isEmpty() ? ban.ip : ban.targetName;
        String message = "";
        message = ban.end != null ? String.valueOf(message) + target + " has been banned until " + ban.end.format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss z")) + ": " + ban.reason : String.valueOf(message) + target + " has been permanently banned: " + ban.reason;
        if (ban.reason.isEmpty()) {
            message = String.valueOf(message) + "No reason was specified";
        }
        return message;
    }

    public static ZonedDateTime parseDuration(String arg) {
        ZonedDateTime end = ZonedDateTime.now();
        Pattern r = Pattern.compile("([0-9]*)([a-zA-Z]+)");
        Matcher m = r.matcher(arg);
        while (m.find()) {
            int value = 0;
            String valueString = m.group(1);
            String unit = m.group(2);
            try {
                value = Integer.parseInt(valueString);
            }
            catch (NumberFormatException e) {
                return null;
            }
            switch (unit) {
                case "y": 
                case "year": 
                case "years": {
                    end = end.plusYears(value);
                    break;
                }
                case "months": 
                case "mo": 
                case "mth": 
                case "month": {
                    end = end.plusMonths(value);
                    break;
                }
                case "w": 
                case "wk": 
                case "wks": 
                case "week": 
                case "weeks": {
                    end = end.plusWeeks(value);
                    break;
                }
                case "d": 
                case "day": 
                case "days": {
                    end = end.plusDays(value);
                    break;
                }
                case "h": 
                case "hr": 
                case "hrs": 
                case "hour": 
                case "hours": {
                    end = end.plusHours(value);
                    break;
                }
                case "minute": 
                case "m": 
                case "min": 
                case "mins": 
                case "minutes": {
                    end = end.plusMinutes(value);
                    break;
                }
                case "second": 
                case "s": 
                case "sec": 
                case "secs": 
                case "seconds": {
                    end = end.plusSeconds(value);
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return end;
    }

    public static Bans getInstance() {
        return instance;
    }
}

