/*
 * Decompiled with CFR 0.152.
 */
package com.interordi.iomawaba.modules;

import com.interordi.iomawaba.IOMawabaSpigot;
import com.interordi.iomawaba.utilities.Database;
import java.time.ZonedDateTime;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Warnings {
    private String defaultMessage1 = "Hi there! I'm issuing you an official warning as I've noticed you have been griefing, which isn't tolerated here. Please don't break, take or change anything that belongs to someone else unless you get their permission first.";
    private String defaultMessage2 = "No griefing will be tolerated. Griefing is breaking or taking anything that belongs to someone else, or adding to a structure that isn't yours, without permission.";
    private String defaultMessage3 = "Griefing is not tolerated. Stop now.";
    private IOMawabaSpigot plugin;
    private Database db;

    public Warnings(IOMawabaSpigot plugin, Database db) {
        this.plugin = plugin;
        this.db = db;
    }

    public void giveWarning(final Player target, final CommandSender sender, final String message) {
        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                final int nbWarnings = ((Warnings)Warnings.this).plugin.db.getWarnings(target.getUniqueId()).size();
                String message1 = "";
                message1 = message == null || message.length() == 0 ? (nbWarnings > 1 ? Warnings.this.defaultMessage3 : (nbWarnings > 0 ? Warnings.this.defaultMessage2 : Warnings.this.defaultMessage1)) : message;
                final String finalMessage = message1;
                Bukkit.getServer().getScheduler().runTask((Plugin)Warnings.this.plugin, new Runnable(){

                    @Override
                    public void run() {
                        Warnings.this.actOnWarning(target, sender, finalMessage, nbWarnings);
                    }
                });
            }
        });
    }

    public void clearWarning(final String targetName, final CommandSender sender) {
        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                UUID targetUuid = Warnings.this.db.getUuidFromUsername(targetName);
                if (targetUuid == null) {
                    sender.sendMessage(ChatColor.RED + "Target not found: " + targetName);
                    return;
                }
                int nbWarnings = ((Warnings)Warnings.this).plugin.db.getWarnings(targetUuid).size();
                if (nbWarnings == 0) {
                    sender.sendMessage(ChatColor.RED + "This player doesn't have any active warnings.");
                    return;
                }
                ((Warnings)Warnings.this).plugin.db.clearWarning(targetUuid);
                sender.sendMessage(ChatColor.GREEN + "One warning removed from " + targetName + ", " + (nbWarnings - 1) + " still active.");
            }
        });
    }

    public void actOnWarning(final Player target, final CommandSender sender, String message, int nbWarnings) {
        String title = ChatColor.RED + ChatColor.BOLD + "WARNING";
        String subtitle = ChatColor.GOLD + target.getDisplayName() + ", see the chat now.";
        boolean kick = false;
        int ban = 0;
        UUID senderUuid = null;
        if (sender instanceof Player) {
            Player pSender = (Player)sender;
            senderUuid = pSender.getUniqueId();
        }
        final UUID finalSenderUuid = senderUuid;
        if (nbWarnings > 3) {
            ban = 999;
        } else if (nbWarnings == 3) {
            ban = 30;
        } else if (nbWarnings == 2) {
            target.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 600, 7), false);
            target.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, 600, 7), false);
            title = ChatColor.RED + ChatColor.BOLD + "FINAL WARNING";
            subtitle = ChatColor.GOLD + "Continue and you will be banned.";
            kick = true;
        } else if (nbWarnings == 1) {
            target.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 600, 7), false);
            target.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, 600, 7), false);
            title = ChatColor.RED + ChatColor.BOLD + "SECOND WARNING";
            subtitle = ChatColor.GOLD + "You will be kicked in a few seconds.";
            kick = true;
        } else {
            target.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 600, 2), false);
            target.addPotionEffect(new PotionEffect(PotionEffectType.SLOW_DIGGING, 600, 2), false);
        }
        target.sendMessage(ChatColor.RED + ChatColor.BOLD + "MESSAGE FROM STAFF: " + ChatColor.RESET + ChatColor.WHITE + message);
        target.sendTitle(title, subtitle, 10, 200, 10);
        sender.sendMessage(ChatColor.GREEN + "Warning sent to " + target.getDisplayName() + ".");
        Bukkit.getServer().getLogger().info("|IOSTAFF|" + target.getDisplayName() + " was warned (" + (nbWarnings + 1) + "): " + message);
        if (kick) {
            Bukkit.getServer().getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    target.kickPlayer("Official warning - review the rules now.");
                }
            }, 200L);
        }
        final String logMessage = message.equals(this.defaultMessage1) || message.equals(this.defaultMessage2) || message.equals(this.defaultMessage3) ? "No griefing." : message;
        if (ban > 0) {
            String serverMessage;
            String playerMessage;
            ZonedDateTime endTime = null;
            if (ban == 999) {
                playerMessage = "You have been permanently banned: " + logMessage;
                serverMessage = String.valueOf(target.getDisplayName()) + " was permanently banned: " + logMessage;
            } else {
                playerMessage = "You have been banned for " + ban + " days: " + logMessage;
                serverMessage = String.valueOf(target.getDisplayName()) + " was banned (" + ban + " days): " + logMessage;
                endTime = ZonedDateTime.now().plusDays(ban);
            }
            target.kickPlayer(playerMessage);
            Bukkit.getServer().getLogger().info("|IOBAN|" + serverMessage);
            final ZonedDateTime finalEndTime = endTime;
            Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    ((Warnings)Warnings.this).plugin.db.banTarget(target.getUniqueId(), target.getName(), null, finalSenderUuid, sender.getName(), null, finalEndTime, logMessage);
                }
            });
        }
        Bukkit.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, new Runnable(){

            @Override
            public void run() {
                ((Warnings)Warnings.this).plugin.db.logWarning(target.getUniqueId(), finalSenderUuid, sender.getName(), logMessage);
            }
        });
    }
}

