/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.entity;

import com.skniro.skniro_furniture.block.api.entity.ImplementedInventory;
import com.skniro.skniro_furniture.block.entity.FurnitureBlockEntityType;
import com.skniro.skniro_furniture.recipe.FurnitureRecipeType;
import com.skniro.skniro_furniture.recipe.KitchenSinkRecipe;
import com.skniro.skniro_furniture.recipe.KitchenSinkRecipeInput;
import com.skniro.skniro_furniture.screen.KitchenSinkBlockScreenHandler;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class KitchenSinkBlockEntity
extends BlockEntity
implements MenuProvider,
ImplementedInventory {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)4, (Object)ItemStack.EMPTY);
    private float rotation = 0.0f;
    private static final int INPUT_SLOT = 0;
    private static final int OUTPUT_SLOT = 1;
    protected final ContainerData propertyDelegate = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> KitchenSinkBlockEntity.this.progress;
                case 1 -> KitchenSinkBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    KitchenSinkBlockEntity.this.progress = value;
                }
                case 1: {
                    KitchenSinkBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    private int progress = 0;
    private int maxProgress = 72;
    private final int DEFAULT_MAX_PROGRESS = 72;

    public KitchenSinkBlockEntity(BlockPos pos, BlockState state) {
        super(FurnitureBlockEntityType.Kitchen_Sink_BLOCK_ENTITY.get(), pos, state);
    }

    public ItemStack getRenderStack() {
        if (this.getItem(0).isEmpty()) {
            return this.getItem(1);
        }
        return this.getItem(0);
    }

    @Override
    public void setChanged() {
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        super.setChanged();
    }

    @Override
    public NonNullList<ItemStack> getItems() {
        return this.inventory;
    }

    public Component getDisplayName() {
        return Component.translatable((String)"gui.skniro_furniture.kitchen_sink");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, Inventory playerInventory, Player player) {
        return new KitchenSinkBlockScreenHandler(syncId, playerInventory, this, this.propertyDelegate);
    }

    protected void saveAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        super.saveAdditional(nbt, registryLookup);
        ContainerHelper.saveAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        nbt.putInt("kitchen_sink.progress", this.progress);
        nbt.putInt("kitchen_sink.max_progress", this.maxProgress);
    }

    protected void loadAdditional(CompoundTag nbt, HolderLookup.Provider registryLookup) {
        ContainerHelper.loadAllItems((CompoundTag)nbt, this.inventory, (HolderLookup.Provider)registryLookup);
        this.progress = nbt.getInt("kitchen_sink.progress");
        this.maxProgress = nbt.getInt("kitchen_sink.max_progress");
        super.loadAdditional(nbt, registryLookup);
    }

    public void tick(Level world, BlockPos pos, BlockState state) {
        if (world.isClientSide()) {
            return;
        }
        if (this.hasRecipe() && this.canInsertIntoOutputSlot()) {
            this.increaseCraftingProgress();
            KitchenSinkBlockEntity.setChanged((Level)world, (BlockPos)pos, (BlockState)state);
            if (this.hasCraftingFinished()) {
                this.craftItem();
                this.resetProgress();
            }
        } else {
            this.resetProgress();
        }
    }

    private void resetProgress() {
        this.progress = 0;
        this.maxProgress = 72;
    }

    private void craftItem() {
        Optional<RecipeHolder<KitchenSinkRecipe>> recipe = this.getCurrentRecipe();
        this.removeItem(0, 1);
        this.setItem(1, new ItemStack((ItemLike)((KitchenSinkRecipe)recipe.get().value()).output().getItem(), this.getItem(1).getCount() + ((KitchenSinkRecipe)recipe.get().value()).output().getCount()));
    }

    @Override
    public int[] getSlotsForFace(Direction direction) {
        if (direction != Direction.DOWN) {
            return new int[]{0};
        }
        return new int[]{1};
    }

    public boolean canPlaceItem(int slot, ItemStack stack) {
        return slot != 1;
    }

    private boolean hasCraftingFinished() {
        return this.progress >= this.maxProgress;
    }

    private void increaseCraftingProgress() {
        ++this.progress;
    }

    private boolean canInsertIntoOutputSlot() {
        return this.getItem(1).isEmpty() || this.getItem(1).getCount() < this.getItem(1).getMaxStackSize();
    }

    private boolean hasRecipe() {
        Optional<RecipeHolder<KitchenSinkRecipe>> recipe = this.getCurrentRecipe();
        if (recipe.isEmpty()) {
            return false;
        }
        ItemStack output = ((KitchenSinkRecipe)recipe.get().value()).output();
        return this.canInsertAmountIntoOutputSlot(output.getCount()) && this.canInsertItemIntoOutputSlot(output);
    }

    private Optional<RecipeHolder<KitchenSinkRecipe>> getCurrentRecipe() {
        return this.getLevel().getServer().getRecipeManager().getRecipeFor(FurnitureRecipeType.Kitchen_Sink_TYPE.get(), (RecipeInput)new KitchenSinkRecipeInput((ItemStack)this.inventory.get(0)), this.getLevel());
    }

    private boolean canInsertItemIntoOutputSlot(ItemStack output) {
        return this.getItem(1).isEmpty() || this.getItem(1).getItem() == output.getItem();
    }

    private boolean canInsertAmountIntoOutputSlot(int count) {
        int maxCount = this.getItem(1).isEmpty() ? 64 : this.getItem(1).getMaxStackSize();
        int currentCount = this.getItem(1).getCount();
        return maxCount >= currentCount + count;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registryLookup) {
        return this.saveWithoutMetadata(registryLookup);
    }
}

