/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.skniro.skniro_furniture.block.entity.KitchenSinkBlockEntity;
import com.skniro.skniro_furniture.block.renderer.state.KitchenSinkBlockEntityRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class KitchenSinkBlockEntityRenderer
implements BlockEntityRenderer<KitchenSinkBlockEntity, KitchenSinkBlockEntityRenderState> {
    public KitchenSinkBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void submit(KitchenSinkBlockEntityRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        Direction direction = (Direction)state.blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        matrices.pushPose();
        switch (direction) {
            case NORTH: {
                matrices.translate(0.5f, 1.0f, 0.65f);
                break;
            }
            case SOUTH: {
                matrices.translate(0.5f, 1.0f, 0.35f);
                break;
            }
            case WEST: {
                matrices.translate(0.65f, 1.0f, 0.5f);
                break;
            }
            case EAST: {
                matrices.translate(0.35f, 1.0f, 0.5f);
            }
        }
        matrices.scale(0.5f, 0.5f, 0.5f);
        switch (direction) {
            case NORTH: {
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(0.0f));
                break;
            }
            case SOUTH: {
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
            }
        }
        state.item.submit(matrices, queue, state.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        matrices.popPose();
    }

    private int getLightLevel(Level world, BlockPos pos) {
        int bLight = world.getBrightness(LightLayer.BLOCK, pos);
        int sLight = world.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)Math.max(sLight, 15));
    }

    public KitchenSinkBlockEntityRenderState createRenderState() {
        return new KitchenSinkBlockEntityRenderState();
    }

    public void extractRenderState(KitchenSinkBlockEntity entity, KitchenSinkBlockEntityRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)state, tickProgress, cameraPos, crumblingOverlay);
        ItemModelResolver itemModelResolver = Minecraft.getInstance().getItemModelResolver();
        itemModelResolver.updateForTopItem(state.item, entity.getRenderStack(), ItemDisplayContext.GUI, entity.getLevel(), null, 1);
        state.blockPos = entity.getBlockPos();
        state.blockState = entity.getBlockState();
        state.lightCoords = this.getLightLevel(entity.getLevel(), entity.getBlockPos());
    }
}

