/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.skniro.skniro_furniture.block.entity.CabinetBlockEntity;
import com.skniro.skniro_furniture.block.init.FourGridCabinetBlock;
import com.skniro.skniro_furniture.block.init.TripleCabinetBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class CabinetBlockEntityRenderer
implements BlockEntityRenderer<CabinetBlockEntity> {
    public CabinetBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(CabinetBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay, Vec3 cameraPos) {
        float col;
        int row;
        ItemStack stack;
        int i;
        float spacing2;
        float spacing;
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Direction direction = (Direction)entity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        matrices.pushPose();
        switch (direction) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                matrices.translate(1.0f, 0.0f, 1.0f);
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                matrices.translate(0.0f, 0.0f, 1.0f);
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                matrices.translate(1.0f, 0.0f, 0.0f);
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
            }
        }
        if (entity.getBlockState().getBlock() instanceof TripleCabinetBlock) {
            spacing = 1.2f;
            spacing2 = 1.19f;
            matrices.translate(0.46f, 0.8f, 0.7f);
            matrices.scale(0.26f, 0.26f, 0.26f);
            for (i = 0; i < 9; ++i) {
                stack = entity.getItem(i);
                if (stack.isEmpty()) continue;
                matrices.pushPose();
                row = i / 3;
                col = (float)(i % 3) * 1.1f;
                matrices.translate((col - 1.0f) * spacing2, -((float)row * spacing), 0.0f);
                itemRenderer.renderStatic(stack, ItemDisplayContext.GUI, this.getLightLevel(entity.getLevel(), entity.getBlockPos()), OverlayTexture.NO_OVERLAY, matrices, vertexConsumers, entity.getLevel(), 1);
                matrices.popPose();
            }
        }
        if (entity.getBlockState().getBlock() instanceof FourGridCabinetBlock) {
            spacing = 1.2f;
            spacing2 = 1.05f;
            matrices.translate(0.68f, 0.7f, 0.7f);
            matrices.scale(0.4f, 0.4f, 0.4f);
            for (i = 0; i < 4; ++i) {
                stack = entity.getItem(i);
                if (stack.isEmpty()) continue;
                matrices.pushPose();
                row = i / 2;
                col = (float)(i % 2) * 1.1f;
                matrices.translate((col - 1.0f) * spacing2, -((float)row * spacing), 0.0f);
                itemRenderer.renderStatic(stack, ItemDisplayContext.GUI, this.getLightLevel(entity.getLevel(), entity.getBlockPos()), OverlayTexture.NO_OVERLAY, matrices, vertexConsumers, entity.getLevel(), 1);
                matrices.popPose();
            }
        }
        matrices.popPose();
    }

    private int getLightLevel(Level world, BlockPos pos) {
        int bLight = world.getBrightness(LightLayer.BLOCK, pos);
        int sLight = world.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)Math.max(sLight, 15));
    }
}

