/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.skniro.skniro_furniture.block.entity.OvenBlockEntity;
import com.skniro.skniro_furniture.block.init.OvenBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class OvenBlockEntityRenderer
implements BlockEntityRenderer<OvenBlockEntity> {
    private static final ResourceLocation LIGHT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"skniro_furniture", (String)"textures/block/oven_light.png");

    public OvenBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(OvenBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ItemStack stack;
        BlockState state = entity.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        if (!(state.m_60734_() instanceof OvenBlock)) {
            return;
        }
        matrices.m_85836_();
        switch (facing) {
            case NORTH: {
                matrices.m_85837_(0.5, 0.4, 0.15);
                break;
            }
            case SOUTH: {
                matrices.m_85837_(0.5, 0.4, 0.85);
                break;
            }
            case WEST: {
                matrices.m_85837_(0.15, 0.4, 0.5);
                break;
            }
            case EAST: {
                matrices.m_85837_(0.85, 0.4, 0.5);
            }
        }
        float angle = switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
        matrices.m_252781_(Axis.f_252436_.m_252977_(angle));
        Matrix4f mat = matrices.m_85850_().m_252922_();
        if (((Boolean)state.m_61143_((Property)OvenBlock.f_48684_)).booleanValue()) {
            VertexConsumer glowVc = vertexConsumers.m_6299_(RenderType.m_110488_((ResourceLocation)LIGHT_TEXTURE));
            this.drawQuad(mat, glowVc, -2130706688, light);
        }
        if (!(stack = entity.getRenderStack()).m_41619_()) {
            this.renderItemAsIcon(facing, stack, matrices, vertexConsumers, light, overlay);
        }
        matrices.m_85849_();
    }

    private void drawQuad(Matrix4f mat, VertexConsumer vc, int color, int light) {
        vc.m_252986_(mat, -0.3f, 0.21f, 0.0f).m_193479_(color).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f);
        vc.m_252986_(mat, 0.3f, 0.21f, 0.0f).m_193479_(color).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f);
        vc.m_252986_(mat, 0.3f, -0.21f, 0.0f).m_193479_(color).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f);
        vc.m_252986_(mat, -0.3f, -0.21f, 0.0f).m_193479_(color).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_5601_(0.0f, 0.0f, -1.0f);
    }

    private void renderItemAsIcon(Direction direction, ItemStack stack, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.m_85836_();
        matrices.m_85841_(0.4f, 0.4f, 0.4f);
        matrices.m_85837_(0.0, 0.3, 0.3);
        Minecraft.m_91087_().m_91291_().m_269128_(stack, ItemDisplayContext.GUI, light, overlay, matrices, vertexConsumers, null, 0);
        matrices.m_85849_();
    }
}

