/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.init;

import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSlidingDoorBlock
extends Block {
    public static final EnumProperty<Direction> FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.f_61401_;
    public static final EnumProperty<DoorHingeSide> HINGE = BlockStateProperties.f_61394_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private final BlockSetType blockSetType;

    public AbstractSlidingDoorBlock(BlockSetType type, BlockBehaviour.Properties settings) {
        super(settings.m_60918_(type.f_271136_()));
        this.blockSetType = type;
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(FACING, (Comparable)Direction.NORTH)).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_(HINGE, (Comparable)DoorHingeSide.LEFT)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER));
    }

    public BlockSetType getBlockSetType() {
        return this.blockSetType;
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (direction.m_122434_() == Direction.Axis.Y && doubleBlockHalf == DoubleBlockHalf.LOWER == (direction == Direction.UP)) {
            return neighborState.m_60734_() instanceof AbstractSlidingDoorBlock && neighborState.m_61143_(HALF) != doubleBlockHalf ? (BlockState)neighborState.m_61124_(HALF, (Comparable)doubleBlockHalf) : Blocks.f_50016_.m_49966_();
        }
        return doubleBlockHalf == DoubleBlockHalf.LOWER && direction == Direction.DOWN && !state.m_60710_((LevelReader)world, pos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public void m_304760_(BlockState state, Level world, BlockPos pos, Explosion explosion, BiConsumer<ItemStack, BlockPos> stackMerger) {
        if (explosion.m_307824_() == Explosion.BlockInteraction.TRIGGER_BLOCK && state.m_61143_(HALF) == DoubleBlockHalf.LOWER && this.blockSetType.f_303181_() && !((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            this.setOpen(null, world, state, pos, !this.isOpen(state));
        }
        super.m_304760_(state, world, pos, explosion, stackMerger);
    }

    public BlockState m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        if (!(world.f_46443_ || !player.m_7500_() && player.m_36298_(state))) {
            AbstractSlidingDoorBlock.onBreakInCreative(world, pos, state, player);
        }
        return super.m_5707_(world, pos, state, player);
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType type) {
        return switch (type) {
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.m_61143_((Property)OPEN);
            case PathComputationType.WATER -> false;
            default -> throw new IncompatibleClassChangeError();
        };
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos = ctx.m_8083_();
        Level world = ctx.m_43725_();
        Direction playerFacing = ctx.m_8125_();
        BlockPos upPos = pos.m_7494_();
        if (pos.m_123342_() < world.m_151558_() - 1 && world.m_8055_(upPos).m_60629_(ctx)) {
            boolean bl = world.m_276867_(pos) || world.m_276867_(upPos);
            return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)playerFacing)).m_61124_(HINGE, (Comparable)this.getHinge(ctx))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(bl))).m_61124_(HALF, (Comparable)DoubleBlockHalf.LOWER);
        }
        return null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        world.m_7731_(pos.m_7494_(), (BlockState)state.m_61124_(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
    }

    private DoorHingeSide getHinge(BlockPlaceContext ctx) {
        boolean bl2;
        Level blockView = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        Direction direction = ctx.m_8125_();
        BlockPos blockPos2 = blockPos.m_7494_();
        Direction direction2 = direction.m_122428_();
        BlockPos blockPos3 = blockPos.m_121945_(direction2);
        BlockState blockState = blockView.m_8055_(blockPos3);
        BlockPos blockPos4 = blockPos2.m_121945_(direction2);
        BlockState blockState2 = blockView.m_8055_(blockPos4);
        Direction direction3 = direction.m_122427_();
        BlockPos blockPos5 = blockPos.m_121945_(direction3);
        BlockState blockState3 = blockView.m_8055_(blockPos5);
        BlockPos blockPos6 = blockPos2.m_121945_(direction3);
        BlockState blockState4 = blockView.m_8055_(blockPos6);
        int i = (blockState.m_60838_((BlockGetter)blockView, blockPos3) ? -1 : 0) + (blockState2.m_60838_((BlockGetter)blockView, blockPos4) ? -1 : 0) + (blockState3.m_60838_((BlockGetter)blockView, blockPos5) ? 1 : 0) + (blockState4.m_60838_((BlockGetter)blockView, blockPos6) ? 1 : 0);
        boolean bl = blockState.m_60734_() instanceof AbstractSlidingDoorBlock && blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        boolean bl3 = bl2 = blockState3.m_60734_() instanceof AbstractSlidingDoorBlock && blockState3.m_61143_(HALF) == DoubleBlockHalf.LOWER;
        if ((!bl || bl2) && i <= 0) {
            if ((!bl2 || bl) && i >= 0) {
                int j = direction.m_122429_();
                int k = direction.m_122431_();
                Vec3 vec3d = ctx.m_43720_();
                double d = vec3d.f_82479_ - (double)blockPos.m_123341_();
                double e = vec3d.f_82481_ - (double)blockPos.m_123343_();
                return !(j < 0 && e < 0.5 || j > 0 && e > 0.5 || k < 0 && d > 0.5 || k > 0 && d < 0.5) ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT;
            }
            return DoorHingeSide.LEFT;
        }
        return DoorHingeSide.RIGHT;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.blockSetType.f_278463_()) {
            return InteractionResult.PASS;
        }
        state = (BlockState)state.m_61122_((Property)OPEN);
        world.m_7731_(pos, state, 10);
        this.playOpenCloseSound((Entity)player, world, pos, (Boolean)state.m_61143_((Property)OPEN));
        world.m_142346_((Entity)player, this.isOpen(state) ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        return InteractionResult.SUCCESS;
    }

    public boolean isOpen(BlockState state) {
        return (Boolean)state.m_61143_((Property)OPEN);
    }

    public void setOpen(@Nullable Entity entity, Level world, BlockState state, BlockPos pos, boolean open) {
        if (state.m_60713_((Block)this) && (Boolean)state.m_61143_((Property)OPEN) != open) {
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 10);
            this.playOpenCloseSound(entity, world, pos, open);
            world.m_142346_(entity, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        }
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos neighborPos, boolean notify) {
        boolean bl;
        boolean bl2 = world.m_276867_(pos) || world.m_276867_(pos.m_121945_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? Direction.UP : Direction.DOWN)) ? true : (bl = false);
        if (!this.m_49966_().m_60713_(sourceBlock) && bl != (Boolean)state.m_61143_((Property)POWERED)) {
            if (bl != (Boolean)state.m_61143_((Property)OPEN)) {
                this.playOpenCloseSound(null, world, pos, bl);
                world.m_142346_((Entity)null, bl ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            }
            world.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(bl))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(bl)), 2);
        }
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        BlockState blockState = world.m_8055_(blockPos);
        return state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? blockState.m_60783_((BlockGetter)world, blockPos, Direction.UP) : blockState.m_60713_((Block)this);
    }

    private void playOpenCloseSound(@Nullable Entity entity, Level world, BlockPos pos, boolean open) {
        world.m_245803_(entity, pos, open ? this.blockSetType.f_271141_() : this.blockSetType.f_271502_(), SoundSource.BLOCKS, 1.0f, world.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_(FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_(FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return mirror == Mirror.NONE ? state : (BlockState)state.m_60717_(mirror.m_54846_((Direction)state.m_61143_(FACING))).m_61122_(HINGE);
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        return Mth.m_14130_((int)pos.m_123341_(), (int)pos.m_6625_(state.m_61143_(HALF) == DoubleBlockHalf.LOWER ? 0 : 1).m_123342_(), (int)pos.m_123343_());
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{HALF, FACING, OPEN, HINGE, POWERED});
    }

    public static boolean canOpenByHand(Level world, BlockPos pos) {
        return AbstractSlidingDoorBlock.canOpenByHand(world.m_8055_(pos));
    }

    public static boolean canOpenByHand(BlockState state) {
        AbstractSlidingDoorBlock doorBlock;
        Block var2 = state.m_60734_();
        if (var2 instanceof AbstractSlidingDoorBlock && (doorBlock = (AbstractSlidingDoorBlock)var2).getBlockSetType().f_278463_()) {
            boolean var10000 = true;
            return var10000;
        }
        boolean var10000 = false;
        return var10000;
    }

    protected static void onBreakInCreative(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        DoubleBlockHalf doubleBlockHalf = (DoubleBlockHalf)state.m_61143_(HALF);
        if (doubleBlockHalf == DoubleBlockHalf.UPPER && (blockState = world.m_8055_(blockPos = pos.m_7495_())).m_60713_(state.m_60734_()) && blockState.m_61143_(HALF) == DoubleBlockHalf.LOWER) {
            BlockState blockState2 = blockState.m_60819_().m_192917_((Fluid)Fluids.f_76193_) ? Blocks.f_49990_.m_49966_() : Blocks.f_50016_.m_49966_();
            world.m_7731_(blockPos, blockState2, 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
    }
}

