/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.skniro.skniro_furniture.block.entity.CabinetBlockEntity;
import com.skniro.skniro_furniture.block.init.FourGridCabinetBlock;
import com.skniro.skniro_furniture.block.init.TripleCabinetBlock;
import com.skniro.skniro_furniture.block.renderer.state.CabinetBlockEntityRendererState;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.ItemOwner;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class CabinetBlockEntityRenderer
implements BlockEntityRenderer<CabinetBlockEntity, CabinetBlockEntityRendererState> {
    private final ItemModelResolver itemModelManager;

    public CabinetBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public void extractRenderState(CabinetBlockEntity entity, CabinetBlockEntityRendererState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        ItemStackRenderState itemRenderState;
        int i;
        int j;
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)state, tickProgress, cameraPos, crumblingOverlay);
        state.stack = entity.inventory;
        state.world = entity.getLevel();
        state.blockPos = entity.getBlockPos();
        state.blockState = entity.getBlockState();
        if (state.blockState.getBlock() instanceof TripleCabinetBlock) {
            j = (int)entity.getBlockPos().asLong();
            state.triplecabinetItemStates = new ArrayList<ItemStackRenderState>();
            for (i = 0; i < 9; ++i) {
                itemRenderState = new ItemStackRenderState();
                this.itemModelManager.updateForTopItem(itemRenderState, entity.getItem(i), ItemDisplayContext.FIXED, entity.getLevel(), (ItemOwner)null, i + j);
                state.triplecabinetItemStates.add(itemRenderState);
            }
        }
        if (state.blockState.getBlock() instanceof FourGridCabinetBlock) {
            j = (int)entity.getBlockPos().asLong();
            state.fourgridcabinetItemStates = new ArrayList<ItemStackRenderState>();
            for (i = 0; i < 4; ++i) {
                itemRenderState = new ItemStackRenderState();
                this.itemModelManager.updateForTopItem(itemRenderState, entity.getItem(i), ItemDisplayContext.FIXED, entity.getLevel(), (ItemOwner)null, i + j);
                state.fourgridcabinetItemStates.add(itemRenderState);
            }
        }
    }

    public CabinetBlockEntityRendererState createRenderState() {
        return new CabinetBlockEntityRendererState();
    }

    public void submit(CabinetBlockEntityRendererState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraRenderState) {
        float col;
        int row;
        ItemStack stack;
        ItemStackRenderState itemRenderState;
        int i;
        float spacing2;
        float spacing;
        List<ItemStackRenderState> list;
        Direction direction = (Direction)state.blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        matrices.pushPose();
        switch (direction) {
            case NORTH: {
                break;
            }
            case SOUTH: {
                matrices.translate(1.0f, 0.0f, 1.0f);
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                break;
            }
            case WEST: {
                matrices.translate(0.0f, 0.0f, 1.0f);
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
                break;
            }
            case EAST: {
                matrices.translate(1.0f, 0.0f, 0.0f);
                matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(270.0f));
            }
        }
        if (state.blockState.getBlock() instanceof TripleCabinetBlock) {
            list = state.triplecabinetItemStates;
            spacing = 1.2f;
            spacing2 = 1.19f;
            matrices.translate(0.46f, 0.8f, 0.7f);
            matrices.scale(0.26f, 0.26f, 0.26f);
            for (i = 0; i < 9; ++i) {
                itemRenderState = list.get(i);
                stack = (ItemStack)state.stack.get(i);
                if (stack.isEmpty()) continue;
                matrices.pushPose();
                row = i / 3;
                col = (float)(i % 3) * 1.1f;
                matrices.translate((col - 1.0f) * spacing2, -((float)row * spacing), 0.0f);
                itemRenderState.submit(matrices, queue, this.getLightLevel(state.world, state.blockPos), OverlayTexture.NO_OVERLAY, 0);
                matrices.popPose();
            }
        }
        if (state.blockState.getBlock() instanceof FourGridCabinetBlock) {
            list = state.fourgridcabinetItemStates;
            spacing = 1.2f;
            spacing2 = 1.05f;
            matrices.translate(0.68f, 0.7f, 0.7f);
            matrices.scale(0.4f, 0.4f, 0.4f);
            for (i = 0; i < 4; ++i) {
                itemRenderState = list.get(i);
                stack = (ItemStack)state.stack.get(i);
                if (stack.isEmpty()) continue;
                matrices.pushPose();
                row = i / 2;
                col = (float)(i % 2) * 1.1f;
                matrices.translate((col - 1.0f) * spacing2, -((float)row * spacing), 0.0f);
                itemRenderState.submit(matrices, queue, this.getLightLevel(state.world, state.blockPos), OverlayTexture.NO_OVERLAY, 0);
                matrices.popPose();
            }
        }
        matrices.popPose();
    }

    private int getLightLevel(Level world, BlockPos pos) {
        int bLight = world.getBrightness(LightLayer.BLOCK, pos);
        int sLight = world.getBrightness(LightLayer.SKY, pos);
        return LightTexture.pack((int)bLight, (int)Math.max(sLight, 15));
    }
}

