/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.api.registry;

import com.mojang.math.Quadrant;
import com.skniro.skniro_furniture.block.init.FurnitureBedBlock;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.MultiVariant;
import net.minecraft.client.data.models.blockstates.BlockModelDefinitionGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.renderer.block.model.VariantMutator;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class MapleModelDatagenHelper {
    private final BlockModelGenerators generator;
    private static final PropertyDispatch<VariantMutator> NORTH_DEFAULT_HORIZONTAL_ROTATION_OPERATIONS = PropertyDispatch.modify((Property)BlockStateProperties.HORIZONTAL_FACING).select((Comparable)Direction.EAST, (Object)BlockModelGenerators.Y_ROT_90).select((Comparable)Direction.SOUTH, (Object)BlockModelGenerators.Y_ROT_180).select((Comparable)Direction.WEST, (Object)BlockModelGenerators.Y_ROT_270).select((Comparable)Direction.NORTH, (Object)BlockModelGenerators.NOP);

    public MapleModelDatagenHelper(BlockModelGenerators generator) {
        this.generator = generator;
    }

    public void registerModSweetBerryBush(Item fruititem, Block block) {
        this.generator.registerSimpleFlatItemModel(fruititem);
        this.generator.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(PropertyDispatch.initial((Property)BlockStateProperties.AGE_3).generate(stage -> BlockModelGenerators.plainVariant((ResourceLocation)this.generator.createSuffixedVariant(block, "_stage" + stage, ModelTemplates.CROSS, TextureMapping::cross)))));
    }

    public void registerModBookshelf(Block block, Block plank) {
        TextureMapping textureMap = TextureMapping.column((ResourceLocation)TextureMapping.getBlockTexture((Block)block), (ResourceLocation)TextureMapping.getBlockTexture((Block)plank));
        MultiVariant identifier = BlockModelGenerators.plainVariant((ResourceLocation)ModelTemplates.CUBE_COLUMN.create(block, textureMap, this.generator.modelOutput));
        this.generator.blockStateOutput.accept(BlockModelGenerators.createSimpleBlock((Block)block, (MultiVariant)identifier));
    }

    public void registerLamp(Block block) {
        MultiVariant identifier = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block));
        MultiVariant identifier2 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)"_on"));
        this.generator.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.LIT, (MultiVariant)identifier2, (MultiVariant)identifier)));
    }

    public final void registerBlockState(Block block) {
        this.generator.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block, (MultiVariant)BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block))));
    }

    public void registerFridge(Block block) {
        ResourceLocation bottomModel = ModelLocationUtils.getModelLocation((Block)block, (String)"_bottom");
        ResourceLocation topModel = ModelLocationUtils.getModelLocation((Block)block, (String)"_top");
        PropertyDispatch.C2 variantMap = PropertyDispatch.initial((Property)BlockStateProperties.HORIZONTAL_FACING, (Property)BlockStateProperties.DOUBLE_BLOCK_HALF);
        MapleModelDatagenHelper.fillSimpleDoubleVariantMap((PropertyDispatch.C2<MultiVariant, Direction, DoubleBlockHalf>)variantMap, DoubleBlockHalf.LOWER, bottomModel);
        MapleModelDatagenHelper.fillSimpleDoubleVariantMap((PropertyDispatch.C2<MultiVariant, Direction, DoubleBlockHalf>)variantMap, DoubleBlockHalf.UPPER, topModel);
        this.generator.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with((PropertyDispatch)variantMap));
    }

    public static PropertyDispatch.C2<MultiVariant, Direction, DoubleBlockHalf> fillSimpleDoubleVariantMap(PropertyDispatch.C2<MultiVariant, Direction, DoubleBlockHalf> variantMap, DoubleBlockHalf targetHalf, ResourceLocation baseModelId) {
        return variantMap.select((Comparable)Direction.NORTH, (Comparable)targetHalf, (Object)BlockModelGenerators.plainVariant((ResourceLocation)baseModelId)).select((Comparable)Direction.EAST, (Comparable)targetHalf, (Object)BlockModelGenerators.plainVariant((ResourceLocation)baseModelId).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R90))).select((Comparable)Direction.SOUTH, (Comparable)targetHalf, (Object)BlockModelGenerators.plainVariant((ResourceLocation)baseModelId).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R180))).select((Comparable)Direction.WEST, (Comparable)targetHalf, (Object)BlockModelGenerators.plainVariant((ResourceLocation)baseModelId).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R270)));
    }

    public void registerPaperSlidingDoor(Block doorBlock) {
        MultiVariant weightedVariant = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)doorBlock, (String)"_bottom_left"));
        MultiVariant weightedVariant2 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)doorBlock, (String)"_bottom_left_open"));
        MultiVariant weightedVariant3 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)doorBlock, (String)"_bottom_right"));
        MultiVariant weightedVariant4 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)doorBlock, (String)"_bottom_right_open"));
        MultiVariant weightedVariant5 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)doorBlock, (String)"_top_left"));
        MultiVariant weightedVariant6 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)doorBlock, (String)"_top_left_open"));
        MultiVariant weightedVariant7 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)doorBlock, (String)"_top_right"));
        MultiVariant weightedVariant8 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)doorBlock, (String)"_top_right_open"));
        this.generator.blockStateOutput.accept(MapleModelDatagenHelper.createDoorBlockState(doorBlock, weightedVariant, weightedVariant2, weightedVariant3, weightedVariant4, weightedVariant5, weightedVariant6, weightedVariant7, weightedVariant8));
    }

    public static BlockModelDefinitionGenerator createDoorBlockState(Block doorBlock, MultiVariant bottomLeftClosedModel, MultiVariant bottomLeftOpenModel, MultiVariant bottomRightClosedModel, MultiVariant bottomRightOpenModel, MultiVariant topLeftClosedModel, MultiVariant topLeftOpenModel, MultiVariant topRightClosedModel, MultiVariant topRightOpenModel) {
        return MultiVariantGenerator.dispatch((Block)doorBlock).with((PropertyDispatch)PropertyDispatch.initial((Property)BlockStateProperties.HORIZONTAL_FACING, (Property)BlockStateProperties.DOUBLE_BLOCK_HALF, (Property)BlockStateProperties.DOOR_HINGE, (Property)BlockStateProperties.OPEN).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), (Object)bottomLeftClosedModel.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), (Object)bottomLeftClosedModel).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), (Object)bottomLeftClosedModel.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), (Object)bottomLeftClosedModel.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), (Object)bottomRightClosedModel.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), (Object)bottomRightClosedModel).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), (Object)bottomRightClosedModel.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), (Object)bottomRightClosedModel.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), (Object)bottomLeftOpenModel.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), (Object)bottomLeftOpenModel).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), (Object)bottomLeftOpenModel.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), (Object)bottomLeftOpenModel.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), (Object)bottomRightOpenModel.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), (Object)bottomRightOpenModel).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), (Object)bottomRightOpenModel.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.LOWER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), (Object)bottomRightOpenModel.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), (Object)topLeftClosedModel.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), (Object)topLeftClosedModel).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), (Object)topLeftClosedModel.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(false), (Object)topLeftClosedModel.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), (Object)topRightClosedModel.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), (Object)topRightClosedModel).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), (Object)topRightClosedModel.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(false), (Object)topRightClosedModel.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), (Object)topLeftOpenModel.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), (Object)topLeftOpenModel).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), (Object)topLeftOpenModel.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.LEFT, (Comparable)Boolean.valueOf(true), (Object)topLeftOpenModel.with(BlockModelGenerators.Y_ROT_180)).select((Comparable)Direction.EAST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), (Object)topRightOpenModel.with(BlockModelGenerators.Y_ROT_270)).select((Comparable)Direction.SOUTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), (Object)topRightOpenModel).select((Comparable)Direction.WEST, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), (Object)topRightOpenModel.with(BlockModelGenerators.Y_ROT_90)).select((Comparable)Direction.NORTH, (Comparable)DoubleBlockHalf.UPPER, (Comparable)DoorHingeSide.RIGHT, (Comparable)Boolean.valueOf(true), (Object)topRightOpenModel.with(BlockModelGenerators.Y_ROT_180)));
    }

    public final void registerBed(Block block) {
        ResourceLocation headModel = ModelLocationUtils.getModelLocation((Block)block, (String)"_head");
        ResourceLocation footModel = ModelLocationUtils.getModelLocation((Block)block, (String)"_foot");
        PropertyDispatch.C2 variantMap = PropertyDispatch.initial((Property)BlockStateProperties.HORIZONTAL_FACING, FurnitureBedBlock.PART);
        MapleModelDatagenHelper.fillSimpleDoubleVariantMap((PropertyDispatch.C2<MultiVariant, Direction, BedPart>)variantMap, BedPart.HEAD, headModel);
        MapleModelDatagenHelper.fillSimpleDoubleVariantMap((PropertyDispatch.C2<MultiVariant, Direction, BedPart>)variantMap, BedPart.FOOT, footModel);
        this.generator.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with((PropertyDispatch)variantMap));
    }

    public void registerTV(Block block) {
        MultiVariant identifier = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block));
        MultiVariant identifier2 = BlockModelGenerators.plainVariant((ResourceLocation)ModelLocationUtils.getModelLocation((Block)block, (String)"_open"));
        this.generator.blockStateOutput.accept(MultiVariantGenerator.dispatch((Block)block).with(BlockModelGenerators.createBooleanModelDispatch((BooleanProperty)BlockStateProperties.LIT, (MultiVariant)identifier2, (MultiVariant)identifier)).with(NORTH_DEFAULT_HORIZONTAL_ROTATION_OPERATIONS));
    }

    public static PropertyDispatch.C2<MultiVariant, Direction, BedPart> fillSimpleDoubleVariantMap(PropertyDispatch.C2<MultiVariant, Direction, BedPart> variantMap, BedPart targetHalf, ResourceLocation baseModelId) {
        return variantMap.select((Comparable)Direction.NORTH, (Comparable)targetHalf, (Object)BlockModelGenerators.plainVariant((ResourceLocation)baseModelId)).select((Comparable)Direction.EAST, (Comparable)targetHalf, (Object)BlockModelGenerators.plainVariant((ResourceLocation)baseModelId).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R90))).select((Comparable)Direction.SOUTH, (Comparable)targetHalf, (Object)BlockModelGenerators.plainVariant((ResourceLocation)baseModelId).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R180))).select((Comparable)Direction.WEST, (Comparable)targetHalf, (Object)BlockModelGenerators.plainVariant((ResourceLocation)baseModelId).with(VariantMutator.Y_ROT.withValue((Object)Quadrant.R270)));
    }
}

