/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.entity;

import com.skniro.skniro_furniture.block.init.AbstractWallCabinetBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFurnitureContainerBlockEntity
extends RandomizableContainerBlockEntity {
    private final ContainerOpenersCounter stateManager;
    private NonNullList<ItemStack> inventory;

    protected AbstractFurnitureContainerBlockEntity(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState, int size) {
        super(blockEntityType, blockPos, blockState);
        this.inventory = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
        this.stateManager = new ContainerOpenersCounter(){

            protected void m_142292_(Level world, BlockPos pos, BlockState state) {
                AbstractFurnitureContainerBlockEntity.this.playSound(state, SoundEvents.f_11725_);
            }

            protected void m_142289_(Level world, BlockPos pos, BlockState state) {
                AbstractFurnitureContainerBlockEntity.this.playSound(state, SoundEvents.f_11724_);
            }

            protected void m_142148_(Level world, BlockPos pos, BlockState state, int oldViewerCount, int newViewerCount) {
            }

            protected boolean m_142718_(Player player) {
                if (player.f_36096_ instanceof ChestMenu) {
                    Container inventory = ((ChestMenu)player.f_36096_).m_39261_();
                    return inventory == AbstractFurnitureContainerBlockEntity.this;
                }
                return false;
            }
        };
    }

    void playSound(BlockState state, SoundEvent soundEvent) {
        Vec3i vec3i = ((Direction)state.m_61143_(AbstractWallCabinetBlock.FACING)).m_122436_();
        double d = (double)this.f_58858_.m_123341_() + 0.5 + (double)vec3i.m_123341_() / 2.0;
        double e = (double)this.f_58858_.m_123342_() + 0.5 + (double)vec3i.m_123342_() / 2.0;
        double f = (double)this.f_58858_.m_123343_() + 0.5 + (double)vec3i.m_123343_() / 2.0;
        this.f_58857_.m_6263_((Player)null, d, e, f, soundEvent, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        ContainerHelper.m_18973_((CompoundTag)nbt, this.inventory);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.inventory;
    }

    protected void m_6520_(NonNullList<ItemStack> inventory) {
        this.inventory = inventory;
    }

    protected Component m_6820_() {
        return null;
    }

    protected AbstractContainerMenu m_6555_(int syncId, Inventory playerInventory) {
        return null;
    }

    public void m_5856_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.stateManager.m_155452_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (!this.f_58859_ && !player.m_5833_()) {
            this.stateManager.m_155468_(player, this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void tick() {
        if (!this.f_58859_) {
            this.stateManager.m_155476_(this.m_58904_(), this.m_58899_(), this.m_58900_());
        }
    }

    public void m_6596_() {
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
        super.m_6596_();
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

