/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.init;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skniro.skniro_furniture.block.entity.FurnitureBedBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class FurnitureBedBlock
extends BedBlock
implements EntityBlock {
    public static final MapCodec<FurnitureBedBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.f_262211_.fieldOf("color").forGetter(FurnitureBedBlock::m_49554_), (App)FurnitureBedBlock.m_305607_()).apply((Applicative)instance, FurnitureBedBlock::new));
    public static final EnumProperty<BedPart> PART = BlockStateProperties.f_61391_;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.f_61445_;
    protected static final VoxelShape BASE = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)7.5, (double)16.0);
    protected static final VoxelShape LEG_NORTH_WEST = Block.m_49796_((double)0.0, (double)2.0, (double)0.0, (double)2.0, (double)2.0, (double)2.0);
    protected static final VoxelShape LEG_SOUTH_WEST = Block.m_49796_((double)14.0, (double)2.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0);
    protected static final VoxelShape LEG_NORTH_EAST = Block.m_49796_((double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape LEG_SOUTH_EAST = Block.m_49796_((double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_SOUTH_WEST});
    protected static final VoxelShape SOUTH_SHAPE;
    protected static final VoxelShape WEST_SHAPE;
    protected static final VoxelShape EAST_SHAPE;
    private final DyeColor color;

    public FurnitureBedBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(color, settings);
        this.color = color;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PART, (Comparable)BedPart.FOOT)).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public boolean m_48673_(BlockState state) {
        return true;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FurnitureBedBlockEntity(pos, state, this.color);
    }

    public DyeColor m_49554_() {
        return this.color;
    }

    @Nullable
    public static Direction m_49485_(BlockGetter world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        return blockState.m_60734_() instanceof FurnitureBedBlock ? (Direction)blockState.m_61143_((Property)f_54117_) : null;
    }

    @Nullable
    public boolean m_6104_(BlockState state, BlockState neighborState, Direction offset) {
        return neighborState.m_60734_() instanceof FurnitureBedBlock;
    }

    public static boolean m_49488_(Level world) {
        return world.m_6042_().f_63862_();
    }

    private boolean m_49490_(Level world, BlockPos pos) {
        List list = world.m_6443_(Villager.class, new AABB(pos), LivingEntity::m_5803_);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).m_5796_();
        return true;
    }

    public void m_142072_(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.m_142072_(world, state, pos, entity, fallDistance * 0.5f);
    }

    public void m_5548_(BlockGetter world, Entity entity) {
        if (entity.m_20162_()) {
            super.m_5548_(world, entity);
        } else {
            this.m_49456_(entity);
        }
    }

    private void m_49456_(Entity entity) {
        Vec3 vec3d = entity.m_20184_();
        if (vec3d.f_82480_ < 0.0) {
            double d = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.m_20334_(vec3d.f_82479_, -vec3d.f_82480_ * (double)0.66f * d, vec3d.f_82481_);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == FurnitureBedBlock.m_49533_((BedPart)state.m_61143_(PART), (Direction)state.m_61143_((Property)f_54117_))) {
            return neighborState.m_60713_((Block)this) && neighborState.m_61143_(PART) != state.m_61143_(PART) ? (BlockState)state.m_61124_((Property)OCCUPIED, (Comparable)((Boolean)neighborState.m_61143_((Property)OCCUPIED))) : Blocks.f_50016_.m_49966_();
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    private static Direction m_49533_(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.m_122424_();
    }

    public BlockState m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart bedPart;
        if (!world.f_46443_ && player.m_7500_() && (bedPart = (BedPart)state.m_61143_(PART)) == BedPart.FOOT && (blockState = world.m_8055_(blockPos = pos.m_121945_(FurnitureBedBlock.m_49533_(bedPart, (Direction)state.m_61143_((Property)f_54117_))))).m_60713_((Block)this) && blockState.m_61143_(PART) == BedPart.HEAD) {
            world.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 35);
            world.m_5898_(player, 2001, blockPos, Block.m_49956_((BlockState)blockState));
        }
        return super.m_5707_(world, pos, state, player);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_();
        BlockPos blockPos = ctx.m_8083_();
        BlockPos blockPos2 = blockPos.m_121945_(direction);
        Level world = ctx.m_43725_();
        return world.m_8055_(blockPos2).m_60629_(ctx) && world.m_6857_().m_61937_(blockPos2) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = FurnitureBedBlock.m_49557_(state).m_122424_();
        switch (direction) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public static Direction m_49557_(BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        return state.m_61143_(PART) == BedPart.HEAD ? direction.m_122424_() : direction;
    }

    public static DoubleBlockCombiner.BlockType m_49559_(BlockState state) {
        BedPart bedPart = (BedPart)state.m_61143_(PART);
        return bedPart == BedPart.HEAD ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    private static boolean m_49541_(BlockGetter world, BlockPos pos) {
        return world.m_8055_(pos.m_7495_()).m_60734_() instanceof FurnitureBedBlock;
    }

    public static Optional<Vec3> m_260958_(EntityType<?> type, CollisionGetter world, BlockPos pos, Direction bedDirection, float spawnAngle) {
        Direction direction2;
        Direction direction = bedDirection.m_122427_();
        Direction direction3 = direction2 = direction.m_122370_(spawnAngle) ? direction.m_122424_() : direction;
        if (FurnitureBedBlock.m_49541_((BlockGetter)world, pos)) {
            return FurnitureBedBlock.m_49463_(type, world, pos, bedDirection, direction2);
        }
        int[][] is = FurnitureBedBlock.m_49538_(bedDirection, direction2);
        Optional<Vec3> optional = FurnitureBedBlock.m_49469_(type, world, pos, is, true);
        return optional.isPresent() ? optional : FurnitureBedBlock.m_49469_(type, world, pos, is, false);
    }

    private static Optional<Vec3> m_49463_(EntityType<?> type, CollisionGetter world, BlockPos pos, Direction bedDirection, Direction respawnDirection) {
        int[][] is = FurnitureBedBlock.m_49551_(bedDirection, respawnDirection);
        Optional<Vec3> optional = FurnitureBedBlock.m_49469_(type, world, pos, is, true);
        if (optional.isPresent()) {
            return optional;
        }
        BlockPos blockPos = pos.m_7495_();
        Optional<Vec3> optional2 = FurnitureBedBlock.m_49469_(type, world, blockPos, is, true);
        if (optional2.isPresent()) {
            return optional2;
        }
        int[][] js = FurnitureBedBlock.m_49536_(bedDirection);
        Optional<Vec3> optional3 = FurnitureBedBlock.m_49469_(type, world, pos, js, true);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional<Vec3> optional4 = FurnitureBedBlock.m_49469_(type, world, pos, is, false);
        if (optional4.isPresent()) {
            return optional4;
        }
        Optional<Vec3> optional5 = FurnitureBedBlock.m_49469_(type, world, blockPos, is, false);
        return optional5.isPresent() ? optional5 : FurnitureBedBlock.m_49469_(type, world, pos, js, false);
    }

    private static Optional<Vec3> m_49469_(EntityType<?> type, CollisionGetter world, BlockPos pos, int[][] possibleOffsets, boolean ignoreInvalidPos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int[] is : possibleOffsets) {
            mutable.m_122178_(pos.m_123341_() + is[0], pos.m_123342_(), pos.m_123343_() + is[1]);
            Vec3 vec3d = DismountHelper.m_38441_(type, (CollisionGetter)world, (BlockPos)mutable, (boolean)ignoreInvalidPos);
            if (vec3d == null) continue;
            return Optional.of(vec3d);
        }
        return Optional.empty();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, OCCUPIED});
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.f_46443_) {
            BlockPos blockPos = pos.m_121945_((Direction)state.m_61143_((Property)f_54117_));
            world.m_7731_(blockPos, (BlockState)state.m_61124_(PART, (Comparable)BedPart.HEAD), 3);
            world.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
        }
    }

    public long m_7799_(BlockState state, BlockPos pos) {
        BlockPos blockPos = pos.m_5484_((Direction)state.m_61143_((Property)f_54117_), state.m_61143_(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.m_14130_((int)blockPos.m_123341_(), (int)pos.m_123342_(), (int)blockPos.m_123343_());
    }

    public boolean m_7357_(BlockState state, BlockGetter blockGetter, BlockPos pos, PathComputationType type) {
        return false;
    }

    private static int[][] m_49538_(Direction bedDirection, Direction respawnDirection) {
        return (int[][])ArrayUtils.addAll((Object[])FurnitureBedBlock.m_49551_(bedDirection, respawnDirection), (Object[])FurnitureBedBlock.m_49536_(bedDirection));
    }

    private static int[][] m_49551_(Direction bedDirection, Direction respawnDirection) {
        return new int[][]{{respawnDirection.m_122429_(), respawnDirection.m_122431_()}, {respawnDirection.m_122429_() - bedDirection.m_122429_(), respawnDirection.m_122431_() - bedDirection.m_122431_()}, {respawnDirection.m_122429_() - bedDirection.m_122429_() * 2, respawnDirection.m_122431_() - bedDirection.m_122431_() * 2}, {-bedDirection.m_122429_() * 2, -bedDirection.m_122431_() * 2}, {-respawnDirection.m_122429_() - bedDirection.m_122429_() * 2, -respawnDirection.m_122431_() - bedDirection.m_122431_() * 2}, {-respawnDirection.m_122429_() - bedDirection.m_122429_(), -respawnDirection.m_122431_() - bedDirection.m_122431_()}, {-respawnDirection.m_122429_(), -respawnDirection.m_122431_()}, {-respawnDirection.m_122429_() + bedDirection.m_122429_(), -respawnDirection.m_122431_() + bedDirection.m_122431_()}, {bedDirection.m_122429_(), bedDirection.m_122431_()}, {respawnDirection.m_122429_() + bedDirection.m_122429_(), respawnDirection.m_122431_() + bedDirection.m_122431_()}};
    }

    private static int[][] m_49536_(Direction bedDirection) {
        return new int[][]{{0, 0}, {-bedDirection.m_122429_(), -bedDirection.m_122431_()}};
    }

    static {
        EAST_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_SOUTH_WEST, LEG_NORTH_EAST});
        SOUTH_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_EAST, LEG_SOUTH_EAST});
        WEST_SHAPE = Shapes.m_83124_((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_SOUTH_EAST, LEG_NORTH_WEST});
    }
}

