/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.init;

import com.mojang.serialization.MapCodec;
import com.skniro.skniro_furniture.entity.MapleEntityType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class SofaBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
    public static final BooleanProperty RIGHT = BooleanProperty.m_61465_((String)"right");
    public static final MapCodec<SofaBlock> CODEC = SofaBlock.m_306223_(SofaBlock::new);
    private static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public SofaBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> m_304657_() {
        return CODEC;
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        super.m_6861_(state, world, pos, sourceBlock, sourcePos, notify);
        if (world.m_5776_()) {
            return;
        }
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        boolean leftConnected = this.isLeftConnected(world, pos, direction);
        boolean rightConnected = this.isRightConnected(world, pos, direction);
        BlockState newState = (BlockState)((BlockState)state.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(leftConnected))).m_61124_((Property)RIGHT, (Comparable)Boolean.valueOf(rightConnected));
        if (!newState.equals(state)) {
            world.m_7731_(pos, newState, 2);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!level.m_5776_()) {
            Entity entity = null;
            List entities = level.m_142425_((EntityTypeTest)MapleEntityType.SOFA_ENTITY.get(), new AABB(pos), chair -> true);
            entity = entities.isEmpty() ? MapleEntityType.SOFA_ENTITY.get().m_262496_((ServerLevel)level, pos, MobSpawnType.TRIGGERED) : (Entity)entities.get(0);
            player.m_20329_(entity);
        }
        return InteractionResult.SUCCESS;
    }

    public static boolean isSofa(BlockState state) {
        return state.m_60734_() instanceof SofaBlock;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        this.m_6861_(state, world, pos, null, null, false);
    }

    private boolean isLeftConnected(Level world, BlockPos pos, Direction facing) {
        BlockState neighborState = world.m_8055_(pos.m_121945_(facing.m_122428_()));
        return neighborState.m_60734_() == this && neighborState.m_61143_((Property)f_54117_) == facing;
    }

    private boolean isRightConnected(Level world, BlockPos pos, Direction facing) {
        BlockState neighborState = world.m_8055_(pos.m_121945_(facing.m_122427_()));
        return neighborState.m_60734_() == this && neighborState.m_61143_((Property)f_54117_) == facing;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)facing);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, LEFT, RIGHT});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

