/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.skniro.skniro_furniture.block.entity.OvenBlockEntity;
import com.skniro.skniro_furniture.block.init.OvenBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Matrix4f;

public class OvenBlockEntityRenderer
implements BlockEntityRenderer<OvenBlockEntity> {
    private static final ResourceLocation LIGHT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"skniro_furniture", (String)"textures/block/oven_light.png");

    public OvenBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(OvenBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        ItemStack stack;
        BlockState state = entity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (!(state.getBlock() instanceof OvenBlock)) {
            return;
        }
        matrices.pushPose();
        switch (facing) {
            case NORTH: {
                matrices.translate(0.5, 0.4, 0.15);
                break;
            }
            case SOUTH: {
                matrices.translate(0.5, 0.4, 0.85);
                break;
            }
            case WEST: {
                matrices.translate(0.15, 0.4, 0.5);
                break;
            }
            case EAST: {
                matrices.translate(0.85, 0.4, 0.5);
            }
        }
        float angle = switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
        matrices.mulPose(Axis.YP.rotationDegrees(angle));
        Matrix4f mat = matrices.last().pose();
        if (((Boolean)state.getValue((Property)OvenBlock.LIT)).booleanValue()) {
            VertexConsumer glowVc = vertexConsumers.getBuffer(RenderType.eyes((ResourceLocation)LIGHT_TEXTURE));
            this.drawQuad(mat, glowVc, -2130706688, light);
        }
        if (!(stack = entity.getRenderStack()).isEmpty()) {
            this.renderItemAsIcon(facing, stack, matrices, vertexConsumers, light, overlay);
        }
        matrices.popPose();
    }

    private void drawQuad(Matrix4f mat, VertexConsumer vc, int color, int light) {
        vc.addVertex(mat, -0.3f, 0.21f, 0.0f).setColor(color).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(mat, 0.3f, 0.21f, 0.0f).setColor(color).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(mat, 0.3f, -0.21f, 0.0f).setColor(color).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(mat, -0.3f, -0.21f, 0.0f).setColor(color).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
    }

    private void renderItemAsIcon(Direction direction, ItemStack stack, PoseStack matrices, MultiBufferSource vertexConsumers, int light, int overlay) {
        matrices.pushPose();
        matrices.scale(0.4f, 0.4f, 0.4f);
        matrices.translate(0.0, 0.3, 0.3);
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GUI, light, overlay, matrices, vertexConsumers, null, 0);
        matrices.popPose();
    }
}

