/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.init;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.skniro.skniro_furniture.block.entity.FurnitureBedBlockEntity;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class FurnitureBedBlock
extends BedBlock
implements EntityBlock {
    public static final MapCodec<FurnitureBedBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("color").forGetter(FurnitureBedBlock::getColor), (App)FurnitureBedBlock.propertiesCodec()).apply((Applicative)instance, FurnitureBedBlock::new));
    public static final EnumProperty<BedPart> PART = BlockStateProperties.BED_PART;
    public static final BooleanProperty OCCUPIED = BlockStateProperties.OCCUPIED;
    protected static final VoxelShape BASE = Block.box((double)0.0, (double)2.0, (double)0.0, (double)16.0, (double)7.5, (double)16.0);
    protected static final VoxelShape LEG_NORTH_WEST = Block.box((double)0.0, (double)2.0, (double)0.0, (double)2.0, (double)2.0, (double)2.0);
    protected static final VoxelShape LEG_SOUTH_WEST = Block.box((double)14.0, (double)2.0, (double)0.0, (double)16.0, (double)2.0, (double)2.0);
    protected static final VoxelShape LEG_NORTH_EAST = Block.box((double)14.0, (double)2.0, (double)14.0, (double)16.0, (double)2.0, (double)16.0);
    protected static final VoxelShape LEG_SOUTH_EAST = Block.box((double)0.0, (double)2.0, (double)14.0, (double)2.0, (double)2.0, (double)16.0);
    protected static final VoxelShape NORTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_WEST, LEG_SOUTH_WEST});
    protected static final VoxelShape SOUTH_SHAPE;
    protected static final VoxelShape WEST_SHAPE;
    protected static final VoxelShape EAST_SHAPE;
    private final DyeColor color;

    public FurnitureBedBlock(DyeColor color, BlockBehaviour.Properties settings) {
        super(color, settings);
        this.color = color;
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(PART, (Comparable)BedPart.FOOT)).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean isPossibleToRespawnInThis(BlockState state) {
        return true;
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FurnitureBedBlockEntity(pos, state, this.color);
    }

    public DyeColor getColor() {
        return this.color;
    }

    @Nullable
    public static Direction getBedOrientation(BlockGetter world, BlockPos pos) {
        BlockState blockState = world.getBlockState(pos);
        return blockState.getBlock() instanceof FurnitureBedBlock ? (Direction)blockState.getValue((Property)FACING) : null;
    }

    @Nullable
    public boolean skipRendering(BlockState state, BlockState neighborState, Direction offset) {
        return neighborState.getBlock() instanceof FurnitureBedBlock;
    }

    public static boolean canSetSpawn(Level world) {
        return world.dimensionType().bedWorks();
    }

    private boolean kickVillagerOutOfBed(Level world, BlockPos pos) {
        List list = world.getEntitiesOfClass(Villager.class, new AABB(pos), LivingEntity::isSleeping);
        if (list.isEmpty()) {
            return false;
        }
        ((Villager)list.get(0)).stopSleeping();
        return true;
    }

    public void fallOn(Level world, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        super.fallOn(world, state, pos, entity, fallDistance * 0.5f);
    }

    public void updateEntityMovementAfterFallOn(BlockGetter world, Entity entity) {
        if (entity.isSuppressingBounce()) {
            super.updateEntityMovementAfterFallOn(world, entity);
        } else {
            this.bounceUp(entity);
        }
    }

    private void bounceUp(Entity entity) {
        Vec3 vec3d = entity.getDeltaMovement();
        if (vec3d.y < 0.0) {
            double d = entity instanceof LivingEntity ? 1.0 : 0.8;
            entity.setDeltaMovement(vec3d.x, -vec3d.y * (double)0.66f * d, vec3d.z);
        }
    }

    protected BlockState updateShape(BlockState state, LevelReader world, ScheduledTickAccess tickView, BlockPos pos, Direction direction, BlockPos neighborPos, BlockState neighborState, RandomSource random) {
        if (direction == FurnitureBedBlock.getNeighbourDirection((BedPart)state.getValue(PART), (Direction)state.getValue((Property)FACING))) {
            return neighborState.is((Block)this) && neighborState.getValue(PART) != state.getValue(PART) ? (BlockState)state.setValue((Property)OCCUPIED, (Comparable)((Boolean)neighborState.getValue((Property)OCCUPIED))) : Blocks.AIR.defaultBlockState();
        }
        return super.updateShape(state, world, tickView, pos, direction, neighborPos, neighborState, random);
    }

    private static Direction getNeighbourDirection(BedPart part, Direction direction) {
        return part == BedPart.FOOT ? direction : direction.getOpposite();
    }

    public BlockState playerWillDestroy(Level world, BlockPos pos, BlockState state, Player player) {
        BlockPos blockPos;
        BlockState blockState;
        BedPart bedPart;
        if (!world.isClientSide && player.isCreative() && (bedPart = (BedPart)state.getValue(PART)) == BedPart.FOOT && (blockState = world.getBlockState(blockPos = pos.relative(FurnitureBedBlock.getNeighbourDirection(bedPart, (Direction)state.getValue((Property)FACING))))).is((Block)this) && blockState.getValue(PART) == BedPart.HEAD) {
            world.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 35);
            world.levelEvent(player, 2001, blockPos, Block.getId((BlockState)blockState));
        }
        return super.playerWillDestroy(world, pos, state, player);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction direction = ctx.getHorizontalDirection();
        BlockPos blockPos = ctx.getClickedPos();
        BlockPos blockPos2 = blockPos.relative(direction);
        Level world = ctx.getLevel();
        return world.getBlockState(blockPos2).canBeReplaced(ctx) && world.getWorldBorder().isWithinBounds(blockPos2) ? (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction) : null;
    }

    protected VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = FurnitureBedBlock.getConnectedDirection(state).getOpposite();
        switch (direction) {
            case NORTH: {
                return NORTH_SHAPE;
            }
            case SOUTH: {
                return SOUTH_SHAPE;
            }
            case WEST: {
                return WEST_SHAPE;
            }
        }
        return EAST_SHAPE;
    }

    public static Direction getConnectedDirection(BlockState state) {
        Direction direction = (Direction)state.getValue((Property)FACING);
        return state.getValue(PART) == BedPart.HEAD ? direction.getOpposite() : direction;
    }

    public static DoubleBlockCombiner.BlockType getBlockType(BlockState state) {
        BedPart bedPart = (BedPart)state.getValue(PART);
        return bedPart == BedPart.HEAD ? DoubleBlockCombiner.BlockType.FIRST : DoubleBlockCombiner.BlockType.SECOND;
    }

    private static boolean isBunkBed(BlockGetter world, BlockPos pos) {
        return world.getBlockState(pos.below()).getBlock() instanceof FurnitureBedBlock;
    }

    public static Optional<Vec3> findStandUpPosition(EntityType<?> type, CollisionGetter world, BlockPos pos, Direction bedDirection, float spawnAngle) {
        Direction direction2;
        Direction direction = bedDirection.getClockWise();
        Direction direction3 = direction2 = direction.isFacingAngle(spawnAngle) ? direction.getOpposite() : direction;
        if (FurnitureBedBlock.isBunkBed((BlockGetter)world, pos)) {
            return FurnitureBedBlock.findBunkBedStandUpPosition(type, world, pos, bedDirection, direction2);
        }
        int[][] is = FurnitureBedBlock.bedStandUpOffsets(bedDirection, direction2);
        Optional<Vec3> optional = FurnitureBedBlock.findStandUpPositionAtOffset(type, world, pos, is, true);
        return optional.isPresent() ? optional : FurnitureBedBlock.findStandUpPositionAtOffset(type, world, pos, is, false);
    }

    private static Optional<Vec3> findBunkBedStandUpPosition(EntityType<?> type, CollisionGetter world, BlockPos pos, Direction bedDirection, Direction respawnDirection) {
        int[][] is = FurnitureBedBlock.bedSurroundStandUpOffsets(bedDirection, respawnDirection);
        Optional<Vec3> optional = FurnitureBedBlock.findStandUpPositionAtOffset(type, world, pos, is, true);
        if (optional.isPresent()) {
            return optional;
        }
        BlockPos blockPos = pos.below();
        Optional<Vec3> optional2 = FurnitureBedBlock.findStandUpPositionAtOffset(type, world, blockPos, is, true);
        if (optional2.isPresent()) {
            return optional2;
        }
        int[][] js = FurnitureBedBlock.bedAboveStandUpOffsets(bedDirection);
        Optional<Vec3> optional3 = FurnitureBedBlock.findStandUpPositionAtOffset(type, world, pos, js, true);
        if (optional3.isPresent()) {
            return optional3;
        }
        Optional<Vec3> optional4 = FurnitureBedBlock.findStandUpPositionAtOffset(type, world, pos, is, false);
        if (optional4.isPresent()) {
            return optional4;
        }
        Optional<Vec3> optional5 = FurnitureBedBlock.findStandUpPositionAtOffset(type, world, blockPos, is, false);
        return optional5.isPresent() ? optional5 : FurnitureBedBlock.findStandUpPositionAtOffset(type, world, pos, js, false);
    }

    private static Optional<Vec3> findStandUpPositionAtOffset(EntityType<?> type, CollisionGetter world, BlockPos pos, int[][] possibleOffsets, boolean ignoreInvalidPos) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int[] is : possibleOffsets) {
            mutable.set(pos.getX() + is[0], pos.getY(), pos.getZ() + is[1]);
            Vec3 vec3d = DismountHelper.findSafeDismountLocation(type, (CollisionGetter)world, (BlockPos)mutable, (boolean)ignoreInvalidPos);
            if (vec3d == null) continue;
            return Optional.of(vec3d);
        }
        return Optional.empty();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, PART, OCCUPIED});
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        if (!world.isClientSide) {
            BlockPos blockPos = pos.relative((Direction)state.getValue((Property)FACING));
            world.setBlock(blockPos, (BlockState)state.setValue(PART, (Comparable)BedPart.HEAD), 3);
            world.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
        }
    }

    protected long getSeed(BlockState state, BlockPos pos) {
        BlockPos blockPos = pos.relative((Direction)state.getValue((Property)FACING), state.getValue(PART) == BedPart.HEAD ? 0 : 1);
        return Mth.getSeed((int)blockPos.getX(), (int)pos.getY(), (int)blockPos.getZ());
    }

    protected boolean isPathfindable(BlockState state, PathComputationType type) {
        return false;
    }

    private static int[][] bedStandUpOffsets(Direction bedDirection, Direction respawnDirection) {
        return (int[][])ArrayUtils.addAll((Object[])FurnitureBedBlock.bedSurroundStandUpOffsets(bedDirection, respawnDirection), (Object[])FurnitureBedBlock.bedAboveStandUpOffsets(bedDirection));
    }

    private static int[][] bedSurroundStandUpOffsets(Direction bedDirection, Direction respawnDirection) {
        return new int[][]{{respawnDirection.getStepX(), respawnDirection.getStepZ()}, {respawnDirection.getStepX() - bedDirection.getStepX(), respawnDirection.getStepZ() - bedDirection.getStepZ()}, {respawnDirection.getStepX() - bedDirection.getStepX() * 2, respawnDirection.getStepZ() - bedDirection.getStepZ() * 2}, {-bedDirection.getStepX() * 2, -bedDirection.getStepZ() * 2}, {-respawnDirection.getStepX() - bedDirection.getStepX() * 2, -respawnDirection.getStepZ() - bedDirection.getStepZ() * 2}, {-respawnDirection.getStepX() - bedDirection.getStepX(), -respawnDirection.getStepZ() - bedDirection.getStepZ()}, {-respawnDirection.getStepX(), -respawnDirection.getStepZ()}, {-respawnDirection.getStepX() + bedDirection.getStepX(), -respawnDirection.getStepZ() + bedDirection.getStepZ()}, {bedDirection.getStepX(), bedDirection.getStepZ()}, {respawnDirection.getStepX() + bedDirection.getStepX(), respawnDirection.getStepZ() + bedDirection.getStepZ()}};
    }

    private static int[][] bedAboveStandUpOffsets(Direction bedDirection) {
        return new int[][]{{0, 0}, {-bedDirection.getStepX(), -bedDirection.getStepZ()}};
    }

    static {
        EAST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_SOUTH_WEST, LEG_NORTH_EAST});
        SOUTH_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_NORTH_EAST, LEG_SOUTH_EAST});
        WEST_SHAPE = Shapes.or((VoxelShape)BASE, (VoxelShape[])new VoxelShape[]{LEG_SOUTH_EAST, LEG_NORTH_WEST});
    }
}

