/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.init;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class KitchenCounterBlock
extends HorizontalDirectionalBlock {
    public static final BooleanProperty LEFT = BooleanProperty.create((String)"left");
    public static final BooleanProperty RIGHT = BooleanProperty.create((String)"right");
    public static final MapCodec<KitchenCounterBlock> CODEC = KitchenCounterBlock.simpleCodec(KitchenCounterBlock::new);
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public KitchenCounterBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LEFT, (Comparable)Boolean.valueOf(false))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<? extends HorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block sourceBlock, BlockPos sourcePos, boolean notify) {
        Direction direction2;
        super.neighborChanged(state, world, pos, sourceBlock, sourcePos, notify);
        if (world.isClientSide()) {
            return;
        }
        Direction direction = (Direction)state.getValue((Property)FACING);
        BlockState blockState = world.getBlockState(pos.relative(direction));
        if (KitchenCounterBlock.isCounter(blockState) && (direction2 = (Direction)blockState.getValue((Property)FACING)).getAxis() != ((Direction)state.getValue((Property)FACING)).getAxis() && KitchenCounterBlock.isDifferentOrientation(state, (BlockGetter)world, pos, direction2.getOpposite())) {
            boolean leftConnected = this.isLeftConnected(world, pos, direction);
            boolean rightConnected = this.isRightConnected(world, pos, direction);
            BlockState newState = (BlockState)((BlockState)state.setValue((Property)LEFT, (Comparable)Boolean.valueOf(leftConnected))).setValue((Property)RIGHT, (Comparable)Boolean.valueOf(rightConnected));
            if (!newState.equals(state)) {
                world.setBlock(pos, newState, 2);
            }
        }
    }

    public static boolean isCounter(BlockState state) {
        return state.getBlock() instanceof KitchenCounterBlock;
    }

    private static boolean isDifferentOrientation(BlockState state, BlockGetter world, BlockPos pos, Direction dir) {
        BlockState blockState = world.getBlockState(pos.relative(dir));
        return !KitchenCounterBlock.isCounter(blockState) || blockState.getValue((Property)FACING) != state.getValue((Property)FACING);
    }

    private boolean isLeftConnected(Level world, BlockPos pos, Direction facing) {
        BlockState neighborState = world.getBlockState(pos.relative(facing.getCounterClockWise()));
        return neighborState.getBlock() == this && neighborState.getValue((Property)FACING) == facing;
    }

    private boolean isRightConnected(Level world, BlockPos pos, Direction facing) {
        BlockState neighborState = world.getBlockState(pos.relative(facing.getClockWise()));
        return neighborState.getBlock() == this && neighborState.getValue((Property)FACING) == facing;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction facing = context.getHorizontalDirection().getOpposite();
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)facing);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LEFT, RIGHT});
    }

    public VoxelShape getShape(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }
}

