/*
 * Decompiled with CFR 0.152.
 */
package com.skniro.skniro_furniture.block.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.skniro.skniro_furniture.block.entity.OvenBlockEntity;
import com.skniro.skniro_furniture.block.init.OvenBlock;
import com.skniro.skniro_furniture.block.renderer.state.OvenBlockEntityRenderState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class OvenBlockEntityRenderer
implements BlockEntityRenderer<OvenBlockEntity, OvenBlockEntityRenderState> {
    private static final ResourceLocation LIGHT_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"skniro_furniture", (String)"textures/block/oven_light.png");

    public OvenBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void submit(OvenBlockEntityRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraRenderState) {
        Direction facing = (Direction)state.blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        if (!(state.blockState.getBlock() instanceof OvenBlock)) {
            return;
        }
        matrices.pushPose();
        switch (facing) {
            case NORTH: {
                matrices.translate(0.5, 0.4, 0.15);
                break;
            }
            case SOUTH: {
                matrices.translate(0.5, 0.4, 0.85);
                break;
            }
            case WEST: {
                matrices.translate(0.15, 0.4, 0.5);
                break;
            }
            case EAST: {
                matrices.translate(0.85, 0.4, 0.5);
            }
        }
        float angle = switch (facing) {
            case Direction.NORTH -> 0.0f;
            case Direction.SOUTH -> 180.0f;
            case Direction.WEST -> 90.0f;
            case Direction.EAST -> -90.0f;
            default -> 0.0f;
        };
        matrices.mulPose((Quaternionfc)Axis.YP.rotationDegrees(angle));
        if (((Boolean)state.blockState.getValue((Property)OvenBlock.LIT)).booleanValue()) {
            queue.submitCustomGeometry(matrices, RenderType.eyes((ResourceLocation)LIGHT_TEXTURE), (matricesEntry, vertexConsumer) -> {
                Matrix4f mat = matricesEntry.pose();
                int light = 0xF000F0;
                this.drawQuad(mat, vertexConsumer, -2130706688, light);
            });
        }
        this.renderItemAsIcon(state, matrices, queue);
        matrices.popPose();
    }

    private void drawQuad(Matrix4f mat, VertexConsumer vc, int color, int light) {
        vc.addVertex(mat, -0.3f, 0.21f, 0.0f).setColor(color).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(mat, 0.3f, 0.21f, 0.0f).setColor(color).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(mat, 0.3f, -0.21f, 0.0f).setColor(color).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
        vc.addVertex(mat, -0.3f, -0.21f, 0.0f).setColor(color).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(0.0f, 0.0f, -1.0f);
    }

    private void renderItemAsIcon(OvenBlockEntityRenderState state, PoseStack matrices, SubmitNodeCollector queue) {
        matrices.pushPose();
        matrices.scale(0.4f, 0.4f, 0.4f);
        matrices.translate(0.0, 0.3, 0.3);
        state.item.submit(matrices, queue, state.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        matrices.popPose();
    }

    public OvenBlockEntityRenderState createRenderState() {
        return new OvenBlockEntityRenderState();
    }

    public void extractRenderState(OvenBlockEntity entity, OvenBlockEntityRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState((BlockEntity)entity, (BlockEntityRenderState)state, tickProgress, cameraPos, crumblingOverlay);
        ItemModelResolver itemModelResolver = Minecraft.getInstance().getItemModelResolver();
        itemModelResolver.updateForTopItem(state.item, entity.getRenderStack(), ItemDisplayContext.GUI, entity.getLevel(), null, 1);
        state.blockPos = entity.getBlockPos();
        state.blockState = entity.getBlockState();
    }
}

