/*
 * Decompiled with CFR 0.152.
 */
package com.example.doublejumpz;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class DoubleJumpZ
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private FileConfiguration messages;
    private File messagesFile;
    private Set<UUID> doubleJumpEnabled = new HashSet<UUID>();
    private Map<UUID, Long> lastJumpTime = new HashMap<UUID, Long>();
    private Map<UUID, Long> lastToggleTime = new HashMap<UUID, Long>();
    private double jumpForce;
    private double jumpHeight;
    private long jumpCooldownTime;
    private long toggleCooldownTime;
    private boolean enableParticles;
    private boolean enableSound;
    private boolean enableByDefault;
    private boolean showJumpMessages;
    private boolean showCooldownMessages;
    private boolean showPreventedToggleMessage;
    private String soundEffect;

    public void onEnable() {
        this.saveDefaultConfig();
        this.createMessagesConfig();
        this.config = this.getConfig();
        this.loadMessagesConfig();
        this.loadConfigValues();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("doublejumpz").setExecutor((CommandExecutor)new DoubleJumpCommand());
        this.getLogger().info("DoubleJumpZ has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("DoubleJumpZ has been disabled!");
    }

    private void createMessagesConfig() {
        this.messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!this.messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
    }

    private void loadMessagesConfig() {
        this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    private void loadConfigValues() {
        this.jumpForce = this.config.getDouble("jump-settings.force", 1.0);
        this.jumpHeight = this.config.getDouble("jump-settings.height", 15.0);
        this.jumpCooldownTime = this.config.getLong("jump-settings.cooldown", 1000L);
        this.toggleCooldownTime = this.config.getLong("toggle-settings.cooldown", 2000L);
        this.enableParticles = this.config.getBoolean("effects.particles", true);
        this.enableSound = this.config.getBoolean("effects.sound.enabled", true);
        this.enableByDefault = this.config.getBoolean("general.enable-by-default", true);
        this.showJumpMessages = this.config.getBoolean("messages.show-jump-messages", true);
        this.showCooldownMessages = this.config.getBoolean("messages.show-cooldown-messages", true);
        this.showPreventedToggleMessage = this.config.getBoolean("toggle-settings.show-prevented-message", true);
        this.soundEffect = this.config.getString("effects.sound.type", "ENTITY_BAT_TAKEOFF");
    }

    private String getMessage(String path, String defaultMessage) {
        String message = this.messages.getString(path, defaultMessage);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    private String getMessage(String path, String defaultMessage, String placeholder, String value) {
        String message = this.getMessage(path, defaultMessage);
        return message.replace(placeholder, value);
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.enableByDefault && player.hasPermission("doublejumpz.use")) {
            this.doubleJumpEnabled.add(player.getUniqueId());
            player.setAllowFlight(true);
        }
    }

    @EventHandler
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.doubleJumpEnabled.contains(playerId) && player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
            String jumpMsg;
            long lastJump;
            long timeSinceLastJump;
            event.setCancelled(true);
            long currentTime = System.currentTimeMillis();
            if (this.lastJumpTime.containsKey(playerId) && (timeSinceLastJump = currentTime - (lastJump = this.lastJumpTime.get(playerId).longValue())) < this.jumpCooldownTime) {
                double remainingSeconds;
                String cooldownMsg;
                if (this.showCooldownMessages && !(cooldownMsg = this.getMessage("jump.cooldown", "&cYou must wait &e{cooldown}s &cbefore jumping again!", "{cooldown}", String.format("%.1f", remainingSeconds = (double)(this.jumpCooldownTime - timeSinceLastJump) / 1000.0))).isEmpty()) {
                    player.sendMessage(cooldownMsg);
                }
                return;
            }
            Vector velocity = player.getLocation().getDirection().multiply(this.jumpForce).setY(this.jumpHeight);
            player.setVelocity(velocity);
            this.lastJumpTime.put(playerId, currentTime);
            if (this.enableSound) {
                try {
                    Sound sound = Sound.valueOf((String)this.soundEffect);
                    player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid sound effect in config: " + this.soundEffect);
                }
            }
            if (this.enableParticles) {
                player.getWorld().spawnParticle(Particle.CLOUD, player.getLocation(), 20, 0.5, 0.5, 0.5, 0.1);
            }
            if (this.showJumpMessages && !(jumpMsg = this.getMessage("jump.success", "&aYou performed a double jump!")).isEmpty()) {
                player.sendMessage(jumpMsg);
            }
            player.setFallDistance(0.0f);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.doubleJumpEnabled.contains(playerId) && player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR && player.isOnGround()) {
            player.setAllowFlight(true);
        }
    }

    private class DoubleJumpCommand
    implements CommandExecutor {
        private DoubleJumpCommand() {
        }

        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            long lastToggle;
            long timeSinceLastToggle;
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("doublejumpz.admin")) {
                    String noPermMsg = DoubleJumpZ.this.getMessage("command.no-permission", "&cYou don't have permission to use this command!");
                    sender.sendMessage(noPermMsg);
                    return true;
                }
                DoubleJumpZ.this.reloadConfig();
                DoubleJumpZ.this.config = DoubleJumpZ.this.getConfig();
                DoubleJumpZ.this.loadMessagesConfig();
                DoubleJumpZ.this.loadConfigValues();
                String reloadedMsg = DoubleJumpZ.this.getMessage("command.reloaded", "&aDoubleJumpZ configuration reloaded!");
                sender.sendMessage(reloadedMsg);
                return true;
            }
            if (!(sender instanceof Player)) {
                String consoleMsg = DoubleJumpZ.this.getMessage("command.console-only", "&cThis command can only be used by players!");
                sender.sendMessage(consoleMsg);
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("doublejumpz.use")) {
                String noPermMsg = DoubleJumpZ.this.getMessage("command.no-permission", "&cYou don't have permission to use this command!");
                player.sendMessage(noPermMsg);
                return true;
            }
            UUID playerId = player.getUniqueId();
            long currentTime = System.currentTimeMillis();
            if (DoubleJumpZ.this.lastToggleTime.containsKey(playerId) && (timeSinceLastToggle = currentTime - (lastToggle = DoubleJumpZ.this.lastToggleTime.get(playerId).longValue())) < DoubleJumpZ.this.toggleCooldownTime) {
                if (DoubleJumpZ.this.showPreventedToggleMessage) {
                    String cooldownInfo;
                    double remainingSeconds = (double)(DoubleJumpZ.this.toggleCooldownTime - timeSinceLastToggle) / 1000.0;
                    String preventedMsg = DoubleJumpZ.this.getMessage("toggle.prevented", "&7Double jump toggle prevented (too quick!)");
                    if (!preventedMsg.isEmpty()) {
                        player.sendMessage(preventedMsg);
                    }
                    if (!(cooldownInfo = DoubleJumpZ.this.getMessage("toggle.cooldown-info", "&7Toggle cooldown: &e{cooldown}s", "{cooldown}", String.format("%.1f", remainingSeconds))).isEmpty()) {
                        player.sendMessage(cooldownInfo);
                    }
                }
                return true;
            }
            DoubleJumpZ.this.lastToggleTime.put(playerId, currentTime);
            if (DoubleJumpZ.this.doubleJumpEnabled.contains(playerId)) {
                DoubleJumpZ.this.doubleJumpEnabled.remove(playerId);
                player.setAllowFlight(false);
                String disabledMsg = DoubleJumpZ.this.getMessage("command.disabled", "&cDouble Jump disabled!");
                player.sendMessage(disabledMsg);
            } else {
                DoubleJumpZ.this.doubleJumpEnabled.add(playerId);
                player.setAllowFlight(true);
                String enabledMsg = DoubleJumpZ.this.getMessage("command.enabled", "&aDouble Jump enabled!");
                player.sendMessage(enabledMsg);
            }
            return true;
        }
    }
}

