/*
 * Decompiled with CFR 0.152.
 */
package com.example.doublejumpz;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Vector;

public class DoubleJumpZ
extends JavaPlugin
implements Listener {
    private FileConfiguration config;
    private Set<UUID> doubleJumpEnabled = new HashSet<UUID>();
    private Map<UUID, Long> lastJumpTime = new HashMap<UUID, Long>();
    private double jumpForce;
    private double jumpHeight;
    private long cooldownTime;
    private boolean enableParticles;
    private boolean enableSound;
    private boolean enableByDefault;
    private String jumpMessage;
    private String soundEffect;

    @Override
    public void onEnable() {
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.loadConfigValues();
        this.getServer().getPluginManager().registerEvents(this, this);
        this.getCommand("doublejumpz").setExecutor(new DoubleJumpCommand());
        this.getLogger().info("DoubleJumpZ has been enabled!");
    }

    @Override
    public void onDisable() {
        this.getLogger().info("DoubleJumpZ has been disabled!");
    }

    private void loadConfigValues() {
        this.jumpForce = this.config.getDouble("jump-settings.force", 1.0);
        this.jumpHeight = this.config.getDouble("jump-settings.height", 1.0);
        this.cooldownTime = this.config.getLong("jump-settings.cooldown", 1000L);
        this.enableParticles = this.config.getBoolean("effects.particles", true);
        this.enableSound = this.config.getBoolean("effects.sound.enabled", true);
        this.enableByDefault = this.config.getBoolean("general.enable-by-default", true);
        this.jumpMessage = ChatColor.translateAlternateColorCodes('&', this.config.getString("messages.jump", "&aYou performed a double jump!"));
        this.soundEffect = this.config.getString("effects.sound.type", "ENTITY_BAT_TAKEOFF");
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.enableByDefault && player.hasPermission("doublejumpz.use")) {
            this.doubleJumpEnabled.add(player.getUniqueId());
            player.setAllowFlight(true);
        }
    }

    @EventHandler
    public void onPlayerToggleFlight(PlayerToggleFlightEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.doubleJumpEnabled.contains(playerId) && player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR) {
            long lastJump;
            event.setCancelled(true);
            long currentTime = System.currentTimeMillis();
            if (this.lastJumpTime.containsKey(playerId) && currentTime - (lastJump = this.lastJumpTime.get(playerId).longValue()) < this.cooldownTime) {
                return;
            }
            Vector velocity = player.getLocation().getDirection().multiply(this.jumpForce).setY(this.jumpHeight);
            player.setVelocity(velocity);
            this.lastJumpTime.put(playerId, currentTime);
            if (this.enableSound) {
                try {
                    Sound sound = Sound.valueOf(this.soundEffect);
                    player.playSound(player.getLocation(), sound, 1.0f, 1.0f);
                }
                catch (IllegalArgumentException e) {
                    this.getLogger().warning("Invalid sound effect in config: " + this.soundEffect);
                }
            }
            if (this.enableParticles) {
                player.getWorld().spawnParticle(Particle.CLOUD, player.getLocation(), 20, 0.5, 0.5, 0.5, 0.1);
            }
            if (!this.jumpMessage.isEmpty()) {
                player.sendMessage(this.jumpMessage);
            }
            player.setFallDistance(0.0f);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        UUID playerId = player.getUniqueId();
        if (this.doubleJumpEnabled.contains(playerId) && player.getGameMode() != GameMode.CREATIVE && player.getGameMode() != GameMode.SPECTATOR && player.isOnGround()) {
            player.setAllowFlight(true);
        }
    }

    private class DoubleJumpCommand
    implements CommandExecutor {
        private DoubleJumpCommand() {
        }

        @Override
        public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
            if (!(sender instanceof Player)) {
                sender.sendMessage(String.valueOf((Object)ChatColor.RED) + "This command can only be used by players.");
                return true;
            }
            Player player = (Player)sender;
            if (!player.hasPermission("doublejumpz.use")) {
                player.sendMessage(String.valueOf((Object)ChatColor.RED) + "You don't have permission to use this command.");
                return true;
            }
            UUID playerId = player.getUniqueId();
            if (DoubleJumpZ.this.doubleJumpEnabled.contains(playerId)) {
                DoubleJumpZ.this.doubleJumpEnabled.remove(playerId);
                player.setAllowFlight(false);
                player.sendMessage(String.valueOf((Object)ChatColor.RED) + "Double Jump disabled.");
            } else {
                DoubleJumpZ.this.doubleJumpEnabled.add(playerId);
                player.setAllowFlight(true);
                player.sendMessage(String.valueOf((Object)ChatColor.GREEN) + "Double Jump enabled.");
            }
            return true;
        }
    }
}

