/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.universal;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import snownee.jade.api.Accessor;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IDisplayHelper;
import snownee.jade.api.ui.IElementHelper;
import snownee.jade.api.ui.IProgressStyle;
import snownee.jade.api.view.ClientViewGroup;
import snownee.jade.api.view.FluidView;
import snownee.jade.api.view.IClientExtensionProvider;
import snownee.jade.api.view.IServerExtensionProvider;
import snownee.jade.api.view.ViewGroup;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.WailaCommonRegistration;
import snownee.jade.util.CommonProxy;

public enum FluidStorageProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>,
IServerExtensionProvider<Object, class_2487>,
IClientExtensionProvider<class_2487, FluidView>
{
    INSTANCE;


    public static void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        if (!accessor.showDetails() && config.get(Identifiers.UNIVERSAL_FLUID_STORAGE_DETAILED)) {
            return;
        }
        if (accessor.getServerData().method_10545("JadeFluidStorage")) {
            Optional<IClientExtensionProvider> provider = Optional.ofNullable(class_2960.method_12829((String)accessor.getServerData().method_10558("JadeFluidStorageUid"))).map(WailaClientRegistration.INSTANCE.fluidStorageProviders::get);
            if (provider.isPresent()) {
                List groups = provider.get().getClientGroups(accessor, ViewGroup.readList(accessor.getServerData(), "JadeFluidStorage", Function.identity()));
                if (groups.isEmpty()) {
                    return;
                }
                IElementHelper helper = IElementHelper.get();
                boolean renderGroup = groups.size() > 1 || groups.get(0).shouldRenderGroup();
                ClientViewGroup.tooltip(tooltip, groups, renderGroup, (theTooltip, group) -> {
                    if (renderGroup) {
                        group.renderHeader((ITooltip)theTooltip);
                    }
                    for (FluidView view : group.views) {
                        Object text = view.overrideText != null ? view.overrideText : (view.fluidName == null ? class_2561.method_43470((String)view.current) : class_2561.method_43469((String)"jade.fluid", (Object[])new Object[]{IDisplayHelper.get().stripColor(view.fluidName), view.current}));
                        IProgressStyle progressStyle = helper.progressStyle().overlay(view.overlay);
                        theTooltip.add(helper.progress(view.ratio, (class_2561)text, progressStyle, BoxStyle.DEFAULT, true));
                    }
                });
            }
        }
    }

    public static void putData(Accessor<?> accessor) {
        class_2487 tag = accessor.getServerData();
        Object target = accessor.getTarget();
        class_3222 player = (class_3222)accessor.getPlayer();
        boolean showDetails = accessor.showDetails();
        for (IServerExtensionProvider<Object, class_2487> provider : WailaCommonRegistration.INSTANCE.fluidStorageProviders.get(target)) {
            List groups = provider.getGroups(player, player.method_51469(), target, showDetails);
            if (groups == null) continue;
            if (ViewGroup.saveList(tag, "JadeFluidStorage", groups, Function.identity())) {
                tag.method_10582("JadeFluidStorageUid", provider.getUid().toString());
            }
            return;
        }
    }

    @Override
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        FluidStorageProvider.append(tooltip, accessor, config);
    }

    @Override
    public void appendServerData(class_2487 data, BlockAccessor accessor) {
        FluidStorageProvider.putData(accessor);
    }

    @Override
    public class_2960 getUid() {
        return Identifiers.UNIVERSAL_FLUID_STORAGE;
    }

    @Override
    public int getDefaultPriority() {
        return 1000;
    }

    @Override
    public List<ClientViewGroup<FluidView>> getClientGroups(Accessor<?> accessor, List<ViewGroup<class_2487>> groups) {
        return ClientViewGroup.map(groups, FluidView::readDefault, null);
    }

    @Override
    public List<ViewGroup<class_2487>> getGroups(class_3222 player, class_3218 world, Object target, boolean showDetails) {
        return CommonProxy.wrapFluidStorage(target, player);
    }
}

