/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import java.util.Objects;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import org.joml.Vector3f;
import snownee.jade.api.config.IWailaConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IProgressStyle;
import snownee.jade.overlay.DisplayHelper;
import snownee.jade.overlay.OverlayRenderer;
import snownee.jade.util.Color;

public class ProgressStyle
implements IProgressStyle {
    public boolean autoTextColor = true;
    public int color;
    public int color2;
    public int textColor;
    public boolean vertical;
    public IElement overlay;
    @Deprecated
    public boolean glowText;
    public boolean shadow = true;

    public ProgressStyle() {
        this.color(-1);
    }

    private static Vector3f RGBtoHSV(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int max = Math.max(r, Math.max(g, b));
        int min = Math.min(r, Math.min(g, b));
        float v = max;
        float delta = max - min;
        if (max == 0) {
            float s = 0.0f;
            float h = -1.0f;
            return new Vector3f(h, s, 0.0f);
        }
        float s = delta / (float)max;
        float h = r == max ? (float)(g - b) / delta : (g == max ? 2.0f + (float)(b - r) / delta : 4.0f + (float)(r - g) / delta);
        h /= 6.0f;
        if (h < 0.0f) {
            h += 1.0f;
        }
        return new Vector3f(h, s, v / 255.0f);
    }

    @Override
    public IProgressStyle color(int color, int color2) {
        this.color = color;
        this.color2 = color2;
        return this;
    }

    @Override
    public IProgressStyle vertical(boolean vertical) {
        this.vertical = vertical;
        return this;
    }

    @Override
    public IProgressStyle overlay(IElement overlay) {
        this.overlay = overlay;
        return this;
    }

    @Override
    public void render(class_332 guiGraphics, float x, float y, float width, float height, float progress, class_2561 text) {
        progress *= this.choose(true, width, height);
        float progressY = y;
        if (this.vertical) {
            progressY += height - progress;
        }
        if (progress > 0.0f) {
            if (this.overlay != null) {
                class_241 size = new class_241(this.choose(true, progress, width), this.choose(false, progress, height));
                this.overlay.size(size);
                this.overlay.render(guiGraphics, x, progressY, size.field_1343, size.field_1342);
            } else {
                Color color3 = Color.rgb(this.color);
                int lighter = Color.hsl(color3.getHue(), color3.getSaturation(), color3.getLightness() * (double)0.7f, color3.getOpacity()).toInt();
                float half = this.choose(true, height, width) / 2.0f;
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x, progressY, this.choose(true, progress, half), this.choose(false, progress, half), lighter, this.color, this.vertical);
                DisplayHelper.INSTANCE.drawGradientRect(guiGraphics, x + this.choose(false, half, 0.0f), progressY + this.choose(true, half, 0.0f), this.choose(true, progress, half), this.choose(false, progress, half), this.color, lighter, this.vertical);
                if (this.color != this.color2) {
                    if (this.vertical) {
                        for (float yy = y + height; yy > progressY; yy -= 2.0f) {
                            float fy = Math.max(progressY, yy + 1.0f);
                            DisplayHelper.fill(guiGraphics, x, yy, x + width, fy, this.color2);
                        }
                    } else {
                        for (float xx = x + 1.0f; xx < x + progress; xx += 2.0f) {
                            float fx = Math.min(x + width, xx + 1.0f);
                            DisplayHelper.fill(guiGraphics, xx, y, fx, y + height, this.color2);
                        }
                    }
                }
            }
        }
        if (text != null) {
            class_327 font = class_310.method_1551().field_1772;
            if (this.autoTextColor) {
                this.autoTextColor = false;
                if (this.overlay == null && ProgressStyle.RGBtoHSV(this.color2).z() > 0.75f) {
                    this.textColor = -16777216;
                    this.shadow = false;
                } else {
                    this.textColor = -1;
                }
            }
            Objects.requireNonNull(font);
            y += height - 9.0f;
            if (this.vertical) {
                Objects.requireNonNull(font);
                if (9.0f < progress) {
                    y -= progress;
                    Objects.requireNonNull(font);
                    y += (float)(9 + 2);
                }
            }
            int color = IWailaConfig.IConfigOverlay.applyAlpha(this.textColor, OverlayRenderer.alpha);
            if (this.glowText) {
                class_4597.class_4598 multibuffersource$buffersource = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
                font.method_37296(text.method_30937(), x + 1.0f, y, -1, -13421773, guiGraphics.method_51448().method_23760().method_23761(), (class_4597)multibuffersource$buffersource, 0xF000F0);
                multibuffersource$buffersource.method_22993();
            } else {
                guiGraphics.method_51439(font, text, (int)x + 1, (int)y, color, this.shadow);
            }
        }
    }

    private float choose(boolean expand, float x, float y) {
        return this.vertical ^ expand ? x : y;
    }

    @Override
    public IProgressStyle textColor(int color) {
        this.textColor = color;
        this.autoTextColor = false;
        return this;
    }

    public IProgressStyle glowText(boolean glowText) {
        this.glowText = glowText;
        return this;
    }
}

