/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.List;
import link.infra.indium.renderer.IndiumRenderer;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.helper.ColorHelper;
import link.infra.indium.renderer.material.RenderMaterialImpl;
import link.infra.indium.renderer.mesh.EncodingFormat;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.AbstractRenderContext;
import link.infra.indium.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_761;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBlockRenderContext
extends AbstractRenderContext {
    protected BlockRenderInfo blockInfo;
    protected AoCalculator aoCalc;
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            AbstractBlockRenderContext.this.renderQuad(this, false);
        }
    };
    private final BakedModelConsumerImpl vanillaModelConsumer = new BakedModelConsumerImpl();
    private final class_2338.class_2339 lightPos = new class_2338.class_2339();

    protected abstract void bufferQuad(MutableQuadViewImpl var1, class_1921 var2);

    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public RenderContext.BakedModelConsumer bakedModelConsumer() {
        return this.vanillaModelConsumer;
    }

    private void renderQuad(MutableQuadViewImpl quad, boolean isVanilla) {
        if (!this.transform((MutableQuadView)quad)) {
            return;
        }
        if (!this.blockInfo.shouldDrawFace(quad.cullFace())) {
            return;
        }
        RenderMaterialImpl mat = quad.material();
        int colorIndex = mat.disableColorIndex() ? -1 : quad.colorIndex();
        TriState aoMode = mat.ambientOcclusion();
        boolean ao = this.blockInfo.useAo && (aoMode == TriState.TRUE || aoMode == TriState.DEFAULT && this.blockInfo.defaultAo);
        boolean emissive = mat.emissive();
        class_1921 renderLayer = this.blockInfo.effectiveRenderLayer(mat.blendMode());
        this.colorizeQuad(quad, colorIndex);
        this.shadeQuad(quad, isVanilla, ao, emissive);
        this.bufferQuad(quad, renderLayer);
    }

    private void colorizeQuad(MutableQuadViewImpl quad, int colorIndex) {
        if (colorIndex != -1) {
            int blockColor = this.blockInfo.blockColor(colorIndex);
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyColor(blockColor, quad.color(i)));
            }
        }
    }

    protected void shadeQuad(MutableQuadViewImpl quad, boolean isVanilla, boolean ao, boolean emissive) {
        if (ao) {
            this.aoCalc.compute(quad, isVanilla);
            if (emissive) {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), this.aoCalc.ao[i]));
                    quad.lightmap(i, 0xF000F0);
                }
            } else {
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), this.aoCalc.ao[i]));
                    quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), this.aoCalc.light[i]));
                }
            }
        } else {
            this.shadeFlatQuad(quad);
            if (emissive) {
                for (int i = 0; i < 4; ++i) {
                    quad.lightmap(i, 0xF000F0);
                }
            } else {
                int brightness = this.flatBrightness(quad, this.blockInfo.blockState, this.blockInfo.blockPos);
                for (int i = 0; i < 4; ++i) {
                    quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), brightness));
                }
            }
        }
    }

    private void shadeFlatQuad(MutableQuadViewImpl quad) {
        block3: {
            block2: {
                if (!quad.hasVertexNormals()) break block2;
                float faceShade = this.blockInfo.blockView.method_24852(quad.lightFace(), quad.hasShade());
                for (int i = 0; i < 4; ++i) {
                    quad.color(i, ColorHelper.multiplyRGB(quad.color(i), this.vertexShade(quad, i, faceShade)));
                }
                break block3;
            }
            float diffuseShade = this.blockInfo.blockView.method_24852(quad.lightFace(), quad.hasShade());
            if (diffuseShade == 1.0f) break block3;
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorHelper.multiplyRGB(quad.color(i), diffuseShade));
            }
        }
    }

    private float vertexShade(MutableQuadViewImpl quad, int vertexIndex, float faceShade) {
        return quad.hasNormal(vertexIndex) ? this.normalShade(quad.normalX(vertexIndex), quad.normalY(vertexIndex), quad.normalZ(vertexIndex), quad.hasShade()) : faceShade;
    }

    private float normalShade(float normalX, float normalY, float normalZ, boolean hasShade) {
        float sum = 0.0f;
        float div = 0.0f;
        if (normalX > 0.0f) {
            sum += normalX * this.blockInfo.blockView.method_24852(class_2350.field_11034, hasShade);
            div += normalX;
        } else if (normalX < 0.0f) {
            sum += -normalX * this.blockInfo.blockView.method_24852(class_2350.field_11039, hasShade);
            div -= normalX;
        }
        if (normalY > 0.0f) {
            sum += normalY * this.blockInfo.blockView.method_24852(class_2350.field_11036, hasShade);
            div += normalY;
        } else if (normalY < 0.0f) {
            sum += -normalY * this.blockInfo.blockView.method_24852(class_2350.field_11033, hasShade);
            div -= normalY;
        }
        if (normalZ > 0.0f) {
            sum += normalZ * this.blockInfo.blockView.method_24852(class_2350.field_11035, hasShade);
            div += normalZ;
        } else if (normalZ < 0.0f) {
            sum += -normalZ * this.blockInfo.blockView.method_24852(class_2350.field_11043, hasShade);
            div -= normalZ;
        }
        return sum / div;
    }

    private int flatBrightness(MutableQuadViewImpl quad, class_2680 blockState, class_2338 pos) {
        this.lightPos.method_10101((class_2382)pos);
        if (quad.cullFace() != null) {
            this.lightPos.method_10098(quad.cullFace());
        } else {
            int flags = quad.geometryFlags();
            if ((flags & 4) != 0 || (flags & 2) != 0 && blockState.method_26234((class_1922)this.blockInfo.blockView, pos)) {
                this.lightPos.method_10098(quad.lightFace());
            }
        }
        return class_761.method_23793((class_1920)this.blockInfo.blockView, (class_2680)blockState, (class_2338)this.lightPos);
    }

    private class BakedModelConsumerImpl
    implements RenderContext.BakedModelConsumer {
        private static final RenderMaterial MATERIAL_SHADED = IndiumRenderer.INSTANCE.materialFinder().find();
        private static final RenderMaterial MATERIAL_FLAT = IndiumRenderer.INSTANCE.materialFinder().ambientOcclusion(TriState.FALSE).find();
        private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
            {
                this.data = new int[EncodingFormat.TOTAL_STRIDE];
                this.clear();
            }

            @Override
            public void emitDirectly() {
                AbstractBlockRenderContext.this.renderQuad(this, true);
            }
        };

        private BakedModelConsumerImpl() {
        }

        public void accept(class_1087 model) {
            this.accept(model, AbstractBlockRenderContext.this.blockInfo.blockState);
        }

        public void accept(class_1087 model, @Nullable class_2680 state) {
            MutableQuadViewImpl editorQuad = this.editorQuad;
            RenderMaterial defaultMaterial = model.method_4708() ? MATERIAL_SHADED : MATERIAL_FLAT;
            for (int i = 0; i <= 6; ++i) {
                class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
                List quads = model.method_4707(state, cullFace, AbstractBlockRenderContext.this.blockInfo.randomSupplier.get());
                int count = quads.size();
                for (int j = 0; j < count; ++j) {
                    class_777 q = (class_777)quads.get(j);
                    editorQuad.fromVanilla(q, defaultMaterial, cullFace);
                    AbstractBlockRenderContext.this.renderQuad(editorQuad, true);
                }
            }
        }
    }
}

