/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth;

import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import xyz.nikitacartes.easyauth.commands.AccountCommand;
import xyz.nikitacartes.easyauth.commands.AuthCommand;
import xyz.nikitacartes.easyauth.commands.LoginCommand;
import xyz.nikitacartes.easyauth.commands.LogoutCommand;
import xyz.nikitacartes.easyauth.commands.RegisterCommand;
import xyz.nikitacartes.easyauth.event.AuthEventHandler;
import xyz.nikitacartes.easyauth.storage.AuthConfig;
import xyz.nikitacartes.easyauth.storage.PlayerCache;
import xyz.nikitacartes.easyauth.storage.database.DBApiException;
import xyz.nikitacartes.easyauth.storage.database.DbApi;
import xyz.nikitacartes.easyauth.utils.EasyLogger;

public class EasyAuth
implements ModInitializer {
    public static final String MOD_ID = "easyauth";
    public static DbApi DB = null;
    public static final ExecutorService THREADPOOL = Executors.newCachedThreadPool();
    public static final HashMap<String, PlayerCache> playerCacheMap = new HashMap();
    public static final HashSet<String> mojangAccountNamesCache = new HashSet();
    public static Path gameDirectory;
    public static final Properties serverProp;
    public static AuthConfig config;

    public static void init(Path gameDir) {
        gameDirectory = gameDir;
        EasyLogger.LogInfo("EasyAuth mod by samo_lego, NikitaCartes.");
        try {
            serverProp.load(new FileReader(gameDirectory + "/server.properties"));
            if (Boolean.parseBoolean(serverProp.getProperty("enforce-secure-profile"))) {
                EasyLogger.LogWarn("Disable enforce-secure-profile to allow offline players to join the server");
                EasyLogger.LogWarn("For more info, see https://github.com/NikitaCartes/EasyAuth/issues/68");
            }
        }
        catch (IOException e) {
            EasyLogger.LogError("Error while reading server properties: ", e);
        }
        File file = new File(gameDirectory + "/mods/EasyAuth");
        if (!file.exists() && !file.mkdirs()) {
            throw new RuntimeException("[EasyAuth] Error creating directory!");
        }
        config = AuthConfig.load(new File(gameDirectory + "/mods/EasyAuth/config.json"));
    }

    public static void stop() {
        EasyLogger.LogInfo("Shutting down EasyAuth.");
        DB.saveAll(playerCacheMap);
        try {
            THREADPOOL.shutdownNow();
            if (!THREADPOOL.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
                Thread.currentThread().interrupt();
            }
        }
        catch (InterruptedException e) {
            EasyLogger.LogError("Error on stop", e);
            THREADPOOL.shutdownNow();
        }
        DB.close();
    }

    public void onInitialize() {
        EasyAuth.init(FabricLoader.getInstance().getGameDir());
        try {
            DB.connect();
        }
        catch (DBApiException e) {
            EasyLogger.LogError("onInitialize error: ", e);
        }
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated, environment) -> {
            RegisterCommand.registerCommand((CommandDispatcher<class_2168>)dispatcher);
            LoginCommand.registerCommand((CommandDispatcher<class_2168>)dispatcher);
            LogoutCommand.registerCommand((CommandDispatcher<class_2168>)dispatcher);
            AuthCommand.registerCommand((CommandDispatcher<class_2168>)dispatcher);
            AccountCommand.registerCommand((CommandDispatcher<class_2168>)dispatcher);
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, blockPos, blockState, blockEntity) -> AuthEventHandler.onBreakBlock(player));
        UseBlockCallback.EVENT.register((player, world, hand, blockHitResult) -> AuthEventHandler.onUseBlock(player));
        UseItemCallback.EVENT.register((player, world, hand) -> AuthEventHandler.onUseItem(player));
        AttackEntityCallback.EVENT.register((player, world, hand, entity, entityHitResult) -> AuthEventHandler.onAttackEntity(player));
        UseEntityCallback.EVENT.register((player, world, hand, entity, entityHitResult) -> AuthEventHandler.onUseEntity(player));
        ServerLifecycleEvents.START_DATA_PACK_RELOAD.register((server, serverResourceManager) -> AuthCommand.reloadConfig(null));
        ServerLifecycleEvents.SERVER_STARTED.register(this::onStartServer);
        ServerLifecycleEvents.SERVER_STOPPED.register(this::onStopServer);
        class_2960 earlyPhase = new class_2960(MOD_ID, "early");
        ServerLoginConnectionEvents.QUERY_START.addPhaseOrdering(earlyPhase, Event.DEFAULT_PHASE);
        ServerLoginConnectionEvents.QUERY_START.register(earlyPhase, AuthEventHandler::onPreLogin);
    }

    private void onStartServer(MinecraftServer server) {
        if (DB.isClosed()) {
            EasyLogger.LogError("Couldn't connect to database. Stopping server");
            server.method_3747(false);
        }
    }

    private void onStopServer(MinecraftServer server) {
        EasyAuth.stop();
    }

    static {
        serverProp = new Properties();
    }
}

