/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.concurrent.atomic.AtomicInteger;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3222;
import xyz.nikitacartes.easyauth.EasyAuth;
import xyz.nikitacartes.easyauth.storage.PlayerCache;
import xyz.nikitacartes.easyauth.utils.AuthHelper;
import xyz.nikitacartes.easyauth.utils.PlayerAuth;
import xyz.nikitacartes.easyauth.utils.TranslationHelper;

public class LoginCommand {
    public static void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        LiteralCommandNode<class_2168> node = LoginCommand.registerLogin(dispatcher);
        if (EasyAuth.config.experimental.enableAliases) {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"l").requires(Permissions.require((String)"easyauth.commands.login", (boolean)true))).redirect(node));
        }
    }

    public static LiteralCommandNode<class_2168> registerLogin(CommandDispatcher<class_2168> dispatcher) {
        return dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"login").requires(Permissions.require((String)"easyauth.commands.login", (boolean)true))).then(class_2170.method_9244((String)"password", (ArgumentType)StringArgumentType.string()).executes(ctx -> LoginCommand.login((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"password"))))).executes(ctx -> {
            ((class_2168)ctx.getSource()).method_9207().method_7353(TranslationHelper.getEnterPassword(), false);
            return 0;
        }));
    }

    private static int login(class_2168 source, String pass) throws CommandSyntaxException {
        class_3222 player = source.method_9207();
        String uuid = ((PlayerAuth)player).getFakeUuid();
        if (((PlayerAuth)player).isAuthenticated()) {
            player.method_7353(TranslationHelper.getAlreadyAuthenticated(), false);
            return 0;
        }
        EasyAuth.THREADPOOL.submit(() -> {
            PlayerCache playerCache = EasyAuth.playerCacheMap.get(uuid);
            int maxLoginTries = EasyAuth.config.main.maxLoginTries;
            AtomicInteger curLoginTries = playerCache.loginTries;
            AuthHelper.PasswordOptions passwordResult = AuthHelper.checkPassword(uuid, pass.toCharArray());
            if (passwordResult == AuthHelper.PasswordOptions.CORRECT) {
                if (playerCache.lastKicked >= System.currentTimeMillis() - 1000L * EasyAuth.config.experimental.resetLoginAttemptsTime) {
                    player.field_13987.method_14367(TranslationHelper.getWrongPassword());
                    return;
                }
                player.method_7353(TranslationHelper.getSuccessfullyAuthenticated(), false);
                ((PlayerAuth)player).setAuthenticated(true);
                curLoginTries.set(0);
                return;
            }
            if (passwordResult == AuthHelper.PasswordOptions.NOT_REGISTERED) {
                player.method_7353(TranslationHelper.getRegisterRequired(), false);
                return;
            }
            if (curLoginTries.incrementAndGet() == maxLoginTries && maxLoginTries != -1) {
                if (maxLoginTries == 1) {
                    player.field_13987.method_14367(TranslationHelper.getWrongPassword());
                } else {
                    player.field_13987.method_14367(TranslationHelper.getLoginTriesExceeded());
                }
                playerCache.lastKicked = System.currentTimeMillis();
                curLoginTries.set(0);
                return;
            }
            player.method_7353(TranslationHelper.getWrongPassword(), false);
        });
        return 0;
    }
}

