/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.mixin;

import com.mojang.authlib.GameProfile;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import net.minecraft.class_2915;
import net.minecraft.class_3248;
import net.minecraft.class_4844;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.nikitacartes.easyauth.EasyAuth;
import xyz.nikitacartes.easyauth.utils.EasyLogger;

@Mixin(value={class_3248.class})
public abstract class ServerLoginNetworkHandlerMixin {
    @Shadow
    GameProfile field_14160;
    @Shadow
    class_3248.class_3249 field_14163;
    @Final
    @Shadow
    MinecraftServer field_14162;

    @Inject(method={"onHello(Lnet/minecraft/network/packet/c2s/login/LoginHelloC2SPacket;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/authlib/GameProfile;<init>(Ljava/util/UUID;Ljava/lang/String;)V", shift=At.Shift.AFTER, remap=false)}, cancellable=true)
    private void checkPremium(class_2915 packet, CallbackInfo ci) {
        if (this.field_14162.method_3828()) {
            try {
                String playername = packet.comp_765().toLowerCase();
                Pattern pattern = Pattern.compile("^[a-z0-9_]{3,16}$");
                Matcher matcher = pattern.matcher(playername);
                if (EasyAuth.config.main.forcedOfflinePlayers.contains(playername)) {
                    EasyLogger.LogDebug("Player " + playername + " is forced to be offline");
                    EasyAuth.mojangAccountNamesCache.remove(playername);
                    this.field_14163 = class_3248.class_3249.field_14168;
                    this.field_14160 = new GameProfile(null, packet.comp_765());
                    ci.cancel();
                    return;
                }
                if (EasyAuth.mojangAccountNamesCache.contains(playername) || EasyAuth.config.experimental.verifiedOnlinePlayer.contains(playername)) {
                    EasyLogger.LogDebug("Player " + playername + " is cached as online player. Authentication continues as vanilla");
                    EasyAuth.mojangAccountNamesCache.add(playername);
                    return;
                }
                if (EasyAuth.playerCacheMap.containsKey(class_4844.method_43344((String)playername).toString()) || !matcher.matches()) {
                    EasyLogger.LogDebug("Player " + playername + " is cached as offline player");
                    this.field_14163 = class_3248.class_3249.field_14168;
                    this.field_14160 = new GameProfile(null, packet.comp_765());
                    ci.cancel();
                } else {
                    EasyLogger.LogDebug("Checking player " + playername + " for premium status");
                    HttpsURLConnection httpsURLConnection = (HttpsURLConnection)new URL("https://api.mojang.com/users/profiles/minecraft/" + playername).openConnection();
                    httpsURLConnection.setRequestMethod("GET");
                    httpsURLConnection.setConnectTimeout(5000);
                    httpsURLConnection.setReadTimeout(5000);
                    int response = httpsURLConnection.getResponseCode();
                    if (response == 200) {
                        httpsURLConnection.disconnect();
                        EasyLogger.LogDebug("Player " + playername + " has a Mojang account");
                        EasyAuth.mojangAccountNamesCache.add(playername);
                        EasyAuth.config.experimental.verifiedOnlinePlayer.add(playername);
                        EasyAuth.config.save(new File("./mods/EasyAuth/config.json"));
                    } else if (response == 204 || response == 404) {
                        httpsURLConnection.disconnect();
                        EasyLogger.LogDebug("Player " + playername + " doesn't have a Mojang account");
                        this.field_14163 = class_3248.class_3249.field_14168;
                        this.field_14160 = new GameProfile(null, packet.comp_765());
                        ci.cancel();
                    }
                }
            }
            catch (IOException e) {
                EasyLogger.LogError("checkPremium error", e);
            }
        }
    }
}

