/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.storage;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import xyz.nikitacartes.easyauth.EasyAuth;
import xyz.nikitacartes.easyauth.utils.EasyLogger;

public class PlayerCache {
    @Expose
    @SerializedName(value="is_authenticated")
    public boolean isAuthenticated = false;
    @Expose
    public String password = "";
    @Expose
    @SerializedName(value="login_tries")
    public AtomicInteger loginTries = new AtomicInteger();
    @Expose
    @SerializedName(value="last_kicked")
    public long lastKicked = 0L;
    @Expose
    @SerializedName(value="last_ip")
    public String lastIp;
    @Expose
    @SerializedName(value="valid_until")
    public long validUntil;
    @Expose
    @SerializedName(value="was_in_portal")
    public boolean wasInPortal = false;
    public UUID ridingEntityUUID = null;
    public final LastLocation lastLocation = new LastLocation();
    private static final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();

    public static PlayerCache fromJson(class_3222 player, String fakeUuid) {
        EasyLogger.LogDebug(String.format("Creating cache for %s %s", player != null ? player.method_7334().getName() : null, fakeUuid));
        String json = EasyAuth.DB.getUserData(fakeUuid);
        PlayerCache playerCache = !json.isEmpty() ? (PlayerCache)gson.fromJson(json, PlayerCache.class) : new PlayerCache();
        if (player != null) {
            playerCache.lastLocation.dimension = player.method_51469();
            playerCache.lastLocation.position = player.method_19538();
            playerCache.lastLocation.yaw = player.method_36454();
            playerCache.lastLocation.pitch = player.method_36455();
            playerCache.ridingEntityUUID = player.method_5854() != null ? player.method_5854().method_5667() : null;
            playerCache.wasInPortal = false;
        }
        return playerCache;
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static boolean isAuthenticated(String uuid) {
        PlayerCache playerCache = EasyAuth.playerCacheMap.get(uuid);
        return playerCache != null && playerCache.isAuthenticated;
    }

    public static class LastLocation {
        public class_3218 dimension;
        public class_243 position;
        public float yaw;
        public float pitch;
    }
}

