/*
 * Decompiled with CFR 0.152.
 */
package xyz.nikitacartes.easyauth.storage.database;

import com.mongodb.MongoClientException;
import com.mongodb.MongoCommandException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import java.util.ArrayList;
import java.util.HashMap;
import org.bson.Document;
import xyz.nikitacartes.easyauth.storage.AuthConfig;
import xyz.nikitacartes.easyauth.storage.PlayerCache;
import xyz.nikitacartes.easyauth.storage.database.DBApiException;
import xyz.nikitacartes.easyauth.storage.database.DbApi;
import xyz.nikitacartes.easyauth.utils.EasyLogger;

public class MongoDB
implements DbApi {
    private final AuthConfig config;
    private MongoCollection<Document> collection;
    private MongoClient mongoClient;

    public MongoDB(AuthConfig config) {
        this.config = config;
    }

    @Override
    public void connect() throws DBApiException {
        EasyLogger.LogDebug("You are using Mongo DB");
        try {
            this.mongoClient = MongoClients.create((String)this.config.main.MongoDBConnectionString);
            MongoDatabase database = this.mongoClient.getDatabase(this.config.main.MongoDBDatabase);
            this.collection = database.getCollection("players");
        }
        catch (MongoClientException | MongoCommandException e) {
            throw new DBApiException("Failed connecting to MongoDB", (Exception)e);
        }
    }

    @Override
    public void close() {
        this.mongoClient.close();
        EasyLogger.LogInfo("Database connection closed successfully.");
        this.mongoClient = null;
        this.collection = null;
    }

    @Override
    public boolean isClosed() {
        return this.mongoClient == null;
    }

    @Override
    public boolean registerUser(String uuid, String data) {
        EasyLogger.LogError("RegisterUser isn't implemented in MongoDB");
        return false;
    }

    @Override
    public boolean isUserRegistered(String uuid) {
        return this.collection.find(Filters.eq((String)"UUID", (Object)uuid)).iterator().hasNext();
    }

    @Override
    public void deleteUserData(String uuid) {
        this.collection.deleteOne(Filters.eq((String)"UUID", (Object)uuid));
    }

    @Override
    public void updateUserData(String uuid, String data) {
        EasyLogger.LogError("updateUserData isn't implemented in MongoDB");
    }

    @Override
    public String getUserData(String uuid) {
        if (this.isUserRegistered(uuid)) {
            Document data = (Document)this.collection.find(Filters.eq((String)"UUID", (Object)uuid)).iterator().next();
            return data.toJson();
        }
        return "";
    }

    @Override
    public void saveAll(HashMap<String, PlayerCache> playerCacheMap) {
        ArrayList writeList = new ArrayList();
        ArrayList updateList = new ArrayList();
        playerCacheMap.forEach((uuid, playerCache) -> {
            if (!this.isUserRegistered((String)uuid)) {
                writeList.add(new InsertOneModel((Object)new Document("UUID", uuid).append("password", (Object)playerCache.password)));
            } else {
                updateList.add(new ReplaceOneModel(Filters.eq((String)"UUID", (Object)uuid), (Object)new Document("UUID", uuid).append("password", (Object)playerCache.password).append("is_authenticated", (Object)playerCache.isAuthenticated).append("last_ip", (Object)playerCache.lastIp).append("valid_until", (Object)playerCache.validUntil).append("last_kicked", (Object)playerCache.lastKicked)));
            }
        });
        if (!writeList.isEmpty()) {
            this.collection.bulkWrite(writeList);
        }
        if (!updateList.isEmpty()) {
            this.collection.bulkWrite(updateList);
        }
    }
}

