/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores;

import com.tom.chunkstorage.api.ChunkStorageApi;
import com.tom.chunkstorage.api.DataObject;
import com.tom.chunkstorage.api.DataObjectKey;
import com.tom.createores.Config;
import com.tom.createores.OreVeinGenerator;
import com.tom.createores.block.entity.IDrill;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.ThreeState;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1863;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_5819;

public class OreDataCapability {
    private static final DataObjectKey<OreData> KEY = ChunkStorageApi.registerObjectFactory((class_2960)new class_2960("createoreexcavation", "ore_vein_data"), OreData::new);

    public static void init() {
    }

    public static OreData getData(class_2818 chunk) {
        if (chunk.method_12200().field_9236) {
            throw new RuntimeException("Ore Data accessed from client");
        }
        OreData data = (OreData)ChunkStorageApi.getOrCreateFromChunk((class_2818)chunk, KEY);
        if (data != null && !data.loaded) {
            VeinRecipe r = OreVeinGenerator.pick(chunk);
            if (r != null) {
                class_5819 rng = OreVeinGenerator.rngFromChunk(chunk);
                data.recipe = r.method_8114();
                data.randomMul = rng.method_43057();
            }
            data.loaded = true;
        }
        return data;
    }

    public static class OreData
    implements DataObject {
        private class_2960 recipe;
        private boolean loaded;
        private long extractedAmount;
        private float randomMul;
        private Set<class_2338> extractors;

        public void load(class_2487 nbt) {
            this.loaded = nbt.method_10577("gen");
            if (nbt.method_10545("ore")) {
                this.recipe = new class_2960(nbt.method_10558("ore"));
                this.extractedAmount = nbt.method_10537("ext");
                this.randomMul = nbt.method_10545("mul") ? nbt.method_10583("mul") : 0.8f;
            }
        }

        public class_2487 save() {
            class_2487 nbt = new class_2487();
            nbt.method_10556("gen", this.loaded);
            if (this.recipe != null) {
                nbt.method_10582("ore", this.recipe.toString());
                nbt.method_10544("ext", this.extractedAmount);
                nbt.method_10548("mul", this.randomMul);
            }
            return nbt;
        }

        public void setRecipe(class_2960 recipe) {
            this.recipe = recipe;
        }

        public class_2960 getRecipeId() {
            return this.recipe;
        }

        public VeinRecipe getRecipe(class_1863 mngr) {
            return mngr.method_8130(this.recipe).filter(r -> r instanceof VeinRecipe).map(r -> (VeinRecipe)r).orElse(null);
        }

        public boolean isLoaded() {
            return this.loaded;
        }

        public long getResourcesRemaining(VeinRecipe r) {
            if (r.isFinite() != ThreeState.NEVER) {
                if (r.isFinite() == ThreeState.DEFAULT && Config.defaultInfinite) {
                    return 0L;
                }
                double mul = (r.getMaxAmount() - r.getMinAmount()) * this.randomMul + r.getMinAmount();
                long am = Math.round(mul * (double)Config.finiteAmountBase);
                if (this.extractedAmount >= am) {
                    return -1L;
                }
                return am - this.extractedAmount;
            }
            return 0L;
        }

        public void extract(int a) {
            this.extractedAmount += (long)a;
        }

        public boolean canExtract(class_1937 lvl, class_2338 pos) {
            if (Config.maxExtractorsPerVein == 0) {
                return true;
            }
            if (this.extractors == null) {
                this.extractors = new HashSet<class_2338>();
                this.extractors.add(pos);
                return true;
            }
            if (this.extractors.contains(pos)) {
                return true;
            }
            this.extractors.removeIf(p -> !(lvl.method_8321(p) instanceof IDrill));
            if (this.extractors.size() < Config.maxExtractorsPerVein) {
                this.extractors.add(pos);
                return true;
            }
            return false;
        }

        public void setRandomMul(float randomMul) {
            this.randomMul = randomMul;
        }

        public void setLoaded(boolean loaded) {
            this.loaded = loaded;
        }

        public void setExtractedAmount(long extractedAmount) {
            this.extractedAmount = extractedAmount;
        }
    }
}

