/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.equipment.toolbox;

import com.simibubi.create.AllItems;
import com.simibubi.create.content.equipment.toolbox.ToolboxBlockEntity;
import com.simibubi.create.foundation.utility.NBTHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ToolboxInventory
extends ItemStackHandler {
    public static final int STACKS_PER_COMPARTMENT = 4;
    List<ItemStack> filters;
    boolean settling;
    private ToolboxBlockEntity blockEntity;
    private boolean limitedMode;

    public ToolboxInventory(ToolboxBlockEntity be) {
        super(32);
        this.blockEntity = be;
        this.limitedMode = false;
        this.filters = new ArrayList<ItemStack>();
        this.settling = false;
        for (int i = 0; i < 8; ++i) {
            this.filters.add(ItemStack.f_41583_);
        }
    }

    public void inLimitedMode(Consumer<ToolboxInventory> action) {
        this.limitedMode = true;
        action.accept(this);
        this.limitedMode = false;
    }

    public void settle(int compartment) {
        int i;
        int totalCount = 0;
        boolean valid = true;
        boolean shouldBeEmpty = false;
        ItemStack sample = ItemStack.f_41583_;
        for (i = 0; i < 4; ++i) {
            ItemStack stackInSlot = this.getStackInSlot(compartment * 4 + i);
            totalCount += stackInSlot.m_41613_();
            if (!shouldBeEmpty) {
                shouldBeEmpty = stackInSlot.m_41619_() || stackInSlot.m_41613_() != stackInSlot.m_41741_();
                continue;
            }
            if (stackInSlot.m_41619_()) continue;
            valid = false;
            sample = stackInSlot;
        }
        if (valid) {
            return;
        }
        this.settling = true;
        if (!sample.m_41753_()) {
            block1: for (i = 0; i < 4; ++i) {
                if (!this.getStackInSlot(compartment * 4 + i).m_41619_()) continue;
                for (int j = i + 1; j < 4; ++j) {
                    ItemStack stackInSlot = this.getStackInSlot(compartment * 4 + j);
                    if (stackInSlot.m_41619_()) continue;
                    this.setStackInSlot(compartment * 4 + i, stackInSlot);
                    this.setStackInSlot(compartment * 4 + j, ItemStack.f_41583_);
                    continue block1;
                }
            }
        } else {
            for (i = 0; i < 4; ++i) {
                ItemStack copy = totalCount <= 0 ? ItemStack.f_41583_ : ItemHandlerHelper.copyStackWithSize((ItemStack)sample, (int)Math.min(totalCount, sample.m_41741_()));
                this.setStackInSlot(compartment * 4 + i, copy);
                totalCount -= copy.m_41613_();
            }
        }
        this.settling = false;
        this.blockEntity.sendData();
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (!stack.m_41720_().m_142095_()) {
            return false;
        }
        if (slot < 0 || slot >= this.getSlots()) {
            return false;
        }
        int compartment = slot / 4;
        ItemStack filter = this.filters.get(compartment);
        if (this.limitedMode && filter.m_41619_()) {
            return false;
        }
        if (filter.m_41619_() || ToolboxInventory.canItemsShareCompartment(filter, stack)) {
            return super.isItemValid(slot, stack);
        }
        return false;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        super.setStackInSlot(slot, stack);
        int compartment = slot / 4;
        if (!stack.m_41619_() && this.filters.get(compartment).m_41619_()) {
            this.filters.set(compartment, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
            this.blockEntity.sendData();
        }
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        ItemStack insertItem = super.insertItem(slot, stack, simulate);
        if (insertItem.m_41613_() != stack.m_41613_()) {
            int compartment = slot / 4;
            if (!stack.m_41619_() && this.filters.get(compartment).m_41619_()) {
                this.filters.set(compartment, ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)1));
                this.blockEntity.sendData();
            }
        }
        return insertItem;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.m_128365_("Compartments", (Tag)NBTHelper.writeItemList(this.filters));
        return compound;
    }

    protected void onContentsChanged(int slot) {
        if (!this.settling && !this.blockEntity.m_58904_().f_46443_) {
            this.settle(slot / 4);
        }
        this.blockEntity.sendData();
        this.blockEntity.m_6596_();
        super.onContentsChanged(slot);
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.filters = NBTHelper.readItemList(nbt.m_128437_("Compartments", 10));
        if (this.filters.size() != 8) {
            this.filters.clear();
            for (int i = 0; i < 8; ++i) {
                this.filters.add(ItemStack.f_41583_);
            }
        }
        super.deserializeNBT(nbt);
    }

    public ItemStack distributeToCompartment(@Nonnull ItemStack stack, int compartment, boolean simulate) {
        if (stack.m_41619_()) {
            return stack;
        }
        if (this.filters.get(compartment).m_41619_()) {
            return stack;
        }
        for (int i = 3; i >= 0; --i) {
            int slot = compartment * 4 + i;
            if (!(stack = this.insertItem(slot, stack, simulate)).m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public ItemStack takeFromCompartment(int amount, int compartment, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        int remaining = amount;
        ItemStack lastValid = ItemStack.f_41583_;
        for (int i = 3; i >= 0; --i) {
            int slot = compartment * 4 + i;
            ItemStack extracted = this.extractItem(slot, remaining, simulate);
            remaining -= extracted.m_41613_();
            if (!extracted.m_41619_()) {
                lastValid = extracted;
            }
            if (remaining != 0) continue;
            return ItemHandlerHelper.copyStackWithSize((ItemStack)lastValid, (int)amount);
        }
        if (remaining == amount) {
            return ItemStack.f_41583_;
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)lastValid, (int)(amount - remaining));
    }

    public static ItemStack cleanItemNBT(ItemStack stack) {
        if (AllItems.BELT_CONNECTOR.isIn(stack)) {
            stack.m_41749_("FirstPulley");
        }
        return stack;
    }

    public static boolean canItemsShareCompartment(ItemStack stack1, ItemStack stack2) {
        if (!stack1.m_41753_() && !stack2.m_41753_() && stack1.m_41763_() && stack2.m_41763_()) {
            return stack1.m_41720_() == stack2.m_41720_();
        }
        if (AllItems.BELT_CONNECTOR.isIn(stack1) && AllItems.BELT_CONNECTOR.isIn(stack2)) {
            return true;
        }
        return ItemHandlerHelper.canItemStacksStack((ItemStack)stack1, (ItemStack)stack2);
    }
}

