/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.belt.behaviour;

import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.content.logistics.funnel.BeltFunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelBlock;
import com.simibubi.create.content.logistics.funnel.FunnelBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class DirectBeltInputBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<DirectBeltInputBehaviour> TYPE = new BehaviourType();
    private InsertionCallback tryInsert = this::defaultInsertionCallback;
    private AvailabilityPredicate canInsert = d -> true;
    private Supplier<Boolean> supportsBeltFunnels = () -> false;

    public DirectBeltInputBehaviour(SmartBlockEntity be) {
        super(be);
    }

    public DirectBeltInputBehaviour allowingBeltFunnelsWhen(Supplier<Boolean> pred) {
        this.supportsBeltFunnels = pred;
        return this;
    }

    public DirectBeltInputBehaviour allowingBeltFunnels() {
        this.supportsBeltFunnels = () -> true;
        return this;
    }

    public DirectBeltInputBehaviour onlyInsertWhen(AvailabilityPredicate pred) {
        this.canInsert = pred;
        return this;
    }

    public DirectBeltInputBehaviour setInsertionHandler(InsertionCallback callback) {
        this.tryInsert = callback;
        return this;
    }

    private ItemStack defaultInsertionCallback(TransportedItemStack inserted, Direction side, boolean simulate) {
        LazyOptional lazy = this.blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, side);
        if (!lazy.isPresent()) {
            return inserted.stack;
        }
        return ItemHandlerHelper.insertItemStacked((IItemHandler)((IItemHandler)lazy.orElse(null)), (ItemStack)inserted.stack.m_41777_(), (boolean)simulate);
    }

    public boolean canInsertFromSide(Direction side) {
        return this.canInsert.test(side);
    }

    public ItemStack handleInsertion(ItemStack stack, Direction side, boolean simulate) {
        return this.handleInsertion(new TransportedItemStack(stack), side, simulate);
    }

    public ItemStack handleInsertion(TransportedItemStack stack, Direction side, boolean simulate) {
        return this.tryInsert.apply(stack, side, simulate);
    }

    @Override
    public BehaviourType<?> getType() {
        return TYPE;
    }

    @Nullable
    public ItemStack tryExportingToBeltFunnel(ItemStack stack, @Nullable Direction side, boolean simulate) {
        BlockPos funnelPos = this.blockEntity.m_58899_().m_7494_();
        Level world = this.getWorld();
        BlockState funnelState = world.m_8055_(funnelPos);
        if (!(funnelState.m_60734_() instanceof BeltFunnelBlock)) {
            return null;
        }
        if (funnelState.m_61143_(BeltFunnelBlock.SHAPE) != BeltFunnelBlock.Shape.PULLING) {
            return null;
        }
        if (side != null && FunnelBlock.getFunnelFacing(funnelState) != side) {
            return null;
        }
        BlockEntity be = world.m_7702_(funnelPos);
        if (!(be instanceof FunnelBlockEntity)) {
            return null;
        }
        if (((Boolean)funnelState.m_61143_((Property)BeltFunnelBlock.POWERED)).booleanValue()) {
            return stack;
        }
        ItemStack insert = FunnelBlock.tryInsert(world, funnelPos, stack, simulate);
        if (insert.m_41613_() != stack.m_41613_() && !simulate) {
            ((FunnelBlockEntity)be).flap(true);
        }
        return insert;
    }

    public boolean canSupportBeltFunnels() {
        return this.supportsBeltFunnels.get();
    }

    @FunctionalInterface
    public static interface InsertionCallback {
        public ItemStack apply(TransportedItemStack var1, Direction var2, boolean var3);
    }

    @FunctionalInterface
    public static interface AvailabilityPredicate {
        public boolean test(Direction var1);
    }
}

