/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.google.gson.JsonObject;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.SimpleCreateTrigger;
import com.simibubi.create.foundation.utility.Components;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class CreateAdvancement {
    static final ResourceLocation BACKGROUND = Create.asResource("textures/gui/advancements.png");
    static final String LANG = "advancement.create.";
    static final String SECRET_SUFFIX = "\u00a77\n(Hidden Advancement)";
    private Advancement.Builder builder = Advancement.Builder.m_138353_();
    private SimpleCreateTrigger builtinTrigger;
    private CreateAdvancement parent;
    Advancement datagenResult;
    private String id;
    private String title;
    private String description;

    public CreateAdvancement(String id, UnaryOperator<Builder> b) {
        this.id = id;
        Builder t = new Builder();
        b.apply(t);
        if (!t.externalTrigger) {
            this.builtinTrigger = AllTriggers.addSimple(id + "_builtin");
            this.builder.m_138386_("0", (CriterionTriggerInstance)this.builtinTrigger.instance());
        }
        this.builder.m_138362_(t.icon, (Component)Components.translatable(this.titleKey()), (Component)Components.translatable(this.descriptionKey()).m_130938_(s -> s.m_178520_(14393875)), (ResourceLocation)(id.equals("root") ? BACKGROUND : null), t.type.frame, t.type.toast, t.type.announce, t.type.hide);
        if (t.type == TaskType.SECRET) {
            this.description = this.description + SECRET_SUFFIX;
        }
        AllAdvancements.ENTRIES.add(this);
    }

    private String titleKey() {
        return LANG + this.id;
    }

    private String descriptionKey() {
        return this.titleKey() + ".desc";
    }

    public boolean isAlreadyAwardedTo(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return true;
        }
        ServerPlayer sp = (ServerPlayer)player;
        Advancement advancement = sp.m_20194_().m_129889_().m_136041_(Create.asResource(this.id));
        if (advancement == null) {
            return true;
        }
        return sp.m_8960_().m_135996_(advancement).m_8193_();
    }

    public void awardTo(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (this.builtinTrigger == null) {
            throw new UnsupportedOperationException("Advancement " + this.id + " uses external Triggers, it cannot be awarded directly");
        }
        this.builtinTrigger.trigger(sp);
    }

    void save(Consumer<Advancement> t) {
        if (this.parent != null) {
            this.builder.m_138398_(this.parent.datagenResult);
        }
        this.datagenResult = this.builder.m_138389_(t, Create.asResource(this.id).toString());
    }

    void appendToLang(JsonObject object) {
        object.addProperty(this.titleKey(), this.title);
        object.addProperty(this.descriptionKey(), this.description);
    }

    class Builder {
        private TaskType type = TaskType.NORMAL;
        private boolean externalTrigger;
        private int keyIndex;
        private ItemStack icon;

        Builder() {
        }

        Builder special(TaskType type) {
            this.type = type;
            return this;
        }

        Builder after(CreateAdvancement other) {
            CreateAdvancement.this.parent = other;
            return this;
        }

        Builder icon(ItemProviderEntry<?> item) {
            return this.icon(item.asStack());
        }

        Builder icon(ItemLike item) {
            return this.icon(new ItemStack(item));
        }

        Builder icon(ItemStack stack) {
            this.icon = stack;
            return this;
        }

        Builder title(String title) {
            CreateAdvancement.this.title = title;
            return this;
        }

        Builder description(String description) {
            CreateAdvancement.this.description = description;
            return this;
        }

        Builder whenBlockPlaced(Block block) {
            return this.externalTrigger((CriterionTriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.m_286031_((Block)block));
        }

        Builder whenIconCollected() {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{this.icon.m_41720_()}));
        }

        Builder whenItemCollected(ItemProviderEntry<?> item) {
            return this.whenItemCollected((ItemLike)item.asStack().m_41720_());
        }

        Builder whenItemCollected(ItemLike itemProvider) {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{itemProvider}));
        }

        Builder whenItemCollected(TagKey<Item> tag) {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(tag, null, MinMaxBounds.Ints.f_55364_, MinMaxBounds.Ints.f_55364_, EnchantmentPredicate.f_30465_, EnchantmentPredicate.f_30465_, null, NbtPredicate.f_57471_)}));
        }

        Builder awardedForFree() {
            return this.externalTrigger((CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[0]));
        }

        Builder externalTrigger(CriterionTriggerInstance trigger) {
            CreateAdvancement.this.builder.m_138386_(String.valueOf(this.keyIndex), trigger);
            this.externalTrigger = true;
            ++this.keyIndex;
            return this;
        }
    }

    static enum TaskType {
        SILENT(FrameType.TASK, false, false, false),
        NORMAL(FrameType.TASK, true, false, false),
        NOISY(FrameType.TASK, true, true, false),
        EXPERT(FrameType.GOAL, true, true, false),
        SECRET(FrameType.GOAL, true, true, true);

        private FrameType frame;
        private boolean toast;
        private boolean announce;
        private boolean hide;

        private TaskType(FrameType frame, boolean toast, boolean announce, boolean hide) {
            this.frame = frame;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

