/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.recipe.Mods;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.nullness.NonNullFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.Tags;

public class TagGen {
    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOrPickaxe() {
        return b -> b.tag(new TagKey[]{BlockTags.f_144280_}).tag(new TagKey[]{BlockTags.f_144282_});
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> axeOnly() {
        return b -> b.tag(new TagKey[]{BlockTags.f_144280_});
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, BlockBuilder<T, P>> pickaxeOnly() {
        return b -> b.tag(new TagKey[]{BlockTags.f_144282_});
    }

    public static <T extends Block, P> NonNullFunction<BlockBuilder<T, P>, ItemBuilder<BlockItem, BlockBuilder<T, P>>> tagBlockAndItem(String ... path) {
        return b -> {
            for (String p : path) {
                b.tag(new TagKey[]{AllTags.forgeBlockTag(p)});
            }
            ItemBuilder item = b.item();
            for (String p : path) {
                item.tag(new TagKey[]{AllTags.forgeItemTag(p)});
            }
            return item;
        };
    }

    public static <T extends TagsProvider.TagAppender<?>> T addOptional(T appender, Mods mod, String id) {
        appender.m_176839_(mod.asResource(id));
        return appender;
    }

    public static <T extends TagsProvider.TagAppender<?>> T addOptional(T appender, Mods mod, String ... ids) {
        for (String id : ids) {
            appender.m_176839_(mod.asResource(id));
        }
        return appender;
    }

    public static void datagen() {
        Create.REGISTRATE.addDataGenerator(ProviderType.BLOCK_TAGS, TagGen::genBlockTags);
        Create.REGISTRATE.addDataGenerator(ProviderType.ITEM_TAGS, TagGen::genItemTags);
        Create.REGISTRATE.addDataGenerator(ProviderType.FLUID_TAGS, TagGen::genFluidTags);
        Create.REGISTRATE.addDataGenerator(ProviderType.ENTITY_TAGS, TagGen::genEntityTags);
    }

    private static void genBlockTags(RegistrateTagsProvider<Block> provIn) {
        CreateTagsProvider<Block> prov = new CreateTagsProvider<Block>(provIn, Block::m_204297_);
        prov.tag(AllTags.AllBlockTags.BRITTLE.tag).add((Block[])new Block[]{Blocks.f_50680_, Blocks.f_50262_, Blocks.f_50276_}).m_206428_(BlockTags.f_13038_).m_206428_(BlockTags.f_13103_);
        prov.tag(AllTags.AllBlockTags.MOVABLE_EMPTY_COLLIDER.tag).add((Block[])new Block[]{Blocks.f_50033_, Blocks.f_152499_, Blocks.f_50267_, Blocks.f_50266_}).m_206428_(BlockTags.f_13055_);
        prov.tag(AllTags.AllBlockTags.FAN_TRANSPARENT.tag).add(Blocks.f_50183_).add(Blocks.f_220833_).m_206428_(BlockTags.f_13087_).m_206428_(BlockTags.f_13039_).m_206428_(BlockTags.f_13035_);
        prov.tag(AllTags.AllBlockTags.ORE_OVERRIDE_STONE.tag).m_206428_(BlockTags.f_144266_);
        prov.tag(AllTags.AllBlockTags.PASSIVE_BOILER_HEATERS.tag).add((Block[])new Block[]{Blocks.f_50450_, Blocks.f_49991_}).m_206428_(BlockTags.f_13087_).m_206428_(BlockTags.f_13076_);
        prov.tag(AllTags.AllBlockTags.SAFE_NBT.tag).m_206428_(BlockTags.f_13028_).m_206428_(BlockTags.f_13068_);
        prov.tag(AllTags.AllBlockTags.TREE_ATTACHMENTS.tag).add((Block[])new Block[]{Blocks.f_50717_, Blocks.f_50262_, Blocks.f_220831_, Blocks.f_152543_, Blocks.f_50701_, Blocks.f_50191_});
        prov.tag(AllTags.AllBlockTags.WINDMILL_SAILS.tag).m_206428_(BlockTags.f_13089_);
        prov.tag(AllTags.AllBlockTags.WRENCH_PICKUP.tag).add((Block[])new Block[]{Blocks.f_50088_, Blocks.f_50174_, Blocks.f_50146_, Blocks.f_50164_, Blocks.f_50328_, Blocks.f_50455_, Blocks.f_50123_, Blocks.f_50039_, Blocks.f_50032_, Blocks.f_50267_, Blocks.f_50266_, Blocks.f_50329_, Blocks.f_50716_, Blocks.f_50332_}).m_206428_(BlockTags.f_13093_).m_206428_(BlockTags.f_13099_).m_206428_(BlockTags.f_13034_);
        prov.tag(AllTags.AllBlockTags.COPYCAT_ALLOW.tag).add(Blocks.f_50618_);
        prov.tag(AllTags.AllBlockTags.COPYCAT_DENY.tag).m_206428_(BlockTags.f_144269_).m_206428_(BlockTags.f_13104_).m_206428_(BlockTags.f_13082_);
        TagGen.addOptional(prov.tag(AllTags.AllBlockTags.NON_MOVABLE.tag), Mods.IE, "connector_lv", "connector_lv_relay", "connector_mv", "connector_mv_relay", "connector_hv", "connector_hv_relay", "connector_bundled", "connector_structural", "connector_redstone", "connector_probe", "breaker_switch");
        for (AllTags.AllBlockTags tag : AllTags.AllBlockTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }

    private static void genItemTags(RegistrateTagsProvider<Item> provIn) {
        CreateTagsProvider<Item> prov = new CreateTagsProvider<Item>(provIn, Item::m_204114_);
        prov.tag(AllTags.AllItemTags.SLEEPERS.tag).add((Item[])new Item[]{Items.f_41922_, Items.f_41923_, Items.f_42336_});
        prov.tag(AllTags.AllItemTags.STRIPPED_LOGS.tag).m_206428_(AllTags.AllItemTags.VANILLA_STRIPPED_LOGS.tag).m_206428_(AllTags.AllItemTags.MODDED_STRIPPED_LOGS.tag);
        prov.tag(AllTags.AllItemTags.STRIPPED_WOOD.tag).m_206428_(AllTags.AllItemTags.VANILLA_STRIPPED_WOOD.tag).m_206428_(AllTags.AllItemTags.MODDED_STRIPPED_WOOD.tag);
        prov.tag(AllTags.AllItemTags.DEPLOYABLE_DRINK.tag).add((Item[])new Item[]{Items.f_42455_, Items.f_42589_});
        prov.tag(AllTags.AllItemTags.UPRIGHT_ON_BELT.tag).add((Item[])new Item[]{Items.f_42590_, Items.f_42589_, Items.f_42736_, Items.f_42739_, Items.f_42787_, Items.f_42502_});
        prov.tag(AllTags.AllItemTags.CONTRAPTION_CONTROLLED.tag).add((Item[])new Item[]{Items.f_42777_, Items.f_42781_, Items.f_42782_, Items.f_41855_, Items.f_42162_});
        prov.tag(AllTags.AllItemTags.VANILLA_STRIPPED_LOGS.tag).add((Item[])new Item[]{Items.f_41849_, Items.f_41847_, Items.f_41851_, Items.f_41850_, Items.f_41848_, Items.f_220182_, Items.f_41845_, Items.f_41846_, Items.f_41879_});
        prov.tag(AllTags.AllItemTags.VANILLA_STRIPPED_WOOD.tag).add((Item[])new Item[]{Items.f_41884_, Items.f_41882_, Items.f_41886_, Items.f_41885_, Items.f_41883_, Items.f_220176_, Items.f_41880_, Items.f_41881_, Items.f_41887_});
        prov.tag((TagKey<Item>)ItemTags.f_13164_).m_206428_(AllTags.AllItemTags.CREATE_INGOTS.tag);
        prov.tag((TagKey<Item>)Tags.Items.INGOTS).m_206428_(AllTags.AllItemTags.CREATE_INGOTS.tag);
        TagGen.genStrippedWood(prov);
        for (AllTags.AllItemTags tag : AllTags.AllItemTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }

    private static void genStrippedWood(CreateTagsProvider<Item> prov) {
        CreateTagAppender<Item> logAppender = prov.tag(AllTags.AllItemTags.MODDED_STRIPPED_LOGS.tag);
        CreateTagAppender<Item> woodAppender = prov.tag(AllTags.AllItemTags.MODDED_STRIPPED_WOOD.tag);
        StrippedWoodHelper helper = new StrippedWoodHelper(logAppender, woodAppender);
        helper.add(Mods.ARS_N, "blue_archwood", "purple_archwood", "green_archwood", "red_archwood");
        helper.add(Mods.BTN, "livingwood", "dreamwood");
        helper.add(Mods.FA, "cherrywood", "mysterywood");
        helper.add(Mods.HEX, "akashic");
        helper.add(Mods.ID, "menril");
        helper.add(Mods.BYG, "aspen", "baobab", "enchanted", "cherry", "cika", "cypress", "ebony", "ether", "fir", "green_enchanted", "holly", "jacaranda", "lament", "mahogany", "mangrove", "maple", "nightshade", "palm", "palo_verde", "pine", "rainbow_eucalyptus", "redwood", "skyris", "willow", "witch_hazel", "zelkova");
        helper.add(Mods.SG, "netherwood");
        helper.add(Mods.TF, "twilight_oak", "canopy", "mangrove", "dark", "time", "transformation", "mining", "sorting");
        helper.add(Mods.TIC, "greenheart", "skyroot", "bloodshroom");
        helper.add(Mods.AP, "twisted");
        helper.add(Mods.Q, "azalea", "blossom");
        helper.add(Mods.ECO, "coconut", "walnut", "azalea");
        helper.add(Mods.BOP, "fir", "redwood", "cherry", "mahogany", "jacaranda", "palm", "willow", "dead", "magic", "umbran", "hellbark");
        helper.add(Mods.BSK, "bluebright", "starlit", "frostbright", "lunar", "dusk", "maple", "cherry");
        TagGen.addOptional(logAppender, Mods.BYG, "stripped_bulbis_stem");
        TagGen.addOptional(woodAppender, Mods.BYG, "stripped_bulbis_wood");
    }

    private static void genFluidTags(RegistrateTagsProvider<Fluid> provIn) {
        CreateTagsProvider<Fluid> prov = new CreateTagsProvider<Fluid>(provIn, Fluid::m_205069_);
        prov.tag(AllTags.AllFluidTags.BOTTOMLESS_ALLOW.tag).add((Fluid[])new Fluid[]{Fluids.f_76193_, Fluids.f_76195_});
        for (AllTags.AllFluidTags tag : AllTags.AllFluidTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }

    private static void genEntityTags(RegistrateTagsProvider<EntityType<?>> provIn) {
        CreateTagsProvider<EntityType> prov = new CreateTagsProvider<EntityType>(provIn, EntityType::m_204041_);
        for (AllTags.AllEntityTags tag : AllTags.AllEntityTags.values()) {
            if (!tag.alwaysDatagen) continue;
            prov.getOrCreateRawBuilder(tag.tag);
        }
    }

    public static class CreateTagsProvider<T> {
        private RegistrateTagsProvider<T> provider;
        private Function<T, ResourceKey<T>> keyExtractor;

        public CreateTagsProvider(RegistrateTagsProvider<T> provider, Function<T, Holder.Reference<T>> refExtractor) {
            this.provider = provider;
            this.keyExtractor = refExtractor.andThen(Holder.Reference::m_205785_);
        }

        public CreateTagAppender<T> tag(TagKey<T> tag) {
            TagBuilder tagbuilder = this.getOrCreateRawBuilder(tag);
            return new CreateTagAppender<T>(tagbuilder, this.keyExtractor, "create");
        }

        public TagBuilder getOrCreateRawBuilder(TagKey<T> tag) {
            return this.provider.addTag(tag).getInternalBuilder();
        }
    }

    public static class CreateTagAppender<T>
    extends TagsProvider.TagAppender<T> {
        private Function<T, ResourceKey<T>> keyExtractor;

        public CreateTagAppender(TagBuilder pBuilder, Function<T, ResourceKey<T>> pKeyExtractor, String modId) {
            super(pBuilder, modId);
            this.keyExtractor = pKeyExtractor;
        }

        public CreateTagAppender<T> add(T entry) {
            this.m_255204_(this.keyExtractor.apply(entry));
            return this;
        }

        @SafeVarargs
        public final CreateTagAppender<T> add(T ... entries) {
            Stream.of(entries).map(this.keyExtractor).forEach(arg_0 -> ((CreateTagAppender)this).m_255204_(arg_0));
            return this;
        }
    }

    private static class StrippedWoodHelper {
        protected final TagsProvider.TagAppender<Item> logAppender;
        protected final TagsProvider.TagAppender<Item> woodAppender;

        public StrippedWoodHelper(TagsProvider.TagAppender<Item> logAppender, TagsProvider.TagAppender<Item> woodAppender) {
            this.logAppender = logAppender;
            this.woodAppender = woodAppender;
        }

        public void add(Mods mod, String ... woodTypes) {
            for (String type : woodTypes) {
                String strippedPre = mod.strippedIsSuffix ? "" : "stripped_";
                String strippedPost = mod.strippedIsSuffix ? "_stripped" : "";
                TagGen.addOptional(this.logAppender, mod, strippedPre + type + "_log" + strippedPost);
                TagGen.addOptional(this.woodAppender, mod, strippedPre + type + (mod.omitWoodSuffix ? "" : "_wood") + strippedPost);
            }
        }
    }
}

