/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.gui;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.ui.BaseConfigScreen;
import com.simibubi.create.foundation.gui.AbstractSimiScreen;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.gui.ScreenOpener;
import com.simibubi.create.foundation.gui.element.BoxElement;
import com.simibubi.create.foundation.gui.element.GuiGameElement;
import com.simibubi.create.foundation.gui.element.RenderElement;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.ponder.ui.PonderTagIndexScreen;
import com.simibubi.create.foundation.utility.Color;
import com.simibubi.create.foundation.utility.Components;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public class CreateMainMenuScreen
extends AbstractSimiScreen {
    public static final CubeMap PANORAMA_RESOURCES = new CubeMap(Create.asResource("textures/gui/title/background/panorama"));
    public static final ResourceLocation PANORAMA_OVERLAY_TEXTURES = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    public static final PanoramaRenderer PANORAMA = new PanoramaRenderer(PANORAMA_RESOURCES);
    private static final Component CURSEFORGE_TOOLTIP = Components.literal("CurseForge").m_130938_(s -> s.m_178520_(16545884).m_131136_(Boolean.valueOf(true)));
    private static final Component MODRINTH_TOOLTIP = Components.literal("Modrinth").m_130938_(s -> s.m_178520_(4182827).m_131136_(Boolean.valueOf(true)));
    public static final String CURSEFORGE_LINK = "https://www.curseforge.com/minecraft/mc-mods/create";
    public static final String MODRINTH_LINK = "https://modrinth.com/mod/create";
    public static final String ISSUE_TRACKER_LINK = "https://github.com/Creators-of-Create/Create/issues";
    public static final String SUPPORT_LINK = "https://github.com/Creators-of-Create/Create/wiki/Supporting-the-Project";
    protected final Screen parent;
    protected boolean returnOnClose;
    private PanoramaRenderer vanillaPanorama;
    private long firstRenderTime;
    private Button gettingStarted;

    public CreateMainMenuScreen(Screen parent) {
        this.parent = parent;
        this.returnOnClose = true;
        if (parent instanceof TitleScreen) {
            TitleScreen titleScreen = (TitleScreen)parent;
            this.vanillaPanorama = titleScreen.f_96729_;
        } else {
            this.vanillaPanorama = new PanoramaRenderer(TitleScreen.f_96716_);
        }
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.firstRenderTime == 0L) {
            this.firstRenderTime = Util.m_137550_();
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        float f = (float)(Util.m_137550_() - this.firstRenderTime) / 1000.0f;
        float alpha = Mth.m_14036_((float)f, (float)0.0f, (float)1.0f);
        float elapsedPartials = this.f_96541_.m_91297_();
        if (this.parent instanceof TitleScreen) {
            if (alpha < 1.0f) {
                this.vanillaPanorama.m_110003_(elapsedPartials, 1.0f);
            }
            PANORAMA.m_110003_(elapsedPartials, alpha);
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            graphics.m_280411_(PANORAMA_OVERLAY_TEXTURES, 0, 0, this.f_96543_, this.f_96544_, 0.0f, 0.0f, 16, 128, 16, 128);
        }
        RenderSystem.enableDepthTest();
        PoseStack ms = graphics.m_280168_();
        for (int side : Iterate.positiveAndNegative) {
            ms.m_85836_();
            ms.m_252880_((float)(this.f_96543_ / 2), 60.0f, 200.0f);
            ms.m_85841_((float)(24 * side), (float)(24 * side), 32.0f);
            ms.m_85837_(-1.75 * (double)(alpha * alpha / 2.0f + 0.5f), 0.25, 0.0);
            TransformStack.cast((PoseStack)ms).rotateX(45.0);
            GuiGameElement.of(AllBlocks.LARGE_COGWHEEL.getDefaultState()).rotateBlock(0.0, (float)Util.m_137550_() / 32.0f * (float)side, 0.0).render(graphics);
            ms.m_252880_(-1.0f, 0.0f, -1.0f);
            GuiGameElement.of(AllBlocks.COGWHEEL.getDefaultState()).rotateBlock(0.0, (float)Util.m_137550_() / -16.0f * (float)side + 22.5f, 0.0).render(graphics);
            ms.m_85849_();
        }
        ms.m_85836_();
        ms.m_252880_((float)(this.f_96543_ / 2 - 32), 32.0f, -10.0f);
        ms.m_85836_();
        ms.m_85841_(0.25f, 0.25f, 0.25f);
        AllGuiTextures.LOGO.render(graphics, 0, 0);
        ms.m_85849_();
        ((RenderElement)((RenderElement)((RenderElement)((BoxElement)new BoxElement().withBackground(-2013265920)).flatBorder(new Color(0x1000000))).at(-32.0f, 56.0f, 100.0f)).withBounds(128, 11)).render(graphics);
        ms.m_85849_();
        ms.m_85836_();
        ms.m_252880_(0.0f, 0.0f, 200.0f);
        graphics.m_280653_(this.f_96547_, (Component)Components.literal("Create").m_130940_(ChatFormatting.BOLD).m_7220_((Component)Components.literal(" v0.5.1d").m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.WHITE})), this.f_96543_ / 2, 89, -1787033);
        ms.m_85849_();
        RenderSystem.disableDepthTest();
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.returnOnClose = true;
        this.addButtons();
    }

    private void addButtons() {
        int yStart = this.f_96544_ / 4 + 40;
        int center = this.f_96543_ / 2;
        int bHeight = 20;
        int bShortWidth = 98;
        int bLongWidth = 200;
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Lang.translateDirect("menu.return", new Object[0]), $ -> this.linkTo(this.parent)).m_252987_(center - 100, yStart + 92, bLongWidth, bHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Lang.translateDirect("menu.configure", new Object[0]), $ -> this.linkTo(BaseConfigScreen.forCreate(this))).m_252987_(center - 100, yStart + 24 + -16, bLongWidth, bHeight).m_253136_());
        this.gettingStarted = Button.m_253074_((Component)Lang.translateDirect("menu.ponder_index", new Object[0]), $ -> this.linkTo(new PonderTagIndexScreen())).m_252987_(center + 2, yStart + 48 + -16, bShortWidth, bHeight).m_253136_();
        this.gettingStarted.f_93623_ = !(this.parent instanceof TitleScreen);
        this.m_142416_((GuiEventListener)this.gettingStarted);
        this.m_142416_((GuiEventListener)new PlatformIconButton(center - 100, yStart + 48 + -16, bShortWidth / 2, bHeight, AllGuiTextures.CURSEFORGE_LOGO, 0.085f, b -> this.linkTo(CURSEFORGE_LINK), Tooltip.m_257550_((Component)CURSEFORGE_TOOLTIP)));
        this.m_142416_((GuiEventListener)new PlatformIconButton(center - 50, yStart + 48 + -16, bShortWidth / 2, bHeight, AllGuiTextures.MODRINTH_LOGO, 0.0575f, b -> this.linkTo(MODRINTH_LINK), Tooltip.m_257550_((Component)MODRINTH_TOOLTIP)));
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Lang.translateDirect("menu.report_bugs", new Object[0]), $ -> this.linkTo(ISSUE_TRACKER_LINK)).m_252987_(center + 2, yStart + 68, bShortWidth, bHeight).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Lang.translateDirect("menu.support", new Object[0]), $ -> this.linkTo(SUPPORT_LINK)).m_252987_(center - 100, yStart + 68, bShortWidth, bHeight).m_253136_());
    }

    @Override
    protected void renderWindowForeground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWindowForeground(graphics, mouseX, mouseY, partialTicks);
        this.f_169369_.forEach(w -> w.m_88315_(graphics, mouseX, mouseY, partialTicks));
        if (this.parent instanceof TitleScreen) {
            if (mouseX < this.gettingStarted.m_252754_() || mouseX > this.gettingStarted.m_252754_() + 98) {
                return;
            }
            if (mouseY < this.gettingStarted.m_252907_() || mouseY > this.gettingStarted.m_252907_() + 20) {
                return;
            }
            graphics.m_280666_(this.f_96547_, TooltipHelper.cutTextComponent((Component)Lang.translateDirect("menu.only_ingame", new Object[0]), TooltipHelper.Palette.ALL_GRAY), mouseX, mouseY);
        }
    }

    private void linkTo(Screen screen) {
        this.returnOnClose = false;
        ScreenOpener.open(screen);
    }

    private void linkTo(String url) {
        this.returnOnClose = false;
        ScreenOpener.open((Screen)new ConfirmLinkScreen(p_213069_2_ -> {
            if (p_213069_2_) {
                Util.m_137581_().m_137646_(url);
            }
            this.f_96541_.m_91152_((Screen)this);
        }, url, true));
    }

    @Override
    public boolean m_7043_() {
        return true;
    }

    protected static class PlatformIconButton
    extends Button {
        protected final AllGuiTextures icon;
        protected final float scale;

        public PlatformIconButton(int pX, int pY, int pWidth, int pHeight, AllGuiTextures icon, float scale, Button.OnPress pOnPress, Tooltip tooltip) {
            super(pX, pY, pWidth, pHeight, Components.immutableEmpty(), pOnPress, f_252438_);
            this.icon = icon;
            this.scale = scale;
            this.m_257544_(tooltip);
        }

        protected void m_87963_(GuiGraphics graphics, int pMouseX, int pMouseY, float pt) {
            super.m_87963_(graphics, pMouseX, pMouseY, pt);
            PoseStack pPoseStack = graphics.m_280168_();
            pPoseStack.m_85836_();
            pPoseStack.m_252880_((float)(this.m_252754_() + this.f_93618_ / 2) - (float)this.icon.width * this.scale / 2.0f, (float)(this.m_252907_() + this.f_93619_ / 2) - (float)this.icon.height * this.scale / 2.0f, 0.0f);
            pPoseStack.m_85841_(this.scale, this.scale, 1.0f);
            this.icon.render(graphics, 0, 0);
            pPoseStack.m_85849_();
        }
    }
}

