/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.ui;

import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IBoxStyle;
import snownee.jade.api.ui.IProgressStyle;
import snownee.jade.overlay.ProgressTracker;
import snownee.jade.overlay.WailaTickHandler;

public class ProgressElement
extends Element {
    private final float progress;
    @Nullable
    private final class_2561 text;
    private final IProgressStyle style;
    private final IBoxStyle boxStyle;
    private ProgressTracker.TrackInfo track;
    private boolean canDecrease;

    public ProgressElement(float progress, class_2561 text, IProgressStyle style, IBoxStyle boxStyle, boolean canDecrease) {
        this.progress = class_3532.method_15363((float)progress, (float)0.0f, (float)1.0f);
        this.text = text;
        this.style = style;
        if (boxStyle == BoxStyle.DEFAULT && IThemeHelper.get().isLightColorScheme()) {
            BoxStyle newStyle = new BoxStyle();
            newStyle.borderWidth = BoxStyle.DEFAULT.borderWidth;
            newStyle.bgColor = 0x44444444;
            boxStyle = newStyle;
        }
        this.boxStyle = boxStyle;
        this.canDecrease = canDecrease;
    }

    @Override
    public class_241 getSize() {
        int height = this.text == null ? 8 : 14;
        float width = 0.0f;
        width += this.boxStyle.borderWidth() * 2.0f;
        if (this.text != null) {
            class_327 font = class_310.method_1551().field_1772;
            width += (float)(font.method_27525((class_5348)this.text) + 3);
        }
        width = Math.max(20.0f, width);
        if (this.getTag() != null) {
            this.track = WailaTickHandler.instance().progressTracker.createInfo(this.getTag(), this.progress, this.canDecrease, width);
            width = this.track.getWidth();
        }
        return new class_241(width, (float)height);
    }

    @Override
    public void render(class_332 guiGraphics, float x, float y, float maxX, float maxY) {
        class_241 size = this.getCachedSize();
        float b = this.boxStyle.borderWidth();
        this.boxStyle.render(guiGraphics, x, y, maxX - x, size.field_1342 - 2.0f);
        float progress = this.progress;
        if (this.track == null && this.getTag() != null) {
            this.track = WailaTickHandler.instance().progressTracker.createInfo(this.getTag(), progress, this.canDecrease, this.getSize().field_1342);
        }
        if (this.track != null) {
            progress = this.track.tick(class_310.method_1551().method_1534());
        }
        this.style.render(guiGraphics, x + b, y + b, maxX - x - b * 2.0f, size.field_1342 - b * 2.0f - 2.0f, progress, this.text);
    }

    @Override
    @Nullable
    public String getMessage() {
        return this.text == null ? null : this.text.getString();
    }
}

