/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.shapes;

import it.unimi.dsi.fastutil.doubles.DoubleList;
import me.jellysquid.mods.lithium.common.shapes.CuboidVoxelSet;
import me.jellysquid.mods.lithium.common.shapes.VoxelShapeAlignedCuboidOffset;
import me.jellysquid.mods.lithium.common.shapes.VoxelShapeSimpleCube;
import net.minecraft.class_2335;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_246;
import net.minecraft.class_251;
import net.minecraft.class_265;
import net.minecraft.class_3532;

public class VoxelShapeAlignedCuboid
extends VoxelShapeSimpleCube {
    static final double LARGE_EPSILON = 1.0E-6;
    protected final int xSegments;
    protected final int ySegments;
    protected final int zSegments;

    public VoxelShapeAlignedCuboid(double minX, double minY, double minZ, double maxX, double maxY, double maxZ, int xRes, int yRes, int zRes) {
        super(new CuboidVoxelSet(1 << xRes, 1 << yRes, 1 << zRes, minX, minY, minZ, maxX, maxY, maxZ), minX, minY, minZ, maxX, maxY, maxZ);
        this.xSegments = 1 << xRes;
        this.ySegments = 1 << yRes;
        this.zSegments = 1 << zRes;
    }

    public VoxelShapeAlignedCuboid(class_251 voxels, int xSegments, int ySegments, int zSegments, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(voxels, minX, minY, minZ, maxX, maxY, maxZ);
        this.xSegments = xSegments;
        this.ySegments = ySegments;
        this.zSegments = zSegments;
    }

    @Override
    public class_265 method_1096(double x, double y, double z) {
        return new VoxelShapeAlignedCuboidOffset(this, this.field_1401, x, y, z);
    }

    @Override
    public double method_1103(class_2335 cycleDirection, class_238 box, double maxDist) {
        if (Math.abs(maxDist) < 1.0E-7) {
            return 0.0;
        }
        double penetration = this.calculatePenetration(cycleDirection, box, maxDist);
        if (penetration != maxDist && this.intersects(cycleDirection, box)) {
            return penetration;
        }
        return maxDist;
    }

    private double calculatePenetration(class_2335 dir, class_238 box, double maxDist) {
        switch (dir) {
            case field_10962: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minX, this.maxX, this.xSegments, box.field_1323, box.field_1320, maxDist);
            }
            case field_10963: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minZ, this.maxZ, this.zSegments, box.field_1321, box.field_1324, maxDist);
            }
            case field_10965: {
                return VoxelShapeAlignedCuboid.calculatePenetration(this.minY, this.maxY, this.ySegments, box.field_1322, box.field_1325, maxDist);
            }
        }
        throw new IllegalArgumentException();
    }

    private static double calculatePenetration(double aMin, double aMax, int segmentsPerUnit, double bMin, double bMax, double maxDist) {
        if (maxDist > 0.0) {
            double gap = aMin - bMax;
            if (gap >= -1.0E-7) {
                return Math.min(gap, maxDist);
            }
            if (segmentsPerUnit == 1) {
                return maxDist;
            }
            double wallPos = (double)class_3532.method_15384((double)((bMax - 1.0E-7) * (double)segmentsPerUnit)) / (double)segmentsPerUnit;
            if (wallPos < aMax - 1.0E-6) {
                return Math.min(maxDist, wallPos - bMax);
            }
            return maxDist;
        }
        double gap = aMax - bMin;
        if (gap <= 1.0E-7) {
            return Math.max(gap, maxDist);
        }
        if (segmentsPerUnit == 1) {
            return maxDist;
        }
        double wallPos = (double)class_3532.method_15357((double)((bMin + 1.0E-7) * (double)segmentsPerUnit)) / (double)segmentsPerUnit;
        if (wallPos > aMin + 1.0E-6) {
            return Math.max(maxDist, wallPos - bMin);
        }
        return maxDist;
    }

    @Override
    public DoubleList method_1109(class_2350.class_2351 axis) {
        return new class_246(axis.method_10173(this.xSegments, this.ySegments, this.zSegments));
    }

    @Override
    protected double method_1099(class_2350.class_2351 axis, int index) {
        return (double)index / (double)axis.method_10173(this.xSegments, this.ySegments, this.zSegments);
    }

    @Override
    protected int method_1100(class_2350.class_2351 axis, double coord) {
        int i = axis.method_10173(this.xSegments, this.ySegments, this.zSegments);
        return class_3532.method_15340((int)class_3532.method_15357((double)(coord * (double)i)), (int)-1, (int)i);
    }
}

