/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.cable;

import com.google.common.collect.Iterables;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import org.apache.commons.lang3.mutable.MutableBoolean;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.cable.CableBlock;
import owmii.powah.block.cable.CableNet;
import owmii.powah.config.v2.types.CableConfig;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IInventoryHolder;

public abstract class CableTile
extends AbstractEnergyStorage<CableConfig, CableBlock>
implements IInventoryHolder {
    private static final String NBT_ENERGY_SIDES = "cs";
    public final EnumSet<class_2350> energySides = EnumSet.noneOf(class_2350.class);
    @Nullable
    CableNet net = null;
    protected MutableBoolean netInsertionGuard = new MutableBoolean(false);
    protected int startIndex = 0;

    public CableTile(class_2338 pos, class_2680 state, Tier variant) {
        super(Tiles.CABLE.get(), pos, state, variant);
    }

    public void method_10996() {
        super.method_10996();
        CableNet.addCable(this);
    }

    public void method_11012() {
        super.method_11012();
        CableNet.removeCable(this);
    }

    public boolean isActive() {
        class_1937 class_19372 = this.method_10997();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            return serverLevel.method_14178().method_37114(class_1923.method_37232((class_2338)this.method_11016()));
        }
        return false;
    }

    protected Iterable<CableTile> getCables() {
        if (this.net == null) {
            CableNet.calculateNetwork(this);
        }
        this.startIndex %= this.net.cableList.size();
        return Iterables.concat(this.net.cableList.subList(this.startIndex, this.net.cableList.size()), this.net.cableList.subList(0, this.startIndex));
    }

    @Override
    public void readSync(class_2487 compound) {
        super.readSync(compound);
        this.readEnergySides(compound);
    }

    @Override
    public class_2487 writeSync(class_2487 compound) {
        this.writeEnergySides(compound);
        return super.writeSync(compound);
    }

    private void readEnergySides(class_2487 compound) {
        this.energySides.clear();
        byte sideBits = compound.method_10571(NBT_ENERGY_SIDES);
        for (class_2350 side : class_2350.values()) {
            if ((sideBits & CableTile.getSideMask(side)) == 0) continue;
            this.energySides.add(side);
        }
    }

    private void writeEnergySides(class_2487 compound) {
        byte sideBits = 0;
        for (class_2350 side : this.energySides) {
            sideBits = (byte)(sideBits | CableTile.getSideMask(side));
        }
        compound.method_10567(NBT_ENERGY_SIDES, sideBits);
    }

    private static byte getSideMask(class_2350 side) {
        return (byte)(1 << side.ordinal());
    }

    @Override
    protected long getEnergyCapacity() {
        return 0L;
    }

    @Override
    public int getSlotLimit(int slot) {
        return 0;
    }

    @Override
    public boolean canInsert(int slot, class_1799 stack) {
        return false;
    }

    @Override
    public boolean canExtract(int slot, class_1799 stack) {
        return false;
    }

    @Override
    public boolean keepStorable() {
        return false;
    }
}

