/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energizing;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import net.minecraft.class_5455;
import owmii.powah.Powah;
import owmii.powah.lib.logistics.inventory.RecipeWrapper;
import owmii.powah.recipe.Recipes;

public class EnergizingRecipe
implements class_1860<RecipeWrapper> {
    public static final class_2960 ID = new class_2960("powah", "energizing");
    protected final class_2960 id;
    private final class_1799 output;
    private final long energy;
    private final class_2371<class_1856> ingredients;

    public EnergizingRecipe(class_2960 id, class_1799 output, long energy, class_1856 ... ingredients) {
        this(id, output, energy, (class_2371<class_1856>)class_2371.method_10212((Object)class_1856.field_9017, (Object[])ingredients));
    }

    public EnergizingRecipe(class_2960 id, class_1799 output, long energy, class_2371<class_1856> ingredients) {
        this.id = id;
        this.output = output;
        this.energy = energy;
        this.ingredients = ingredients;
    }

    public boolean matches(RecipeWrapper inv, class_1937 world) {
        ArrayList<class_1856> stacks = new ArrayList<class_1856>((Collection<class_1856>)this.method_8117());
        for (int i = 1; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (stack.method_7960()) continue;
            boolean flag = false;
            Iterator itr = stacks.iterator();
            while (itr.hasNext()) {
                class_1856 ingredient = (class_1856)itr.next();
                if (!ingredient.method_8093(stack)) continue;
                flag = true;
                itr.remove();
                break;
            }
            if (flag) continue;
            return false;
        }
        return stacks.isEmpty();
    }

    public class_1799 assemble(RecipeWrapper inv, class_5455 registry) {
        return this.output.method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 getResultItem() {
        return this.output;
    }

    public class_1799 method_8110(class_5455 registryAccess) {
        return this.output;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return Recipes.ENERGIZING_SERIALIZER.get();
    }

    public class_3956<?> method_17716() {
        return Recipes.ENERGIZING.get();
    }

    public long getEnergy() {
        return this.energy;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public boolean method_8118() {
        return true;
    }

    public static class Serializer
    implements class_1865<EnergizingRecipe> {
        public EnergizingRecipe fromJson(class_2960 recipeId, JsonObject json) {
            class_2371<class_1856> list = Serializer.readIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            long energy = Long.parseLong(class_3518.method_15253((JsonObject)json, (String)"energy", (String)"0"));
            energy = Math.max(1L, (long)((double)energy * Powah.config().general.energizing_energy_ratio));
            if (list.isEmpty()) {
                throw new JsonParseException("No ingredients for energizing recipe");
            }
            if (list.size() > 6) {
                throw new JsonParseException("Too many ingredients for energizing recipe the max is 6");
            }
            if (energy <= 0L) {
                throw new JsonParseException("Energizing recipe require energy to work!!");
            }
            class_1799 result = class_1869.method_35228((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result"));
            return new EnergizingRecipe(recipeId, result, energy, list);
        }

        private static class_2371<class_1856> readIngredients(JsonArray elements) {
            class_2371 list = class_2371.method_10211();
            IntStream.range(0, elements.size()).mapToObj(i -> class_1856.method_52177((JsonElement)elements.get(i))).filter(ingredient -> !ingredient.method_8103()).forEach(arg_0 -> list.add(arg_0));
            return list;
        }

        @Nullable
        public EnergizingRecipe fromNetwork(class_2960 recipeId, class_2540 buffer) {
            class_2371 list = class_2371.method_10213((int)buffer.readInt(), (Object)class_1856.field_9017);
            IntStream.range(0, list.size()).forEach(i -> list.set(i, (Object)class_1856.method_8086((class_2540)buffer)));
            return new EnergizingRecipe(recipeId, buffer.method_10819(), buffer.readLong(), (class_2371<class_1856>)list);
        }

        public void toNetwork(class_2540 buffer, EnergizingRecipe recipe) {
            buffer.writeInt(recipe.ingredients.size());
            recipe.ingredients.forEach(ingredient -> ingredient.method_8088(buffer));
            buffer.method_10793(recipe.output);
            buffer.writeLong(recipe.energy);
        }
    }
}

