/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.block.energycell;

import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import owmii.powah.block.Tier;
import owmii.powah.block.Tiles;
import owmii.powah.block.energycell.EnergyCellBlock;
import owmii.powah.config.v2.types.EnergyConfig;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.block.IInventoryHolder;
import owmii.powah.lib.logistics.Transfer;
import owmii.powah.lib.logistics.energy.Energy;

public class EnergyCellTile
extends AbstractEnergyStorage<EnergyConfig, EnergyCellBlock>
implements IInventoryHolder {
    public EnergyCellTile(class_2338 pos, class_2680 state, Tier tier) {
        super(Tiles.ENERGY_CELL.get(), pos, state, tier);
        this.inv.add(2);
    }

    public EnergyCellTile(class_2338 pos, class_2680 state) {
        this(pos, state, Tier.STARTER);
    }

    @Override
    protected void onFirstTick(class_1937 world) {
        super.onFirstTick(world);
        if (this.isCreative()) {
            this.energy.setStored(this.getEnergyCapacity());
        }
    }

    @Override
    protected int postTick(class_1937 world) {
        return this.chargeItems(2) + this.extractFromSides(world) > 0L ? 10 : -1;
    }

    @Override
    public long extractEnergy(long maxExtract, boolean simulate, @Nullable class_2350 side) {
        return super.extractEnergy(maxExtract, simulate || this.isCreative(), side);
    }

    @Override
    public long receiveEnergy(long maxReceive, boolean simulate, @Nullable class_2350 side) {
        return super.receiveEnergy(maxReceive, simulate, side);
    }

    @Override
    public boolean canExtractEnergy(@Nullable class_2350 side) {
        return this.checkRedstone() && super.canExtractEnergy(side);
    }

    @Override
    public boolean canReceiveEnergy(@Nullable class_2350 side) {
        return this.checkRedstone() && super.canReceiveEnergy(side);
    }

    @Override
    public boolean keepEnergy() {
        return !this.isCreative();
    }

    @Override
    public Transfer getTransferType() {
        return this.isCreative() ? Transfer.EXTRACT : super.getTransferType();
    }

    public boolean isCreative() {
        return ((Tier)this.getVariant()).equals(Tier.CREATIVE);
    }

    @Override
    public int getSlotLimit(int slot) {
        return 1;
    }

    @Override
    public boolean canInsert(int slot, class_1799 stack) {
        return Energy.chargeable(stack);
    }

    @Override
    public boolean canExtract(int slot, class_1799 stack) {
        return true;
    }
}

