/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.block;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import owmii.powah.EnvHandler;
import owmii.powah.api.energy.IEnergyConnector;
import owmii.powah.block.Tier;
import owmii.powah.config.IConfigHolder;
import owmii.powah.config.IEnergyConfig;
import owmii.powah.lib.block.AbstractBlock;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.client.util.Text;
import owmii.powah.lib.client.wiki.page.panel.InfoBox;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.item.IEnergyItemProvider;
import owmii.powah.lib.logistics.Transfer;
import owmii.powah.lib.logistics.energy.Energy;
import owmii.powah.lib.registry.IVariant;
import owmii.powah.lib.util.Util;

public abstract class AbstractEnergyBlock<C extends IEnergyConfig<Tier>, B extends AbstractEnergyBlock<C, B>>
extends AbstractBlock<Tier, B>
implements IConfigHolder<Tier, C>,
InfoBox.IInfoBoxHolder,
IEnergyItemProvider {
    public AbstractEnergyBlock(class_4970.class_2251 properties) {
        this(properties, (Tier)IVariant.getEmpty());
    }

    public AbstractEnergyBlock(class_4970.class_2251 properties, Tier variant) {
        super(properties, variant);
    }

    @Override
    public EnergyBlockItem getBlockItem(class_1792.class_1793 properties, @Nullable class_5321<class_1761> group) {
        return new EnergyBlockItem(this, properties, group);
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 tile = world.method_8321(pos);
        if (tile instanceof AbstractEnergyStorage) {
            return ((AbstractEnergyStorage)tile).getEnergy().toComparatorPower();
        }
        return super.method_9572(state, world, pos);
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        if (this.checkValidEnergySide()) {
            class_1937 level;
            class_2350 side = (class_2350)state.method_11654((class_2769)class_2741.field_12525);
            class_2338 pos1 = pos.method_10093(side);
            return world.method_8320(pos1).method_26204() instanceof IEnergyConnector || world instanceof class_1937 && EnvHandler.INSTANCE.hasEnergy(level = (class_1937)world, pos1, side.method_10153());
        }
        return super.method_9558(state, world, pos);
    }

    protected boolean checkValidEnergySide() {
        return false;
    }

    @Override
    public boolean isChargeable(class_1799 stack) {
        return this.getTransferType().canReceive;
    }

    public Transfer getTransferType() {
        return Transfer.ALL;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 worldIn, List<class_2561> tooltip, class_1836 flagIn) {
        Energy.ifPresent(stack, energy -> {
            this.addEnergyInfo(stack, (Energy.Item)energy, tooltip);
            this.addEnergyTransferInfo(stack, (Energy.Item)energy, tooltip);
            this.additionalEnergyInfo(stack, (Energy.Item)energy, tooltip);
            tooltip.add((class_2561)class_2561.method_43473());
        });
    }

    public void addEnergyInfo(class_1799 stack, Energy.Item storage, List<class_2561> tooltip) {
        if (storage.getCapacity() > 0L) {
            tooltip.add((class_2561)class_2561.method_43471((String)"info.lollipop.stored").method_27692(class_124.field_1080).method_10852(Text.COLON).method_10852((class_2561)class_2561.method_43469((String)"info.lollipop.fe.stored", (Object[])new Object[]{Util.addCommas(storage.getStored()), Util.numFormat(storage.getCapacity())}).method_27692(class_124.field_1063)));
        }
    }

    public void addEnergyTransferInfo(class_1799 stack, Energy.Item storage, List<class_2561> tooltip) {
        long re;
        long ext = storage.getMaxExtract();
        if (ext + (re = storage.getMaxReceive()) > 0L) {
            if (ext == re) {
                tooltip.add((class_2561)class_2561.method_43471((String)"info.lollipop.max.io").method_27692(class_124.field_1080).method_10852(Text.COLON).method_10852((class_2561)class_2561.method_43470((String)Util.numFormat(ext)).method_10852((class_2561)class_2561.method_43471((String)"info.lollipop.fe.pet.tick")).method_27692(class_124.field_1063)));
            } else {
                if (ext > 0L) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"info.lollipop.max.extract").method_27692(class_124.field_1080).method_10852(Text.COLON).method_10852((class_2561)class_2561.method_43470((String)Util.numFormat(ext)).method_10852((class_2561)class_2561.method_43471((String)"info.lollipop.fe.pet.tick")).method_27692(class_124.field_1063)));
                }
                if (re > 0L) {
                    tooltip.add((class_2561)class_2561.method_43471((String)"info.lollipop.max.receive").method_27692(class_124.field_1080).method_10852(Text.COLON).method_10852((class_2561)class_2561.method_43470((String)Util.numFormat(re)).method_10852((class_2561)class_2561.method_43471((String)"info.lollipop.fe.pet.tick")).method_27692(class_124.field_1063)));
                }
            }
        }
    }

    public void additionalEnergyInfo(class_1799 stack, Energy.Item energy, List<class_2561> tooltip) {
    }

    @Override
    public InfoBox getInfoBox(class_1799 stack, InfoBox box) {
        Energy.ifPresent(stack, storage -> {
            if (storage != null) {
                if (storage.getMaxEnergyStored() > 0L) {
                    box.set(class_2561.method_43471((String)"info.lollipop.capacity"), class_2561.method_43469((String)"info.lollipop.fe", (Object[])new Object[]{Util.addCommas(storage.getCapacity())}));
                }
                box.set(class_2561.method_43471((String)"info.lollipop.max.io"), class_2561.method_43469((String)"info.lollipop.fe.pet.tick", (Object[])new Object[]{Util.addCommas(storage.getMaxExtract())}));
            }
        });
        return box;
    }
}

