/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.wiki;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_7923;
import owmii.powah.Powah;
import owmii.powah.lib.client.wiki.Icon;
import owmii.powah.lib.client.wiki.Section;
import owmii.powah.lib.client.wiki.Wiki;
import owmii.powah.lib.registry.VarReg;

public class Entry {
    private final List<Section> sections = new ArrayList<Section>();
    private final String name;
    private final Wiki wiki;
    private boolean isMain;
    private boolean stackName;
    @Nullable
    private final Icon icon;
    @Nullable
    private Entry parent;

    public Entry(String name, Wiki wiki) {
        this(name, null, wiki);
    }

    public Entry(String name, @Nullable Icon icon, Wiki wiki) {
        this.wiki = wiki;
        if (icon == null) {
            List<class_1792> items = VarReg.getSiblingIds(name).stream().map(s -> (class_1792)class_7923.field_41178.method_10223(Powah.id(s))).toList();
            this.icon = items.isEmpty() ? null : new Icon((class_1935)items.get(0));
            this.name = name;
        } else {
            this.icon = icon;
            class_1799 stack = icon.getStack();
            if (name.isEmpty() && !stack.method_7960()) {
                this.name = stack.method_7922();
                this.stackName = true;
            } else {
                this.name = name;
            }
        }
    }

    public Entry s(Consumer<Section> consumer) {
        Section section = new Section(this);
        consumer.accept(section);
        this.sections.add(section);
        return this;
    }

    public Wiki getWiki() {
        return this.wiki;
    }

    @Nullable
    public Icon getIcon() {
        return this.icon;
    }

    public class_1799 getStack() {
        if (this.icon != null) {
            return this.icon.getStack();
        }
        return class_1799.field_8037;
    }

    public Section getSections(int index) {
        return this.sections.get(index);
    }

    public List<Section> getSections() {
        return this.sections;
    }

    public String getName() {
        return this.name;
    }

    public boolean isMain() {
        return this.isMain;
    }

    public Entry setMain(boolean main) {
        this.isMain = main;
        return this;
    }

    @Nullable
    public Entry getParent() {
        return this.parent;
    }

    public Entry setParent(@Nullable Entry parent) {
        this.parent = parent;
        return this;
    }

    public String getTransKey() {
        return this.stackName ? this.name : "wiki." + this.getWiki().getModId() + "." + this.name;
    }
}

