/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.client.wiki;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import owmii.powah.lib.client.screen.Texture;
import owmii.powah.lib.client.screen.widget.IconButton;
import owmii.powah.lib.client.screen.wiki.WikiScreen;
import owmii.powah.lib.client.util.MC;
import owmii.powah.lib.client.wiki.Entry;
import owmii.powah.lib.client.wiki.Section;
import owmii.powah.lib.client.wiki.Wiki;
import owmii.powah.lib.client.wiki.page.panel.Panel;

public class Page {
    private final String name;
    private final Section parent;
    @Nullable
    private Page next;
    @Nullable
    private Page prev;
    protected IconButton navNext = IconButton.EMPTY;
    protected IconButton navPrev = IconButton.EMPTY;

    public Page(String name, Section parent) {
        this.name = name;
        this.parent = parent;
    }

    public void init(int x, int y, WikiScreen screen) {
        if (!this.isPanel()) {
            List<Entry> categories = this.getWiki().getCategories();
            for (int i = 0; i < categories.size(); ++i) {
                Entry currEntry;
                Entry catEntry = categories.get(i).getParent();
                if (catEntry == null || (currEntry = screen.getEntry().getParent()) == null) continue;
                boolean b = currEntry.equals(catEntry);
                screen.addButton2(new IconButton(x + (b ? 0 : 2), 10 + y + i * 28, catEntry.getStack(), Texture.WIKI_TABS.get(b), button -> MC.open(new WikiScreen(catEntry.getSections(0))), (class_437)screen).xOffset(b ? -2.0f : 0.5f).setTooltip((class_2561)class_2561.method_43471((String)catEntry.getTransKey())));
            }
        }
        this.navNext = screen.addButton2(new IconButton(x + (this.isPanel() ? 140 : 224), y - 7 + screen.h, Texture.WIKI_NEXT, button -> {
            if (this.next != null) {
                if (this.isPanel()) {
                    screen.setPanel((Panel)this.next);
                } else {
                    screen.setPage(this.next);
                }
                MC.open(screen);
            }
        }, screen));
        this.navPrev = screen.addButton2(new IconButton(x + 7, y - 7 + screen.h, Texture.WIKI_PREV, button -> {
            if (this.prev != null) {
                if (this.isPanel()) {
                    screen.setPanel((Panel)this.prev);
                } else {
                    screen.setPage(this.prev);
                }
                MC.open(screen);
            }
        }, screen));
        this.refresh();
    }

    public void refresh() {
        this.navNext.field_22764 = this.next != null;
        this.navPrev.field_22764 = this.prev != null;
    }

    public void render(class_332 gui, int x, int y, int mx, int my, float pt, class_327 font, WikiScreen screen) {
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double i) {
        return false;
    }

    public void onClose() {
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public boolean hasPrev() {
        return this.prev != null;
    }

    @Nullable
    public Page next() {
        return this.next;
    }

    @Nullable
    public Page prev() {
        return this.prev;
    }

    public Page next(@Nullable Page next) {
        this.next = next;
        if (next != null) {
            next.prev = this;
        }
        return this;
    }

    public String getName() {
        return this.name;
    }

    public Wiki getWiki() {
        return this.getSection().getEntry().getWiki();
    }

    public Section getSection() {
        return Objects.requireNonNull(this.parent);
    }

    public boolean isPanel() {
        return this instanceof Panel;
    }
}

