/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.logistics.energy;

import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import owmii.powah.lib.item.EnergyBlockItem;
import owmii.powah.lib.item.IEnergyContainingItem;
import owmii.powah.lib.util.Stack;
import owmii.powah.lib.util.Util;

public class Energy {
    public static final Energy EMPTY = Energy.create(0L);
    public static final long MAX = 9000000000000000000L;
    public static final long MIN = 0L;
    private long capacity;
    private long stored;
    private long maxExtract;
    private long maxReceive;
    @Nullable
    public Object platformWrapper;

    public Energy(Energy energy) {
        this(energy.capacity, energy.maxExtract, energy.maxReceive);
        this.setStored(energy.stored);
    }

    public Energy(long capacity, long maxExtract, long maxReceive) {
        this.capacity = capacity;
        this.maxExtract = maxExtract;
        this.maxReceive = maxReceive;
    }

    public static Energy create(long capacity) {
        return Energy.create(capacity, capacity, capacity);
    }

    public static Energy create(long capacity, long transfer) {
        return Energy.create(capacity, transfer, transfer);
    }

    public static Energy from(Energy energy) {
        return new Energy(energy);
    }

    public static Energy create(long capacity, long maxExtract, long maxReceive) {
        return new Energy(capacity, maxExtract, maxReceive);
    }

    public boolean clone(Energy other) {
        boolean flag = false;
        if (this.capacity != other.capacity) {
            this.setCapacity(other.getCapacity());
            flag = true;
        }
        if (this.stored != other.stored) {
            this.setStored(other.getStored());
            flag = true;
        }
        if (this.getTransfer() != other.getTransfer()) {
            this.setTransfer(other.getTransfer());
            flag = true;
        }
        return flag;
    }

    public Energy read(class_2487 nbt, boolean capacity, boolean transfer) {
        return this.read(nbt, "main_energy", capacity, transfer);
    }

    public Energy read(class_2487 nbt, String key, boolean capacity, boolean transfer) {
        if (capacity) {
            this.capacity = nbt.method_10537("energy_capacity_" + key);
        }
        this.stored = nbt.method_10537("energy_stored_" + key);
        if (transfer) {
            this.maxExtract = nbt.method_10537("max_extract_" + key);
            this.maxReceive = nbt.method_10537("max_receive_" + key);
        }
        return this;
    }

    public class_2487 write(boolean capacity, boolean transfer) {
        return this.write("main_energy", capacity, transfer);
    }

    public class_2487 write(String key, boolean capacity, boolean transfer) {
        return this.write(new class_2487(), key, capacity, transfer);
    }

    public class_2487 write(class_2487 nbt, boolean capacity, boolean transfer) {
        return this.write(nbt, "main_energy", capacity, transfer);
    }

    public class_2487 write(class_2487 nbt, String key, boolean capacity, boolean transfer) {
        if (capacity) {
            nbt.method_10544("energy_capacity_" + key, this.capacity);
        }
        nbt.method_10544("energy_stored_" + key, this.stored);
        if (transfer) {
            nbt.method_10544("max_extract_" + key, this.maxExtract);
            nbt.method_10544("max_receive_" + key, this.maxReceive);
        }
        return nbt;
    }

    public long receiveEnergy(long maxReceive, boolean simulate) {
        if (!this.canReceive()) {
            return 0L;
        }
        long received = Math.min(this.capacity - this.stored, Math.min(this.maxReceive, maxReceive));
        if (!simulate) {
            this.produce(received);
        }
        return Util.safeInt(received);
    }

    public long extractEnergy(long maxExtract, boolean simulate) {
        if (!this.canExtract()) {
            return 0L;
        }
        long extracted = Math.min(this.stored, Math.min(this.maxExtract, maxExtract));
        if (!simulate) {
            this.consume(extracted);
        }
        return Util.safeInt(extracted);
    }

    public void addCapacity(long amount) {
        this.setCapacity(this.getCapacity() + amount);
    }

    public void removeCapacity(long amount) {
        this.setCapacity(this.getCapacity() - amount);
    }

    public long produce(long amount) {
        long min = Math.min(this.capacity - this.stored, Math.max(0L, amount));
        this.stored += min;
        return min;
    }

    public long consume(long amount) {
        long min = Math.min(this.stored, Math.max(0L, amount));
        this.stored -= min;
        return min;
    }

    public long getEmpty() {
        return this.getCapacity() - this.getStored();
    }

    public long getCapacity() {
        return this.capacity;
    }

    public Energy setCapacity(long capacity) {
        this.capacity = Math.max(0L, Math.min(9000000000000000000L, capacity));
        if (this.stored > this.capacity) {
            this.stored = this.capacity;
        }
        return this;
    }

    public Energy setAll(long value) {
        this.setCapacity(value);
        this.setTransfer(value);
        return this;
    }

    public long getStored() {
        return Math.min(this.stored, this.capacity);
    }

    public Energy setStored(long stored) {
        this.stored = Math.max(0L, Math.min(this.capacity, stored));
        return this;
    }

    public long getMaxExtract() {
        return this.maxExtract;
    }

    public Energy setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public long getMaxReceive() {
        return this.maxReceive;
    }

    public Energy setMaxReceive(long maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public Energy setMaxTransfer() {
        this.maxReceive = 9000000000000000000L;
        this.maxExtract = 9000000000000000000L;
        return this;
    }

    public Energy setTransfer(long transfer) {
        this.maxReceive = transfer;
        this.maxExtract = transfer;
        return this;
    }

    public long getTransfer() {
        return Math.max(this.maxExtract, this.maxReceive);
    }

    public long getEnergyStored() {
        return this.stored;
    }

    public long getMaxEnergyStored() {
        return this.capacity;
    }

    public boolean canExtract() {
        return this.maxExtract > 0L && !this.isEmpty();
    }

    public boolean canReceive() {
        return this.maxReceive > 0L && !this.isFull();
    }

    public int toComparatorPower() {
        return (int)(this.subSized() * 15.0f);
    }

    public float subSized() {
        return this.capacity > 0L ? (float)this.stored / (float)this.capacity : 0.0f;
    }

    public boolean hasEnergy() {
        return !this.isEmpty();
    }

    public boolean isEmpty() {
        return this.stored <= 0L;
    }

    public boolean isFull() {
        return this.stored > 0L && this.stored >= this.capacity;
    }

    public long getPercent() {
        return (long)(this.subSized() * 100.0f);
    }

    public static long extract(class_1799 stack, long energy, boolean simulate) {
        return Energy.getEnergy(stack).orElse(EMPTY).extractEnergy(Util.safeInt(energy), simulate);
    }

    public static long receive(class_1799 stack, long energy, boolean simulate) {
        return Energy.getEnergy(stack).orElse(EMPTY).receiveEnergy(Util.safeInt(energy), simulate);
    }

    public static long getStored(class_1799 stack) {
        return Energy.getEnergy(stack).orElse(EMPTY).getEnergyStored();
    }

    public static void ifPresent(class_1799 stack, Consumer<Item> energyItem) {
        Energy.get(stack).ifPresent(energyItem);
    }

    public static Optional<Item> get(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof IEnergyContainingItem) {
            IEnergyContainingItem eci = (IEnergyContainingItem)class_17922;
            return Optional.ofNullable(eci.getEnergyInfo()).map(info -> new Item(stack, (IEnergyContainingItem.Info)info));
        }
        return Optional.empty();
    }

    public static Optional<Energy> getEnergy(class_1799 stack) {
        return Energy.get(stack).map(x -> x);
    }

    public static boolean chargeable(class_1799 stack) {
        EnergyBlockItem item;
        if (stack.method_7909() instanceof EnergyBlockItem && !(item = (EnergyBlockItem)stack.method_7909()).isChargeable(stack)) {
            return false;
        }
        return Energy.isPresent(stack);
    }

    public static boolean isPresent(class_1799 stack) {
        return Energy.get(stack).isPresent();
    }

    public static class Item
    extends Energy {
        private final class_1799 stack;

        public Item(class_1799 stack, Item energy) {
            super(energy);
            this.stack = stack;
        }

        public Item(class_1799 stack, IEnergyContainingItem.Info info) {
            this(stack, info.capacity(), info.maxExtract(), info.maxInsert());
        }

        public Item(class_1799 stack, long capacity, long maxExtract, long maxReceive) {
            super(capacity, maxExtract, maxReceive);
            this.stack = stack;
            this.read(Stack.getTagOrEmpty(stack).method_10562("powah_tile_data"), false, false);
        }

        private void write() {
            this.write(this.stack.method_7911("powah_tile_data"), false, false);
        }

        @Override
        public long receiveEnergy(long maxReceive, boolean simulate) {
            long energy = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                this.write();
            }
            return energy;
        }

        @Override
        public long extractEnergy(long maxExtract, boolean simulate) {
            long energy = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                this.write();
            }
            return energy;
        }

        @Override
        public long consume(long amount) {
            long ret = super.consume(amount);
            this.write();
            return ret;
        }

        public void setStoredAndWrite(long stored) {
            this.setStored(stored);
            this.write();
        }
    }
}

