/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.logistics.energy;

import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import owmii.powah.lib.block.AbstractEnergyStorage;
import owmii.powah.lib.logistics.Transfer;

public class SideConfig {
    private final Transfer[] transfers = new Transfer[6];
    private final AbstractEnergyStorage storage;
    private boolean isSetFromNBT;

    public SideConfig(AbstractEnergyStorage storage) {
        this.storage = storage;
        Arrays.fill((Object[])this.transfers, (Object)Transfer.NONE);
    }

    public void init() {
        if (!this.isSetFromNBT) {
            for (class_2350 side : class_2350.values()) {
                this.setType(side, this.storage.getTransferType());
            }
        }
    }

    public void read(class_2487 nbt) {
        if (nbt.method_10573("side_transfer_type", 11)) {
            int[] arr = nbt.method_10561("side_transfer_type");
            for (int i = 0; i < arr.length; ++i) {
                this.transfers[i] = Transfer.values()[arr[i]];
            }
            this.isSetFromNBT = true;
        }
    }

    public class_2487 write(class_2487 nbt) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int valuesLength = this.transfers.length;
        for (int i = 0; i < valuesLength; ++i) {
            list.add(i, this.transfers[i].ordinal());
        }
        nbt.method_10572("side_transfer_type", list);
        return nbt;
    }

    public void nextTypeAll() {
        if (this.isAllEquals()) {
            for (class_2350 side : class_2350.values()) {
                this.nextType(side);
            }
        } else {
            for (class_2350 side : class_2350.values()) {
                this.setType(side, Transfer.ALL);
            }
        }
    }

    public boolean isAllEquals() {
        boolean flag = true;
        int first = -1;
        for (int i = 1; i < 6; ++i) {
            if (!this.storage.isEnergyPresent(class_2350.method_10143((int)i))) continue;
            if (first < 0) {
                first = this.transfers[i].ordinal();
                continue;
            }
            if (this.transfers[i].ordinal() == first) continue;
            flag = false;
        }
        return flag;
    }

    public void nextType(@Nullable class_2350 side) {
        this.setType(side, this.getType(side).next(this.storage.getTransferType()));
    }

    public Transfer getType(@Nullable class_2350 side) {
        if (side != null) {
            return this.transfers[side.method_10146()];
        }
        return Transfer.NONE;
    }

    public void setType(@Nullable class_2350 side, Transfer type) {
        if (side == null || this.storage.getTransferType().equals((Object)Transfer.NONE)) {
            return;
        }
        if (!this.storage.isEnergyPresent(side)) {
            return;
        }
        this.transfers[side.method_10146()] = type;
    }
}

