/*
 * Decompiled with CFR 0.152.
 */
package owmii.powah.lib.util.math;

import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;

public class Box {
    private double down;
    private double up;
    private double north;
    private double south;
    private double west;
    private double east;
    private double downBase;
    private double upBase;
    private double northBase;
    private double southBase;
    private double westBase;
    private double eastBase;
    private final double min;
    private final double max;

    public Box(double dim, double min, double max) {
        this(dim, dim, dim, dim, dim, dim, min, max);
    }

    public Box(double down, double up, double north, double south, double west, double east, double min, double max) {
        this.down = down;
        this.up = up;
        this.north = north;
        this.south = south;
        this.west = west;
        this.east = east;
        this.downBase = down;
        this.upBase = up;
        this.northBase = north;
        this.southBase = south;
        this.westBase = west;
        this.eastBase = east;
        this.min = min;
        this.max = max;
    }

    public void read(class_2487 nbt, String key) {
        this.down = nbt.method_10574("down_" + key);
        this.up = nbt.method_10574("up_" + key);
        this.north = nbt.method_10574("north_" + key);
        this.south = nbt.method_10574("south_" + key);
        this.west = nbt.method_10574("west_" + key);
        this.east = nbt.method_10574("east_" + key);
    }

    public class_2487 write(class_2487 nbt, String key) {
        nbt.method_10549("down_" + key, this.down);
        nbt.method_10549("up_" + key, this.up);
        nbt.method_10549("north_" + key, this.north);
        nbt.method_10549("south_" + key, this.south);
        nbt.method_10549("west_" + key, this.west);
        nbt.method_10549("east_" + key, this.east);
        return nbt;
    }

    public class_238 geAxis() {
        return this.geAxis(class_243.field_1353);
    }

    public class_238 geAxis(class_2338 pos) {
        return this.geAxis(class_243.method_24954((class_2382)pos));
    }

    public class_238 geAxis(class_243 vector3d) {
        return new class_238(-this.west, -this.down, -this.north, this.east + 1.0, this.up + 1.0, this.south + 1.0).method_997(vector3d);
    }

    public Box reset() {
        this.down = this.downBase;
        this.up = this.upBase;
        this.north = this.northBase;
        this.south = this.southBase;
        this.west = this.westBase;
        this.east = this.eastBase;
        return this;
    }

    public double get(class_2350 direction) {
        switch (direction) {
            case field_11033: {
                return this.getDown();
            }
            case field_11036: {
                return this.getUp();
            }
            case field_11043: {
                return this.getNorth();
            }
            case field_11035: {
                return this.getSouth();
            }
            case field_11039: {
                return this.getWest();
            }
        }
        return this.getEast();
    }

    public Box add(class_2350 direction, double value) {
        switch (direction) {
            case field_11033: {
                this.down(value);
                break;
            }
            case field_11036: {
                this.up(value);
                break;
            }
            case field_11043: {
                this.north(value);
                break;
            }
            case field_11035: {
                this.south(value);
                break;
            }
            case field_11039: {
                this.west(value);
                break;
            }
            case field_11034: {
                this.east(value);
            }
        }
        return this;
    }

    public Box set(class_2350 direction, double value) {
        switch (direction) {
            case field_11033: {
                this.setDown(value);
                break;
            }
            case field_11036: {
                this.setUp(value);
                break;
            }
            case field_11043: {
                this.setNorth(value);
                break;
            }
            case field_11035: {
                this.setSouth(value);
                break;
            }
            case field_11039: {
                this.setWest(value);
                break;
            }
            case field_11034: {
                this.setEast(value);
            }
        }
        return this;
    }

    public Box add(double value) {
        this.down(value);
        this.up(value);
        this.north(value);
        this.south(value);
        this.west(value);
        this.east(value);
        return this;
    }

    public Box set(double value) {
        this.setDown(value);
        this.setUp(value);
        this.setNorth(value);
        this.setSouth(value);
        this.setWest(value);
        this.setEast(value);
        return this;
    }

    public double getDown() {
        return this.down;
    }

    public Box down(double down) {
        this.setDown(this.down + down);
        return this;
    }

    public Box setDown(double down) {
        this.down = Math.min(this.max, Math.max(this.min, down));
        return this;
    }

    public double getUp() {
        return this.up;
    }

    public Box up(double up) {
        this.setUp(this.up + up);
        return this;
    }

    public Box setUp(double up) {
        this.up = Math.min(this.max, Math.max(this.min, up));
        return this;
    }

    public double getNorth() {
        return this.north;
    }

    public Box north(double north) {
        this.setNorth(this.north + north);
        return this;
    }

    public Box setNorth(double north) {
        this.north = Math.min(this.max, Math.max(this.min, north));
        return this;
    }

    public double getSouth() {
        return this.south;
    }

    public Box south(double south) {
        this.setSouth(this.south + south);
        return this;
    }

    public Box setSouth(double south) {
        this.south = Math.min(this.max, Math.max(this.min, south));
        return this;
    }

    public double getWest() {
        return this.west;
    }

    public Box west(double west) {
        this.setWest(this.west + west);
        return this;
    }

    public Box setWest(double west) {
        this.west = Math.min(this.max, Math.max(this.min, west));
        return this;
    }

    public double getEast() {
        return this.east;
    }

    public Box east(double east) {
        this.setEast(this.east + east);
        return this;
    }

    public Box setEast(double east) {
        this.east = Math.min(this.max, Math.max(this.min, east));
        return this;
    }
}

