/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagespawnpoint_common_fabric.events;

import com.mojang.logging.LogUtils;
import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.FeatureFunctions;
import com.natamus.villagespawnpoint_common_fabric.data.Constants;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5268;
import net.minecraft.class_5285;
import org.slf4j.Logger;

public class VillageSpawnEvent {
    private static final Logger logger = LogUtils.getLogger();

    public static boolean onWorldLoad(class_3218 serverLevel, class_5268 serverLevelData) {
        if (Constants.biomeSpawnPointLoaded) {
            return false;
        }
        class_5285 worldGeneratorOptions = serverLevel.method_8503().method_27728().method_28057();
        if (!worldGeneratorOptions.method_28029()) {
            return false;
        }
        logger.info("[Village Spawn Point] Finding the nearest village. This might take a few seconds.");
        class_2338 spawnpos = BlockPosFunctions.getCenterNearbyVillage((class_3218)serverLevel);
        if (spawnpos == null) {
            return false;
        }
        logger.info("[Village Spawn Point] Village found! The world will now generate.");
        serverLevel.method_8554(spawnpos, 1.0f);
        if (worldGeneratorOptions.method_28030()) {
            FeatureFunctions.placeBonusChest((class_1937)serverLevel, (class_2338)spawnpos);
        }
        return true;
    }
}

