/*
 * Decompiled with CFR 0.152.
 */
package dev.technici4n.moderndynamics.client.ber;

import dev.technici4n.moderndynamics.client.ber.FluidPipeRendering;
import dev.technici4n.moderndynamics.network.NodeHost;
import dev.technici4n.moderndynamics.network.fluid.FluidHost;
import dev.technici4n.moderndynamics.network.item.ItemHost;
import dev.technici4n.moderndynamics.network.item.sync.ClientTravelingItem;
import dev.technici4n.moderndynamics.network.item.sync.ClientTravelingItemSmoothing;
import dev.technici4n.moderndynamics.pipe.PipeBlockEntity;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;

@Environment(value=EnvType.CLIENT)
public class PipeBlockEntityRenderer
implements class_827<PipeBlockEntity> {
    private final class_5614.class_5615 ctx;
    private final Random random = new Random();
    private static final class_243 CENTER = new class_243(0.5, 0.5, 0.5);

    public PipeBlockEntityRenderer(class_5614.class_5615 ctx) {
        this.ctx = ctx;
    }

    public void render(PipeBlockEntity pipe, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        for (NodeHost host : pipe.getHosts()) {
            if (host instanceof ItemHost) {
                ItemHost itemHost = (ItemHost)host;
                for (ClientTravelingItem item : itemHost.getClientTravelingItems()) {
                    double ratio;
                    class_243 to;
                    class_243 from;
                    matrices.method_22903();
                    double distance = class_3532.method_15385((double)item.traveledDistance()) + ClientTravelingItemSmoothing.getAndUpdateDistanceDelta(item) + item.speed() * (double)tickDelta;
                    if (distance <= 0.5) {
                        from = PipeBlockEntityRenderer.findFaceMiddle(item.in().method_10153());
                        to = CENTER;
                        ratio = distance * 2.0;
                    } else {
                        from = CENTER;
                        to = PipeBlockEntityRenderer.findFaceMiddle(item.out());
                        ratio = (distance - 0.5) * 2.0;
                    }
                    matrices.method_22904(to.method_10216() * ratio + from.method_10216() * (1.0 - ratio), to.method_10214() * ratio + from.method_10214() * (1.0 - ratio), to.method_10215() * ratio + from.method_10215() * (1.0 - ratio));
                    matrices.method_22905(0.6f, 0.6f, 0.6f);
                    matrices.method_46416(0.0f, -0.15f, 0.0f);
                    int seed = item.variant().hashCode() + item.id;
                    this.random.setSeed(seed);
                    float rotAngle = (float)((double)((float)ClientTravelingItemSmoothing.getClientTick() + tickDelta) * item.speed() + (double)(this.random.nextFloat() * 2.0f) * Math.PI);
                    matrices.method_22907(class_7833.field_40716.rotation(rotAngle));
                    int renderCount = PipeBlockEntityRenderer.getRenderAmount(item.amount());
                    matrices.method_22904(0.0, 0.0, (double)(-(renderCount - 1)) * 0.1 / 2.0);
                    for (int r = 0; r < renderCount; ++r) {
                        matrices.method_22903();
                        matrices.method_22904((double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.02f), (double)((this.random.nextFloat() * 2.0f - 1.0f) * 0.02f), (double)r * 0.1);
                        class_310.method_1551().method_1480().method_23178(item.variant().toStack(), class_811.field_4318, light, overlay, matrices, vertexConsumers, pipe.method_10997(), 0);
                        matrices.method_22909();
                    }
                    matrices.method_22909();
                }
                continue;
            }
            if (!(host instanceof FluidHost)) continue;
            FluidHost fluidHost = (FluidHost)host;
            FluidPipeRendering.drawFluidInPipe(pipe, matrices, vertexConsumers, fluidHost.getVariant(), (float)fluidHost.getAmount() / 81000.0f);
        }
    }

    private static class_243 findFaceMiddle(class_2350 face) {
        return switch (face) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11033 -> new class_243(0.5, 0.0, 0.5);
            case class_2350.field_11036 -> new class_243(0.5, 1.0, 0.5);
            case class_2350.field_11043 -> new class_243(0.5, 0.5, 0.0);
            case class_2350.field_11035 -> new class_243(0.5, 0.5, 1.0);
            case class_2350.field_11039 -> new class_243(0.0, 0.5, 0.5);
            case class_2350.field_11034 -> new class_243(1.0, 0.5, 0.5);
        };
    }

    private static int getRenderAmount(long amount) {
        int i = 1;
        if (amount > 48L) {
            i = 5;
        } else if (amount > 32L) {
            i = 4;
        } else if (amount > 16L) {
            i = 3;
        } else if (amount > 1L) {
            i = 2;
        }
        return i;
    }
}

