/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy;

import com.mrh0.createaddition.energy.InternalEnergyStorage;
import com.mrh0.createaddition.transfer.EnergyTransferable;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public abstract class BaseElectricTileEntity
extends SmartBlockEntity
implements EnergyTransferable {
    protected final InternalEnergyStorage localEnergy;
    private boolean firstTickState = true;
    protected final long CAPACITY;
    protected final long MAX_IN;
    protected final long MAX_OUT;
    private EnergyStorage escacheUp = null;
    private EnergyStorage escacheDown = null;
    private EnergyStorage escacheNorth = null;
    private EnergyStorage escacheEast = null;
    private EnergyStorage escacheSouth = null;
    private EnergyStorage escacheWest = null;

    public BaseElectricTileEntity(class_2591<?> tileEntityTypeIn, class_2338 pos, class_2680 state, long CAPACITY, long MAX_IN, long MAX_OUT) {
        super(tileEntityTypeIn, pos, state);
        this.localEnergy = new InternalEnergyStorage(CAPACITY, MAX_IN, MAX_OUT);
        this.CAPACITY = CAPACITY;
        this.MAX_IN = MAX_IN;
        this.MAX_OUT = MAX_OUT;
        this.setLazyTickRate(20);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    @Override
    @Nullable
    public EnergyStorage getEnergyStorage(@Nullable class_2350 side) {
        if (this.isEnergyInput(side) || this.isEnergyOutput(side)) {
            return this.localEnergy;
        }
        return null;
    }

    public abstract boolean isEnergyInput(class_2350 var1);

    public abstract boolean isEnergyOutput(class_2350 var1);

    protected void read(class_2487 compound, boolean arg1) {
        super.read(compound, arg1);
        this.localEnergy.read(compound);
    }

    public void write(class_2487 compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        this.localEnergy.write(compound);
    }

    @Deprecated
    public void outputTick(int max) {
        for (class_2350 side : class_2350.values()) {
            if (!this.isEnergyOutput(side)) continue;
            this.localEnergy.outputToSide(this.field_11863, this.field_11867, side, max);
        }
    }

    public void tick() {
        super.tick();
        if (this.firstTickState) {
            this.firstTickState = false;
            this.firstTick();
        }
    }

    public void firstTick() {
        this.updateCache();
    }

    public boolean ignoreCapSide() {
        return false;
    }

    public void updateCache() {
        if (this.field_11863 != null && Objects.requireNonNull(this.field_11863).field_9236) {
            return;
        }
        for (class_2350 side : class_2350.values()) {
            this.updateCache(side);
        }
    }

    public void updateCache(class_2350 side) {
        if (!this.field_11863.method_8477(this.field_11867.method_10093(side))) {
            this.setCache(side, null);
            return;
        }
        EnergyStorage e = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, this.field_11867.method_10093(side), (Object)side.method_10153());
        if (e == null && this.ignoreCapSide()) {
            e = (EnergyStorage)EnergyStorage.SIDED.find(this.field_11863, this.field_11867.method_10093(side), null);
        }
        if (Objects.equals(e, this.getCachedEnergy(side))) {
            return;
        }
        this.setCache(side, e);
    }

    public void setCache(class_2350 side, EnergyStorage storage) {
        switch (side) {
            case field_11033: {
                this.escacheDown = storage;
                break;
            }
            case field_11034: {
                this.escacheEast = storage;
                break;
            }
            case field_11043: {
                this.escacheNorth = storage;
                break;
            }
            case field_11035: {
                this.escacheSouth = storage;
                break;
            }
            case field_11036: {
                this.escacheUp = storage;
                break;
            }
            case field_11039: {
                this.escacheWest = storage;
            }
        }
    }

    public EnergyStorage getCachedEnergy(class_2350 side) {
        switch (side) {
            case field_11033: {
                return this.escacheDown;
            }
            case field_11034: {
                return this.escacheEast;
            }
            case field_11043: {
                return this.escacheNorth;
            }
            case field_11035: {
                return this.escacheSouth;
            }
            case field_11036: {
                return this.escacheUp;
            }
            case field_11039: {
                return this.escacheWest;
            }
        }
        return null;
    }
}

