/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.energy.network;

import com.mrh0.createaddition.energy.IWireNode;
import com.mrh0.createaddition.energy.network.EnergyNetworkManager;
import java.util.Map;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

public class EnergyNetwork {
    private int id;
    private long inBuff = 0L;
    private long inDemand = 0L;
    private long outBuff = 0L;
    private long outBuffRetained = 0L;
    private long outDemand = 0L;
    private boolean valid = true;
    private int pulled = 0;
    private int pushed = 0;
    private static long MAX_BUFF = 80000L;

    public EnergyNetwork(class_1937 world) {
        EnergyNetworkManager.instances.get(world).add(this);
    }

    public void tick(int index) {
        this.id = index;
        long t = this.outBuff;
        this.outBuffRetained = this.outBuff = this.inBuff;
        this.inBuff = t;
        this.outDemand = this.inDemand;
        this.inDemand = 0L;
        this.pulled = 0;
        this.pushed = 0;
    }

    public long getBuff() {
        return this.outBuffRetained;
    }

    public long push(long energy) {
        energy = Math.min(MAX_BUFF - this.inBuff, energy);
        energy = Math.max(energy, 0L);
        this.inBuff += energy;
        this.pushed = (int)((long)this.pushed + energy);
        return energy;
    }

    public long demand(long demand) {
        this.inDemand += demand;
        return demand;
    }

    public long getDemand() {
        return this.outDemand;
    }

    public int getPulled() {
        return this.pulled;
    }

    public int getPushed() {
        return this.pushed;
    }

    public long pull(long max) {
        int r = (int)Math.max(Math.min(max, this.outBuff), 0L);
        this.outBuff -= (long)r;
        this.pulled += r;
        return r;
    }

    public static EnergyNetwork nextNode(class_1937 world, EnergyNetwork en, Map<String, IWireNode> visited, IWireNode current, int index) {
        if (visited.containsKey(EnergyNetwork.posKey(current.getPos(), index))) {
            return null;
        }
        current.setNetwork(index, en);
        visited.put(EnergyNetwork.posKey(current.getPos(), index), current);
        for (int i = 0; i < current.getNodeCount(); ++i) {
            IWireNode next = current.getWireNode(i);
            if (next == null || !current.isNodeIndicesConnected(index, i)) continue;
            EnergyNetwork.nextNode(world, en, visited, next, current.getOtherNodeIndex(i));
        }
        return en;
    }

    private static String posKey(class_2338 pos, int index) {
        return pos.method_10263() + "," + pos.method_10264() + "," + pos.method_10260() + ":" + index;
    }

    public void invalidate() {
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void removed() {
    }

    public int getId() {
        return this.id;
    }
}

