/*
 * Decompiled with CFR 0.152.
 */
package wily.betterfurnaces.blockentity;

import com.google.common.collect.Lists;
import dev.architectury.fluid.FluidStack;
import dev.architectury.platform.Platform;
import dev.architectury.registry.fuel.FuelRegistry;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1662;
import net.minecraft.class_1703;
import net.minecraft.class_1732;
import net.minecraft.class_1737;
import net.minecraft.class_1739;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3913;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import wily.betterfurnaces.BetterFurnacesPlatform;
import wily.betterfurnaces.Config;
import wily.betterfurnaces.ProjectMMO;
import wily.betterfurnaces.blockentity.FactoryUpgradeSettings;
import wily.betterfurnaces.blockentity.ForgeBlockEntity;
import wily.betterfurnaces.blockentity.InventoryBlockEntity;
import wily.betterfurnaces.blockentity.LRUCache;
import wily.betterfurnaces.blocks.SmeltingBlock;
import wily.betterfurnaces.init.Registration;
import wily.betterfurnaces.inventory.SlotFuel;
import wily.betterfurnaces.inventory.SlotInput;
import wily.betterfurnaces.inventory.SlotOutput;
import wily.betterfurnaces.inventory.SlotUpgrade;
import wily.betterfurnaces.inventory.SmeltingMenu;
import wily.betterfurnaces.items.FuelEfficiencyUpgradeItem;
import wily.betterfurnaces.items.GeneratorUpgradeItem;
import wily.betterfurnaces.items.OreProcessingUpgradeItem;
import wily.betterfurnaces.items.UpgradeItem;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.ItemContainerUtil;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.BlockSide;
import wily.factoryapi.base.FactoryItemSlot;
import wily.factoryapi.base.IPlatformEnergyStorage;
import wily.factoryapi.base.IPlatformFluidHandler;
import wily.factoryapi.base.IPlatformHandlerApi;
import wily.factoryapi.base.IPlatformItemHandler;
import wily.factoryapi.base.SlotsIdentifier;
import wily.factoryapi.base.Storages;
import wily.factoryapi.base.TransportState;

public class SmeltingBlockEntity
extends InventoryBlockEntity
implements class_1732,
class_1737 {
    public final int[] provides = new int[class_2350.values().length];
    private final int[] lastProvides = new int[this.provides.length];
    private Random rand = new Random();
    public int showInventorySettings;
    public boolean showOrientation;
    protected int timer;
    private int furnaceBurnTime;
    public int cookTime;
    public int totalCookTime = this.getCookTime();
    public final Supplier<Integer> defaultCookTime;
    private int recipesUsed;
    private final Object2IntOpenHashMap<class_2960> recipes = new Object2IntOpenHashMap();
    public class_3956<? extends class_1874> recipeType;
    public FactoryUpgradeSettings furnaceSettings;
    private final LRUCache<class_1792, Optional<class_1874>> cache = LRUCache.newInstance(Config.cacheCapacity.get());
    protected LRUCache<class_1792, Optional<class_1874>> blasting_cache = LRUCache.newInstance(Config.cacheCapacity.get());
    protected LRUCache<class_1792, Optional<class_1874>> smoking_cache = LRUCache.newInstance(Config.cacheCapacity.get());
    public final class_3913 fields = new class_3913(){

        public int method_17390(int index) {
            return switch (index) {
                case 0 -> SmeltingBlockEntity.this.furnaceBurnTime;
                case 1 -> SmeltingBlockEntity.this.recipesUsed;
                case 2 -> SmeltingBlockEntity.this.cookTime;
                case 3 -> SmeltingBlockEntity.this.totalCookTime;
                case 4 -> SmeltingBlockEntity.this.showInventorySettings;
                default -> 0;
            };
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    SmeltingBlockEntity.this.furnaceBurnTime = value;
                    break;
                }
                case 1: {
                    SmeltingBlockEntity.this.recipesUsed = value;
                    break;
                }
                case 2: {
                    SmeltingBlockEntity.this.cookTime = value;
                    break;
                }
                case 3: {
                    SmeltingBlockEntity.this.totalCookTime = value;
                    break;
                }
                case 4: {
                    SmeltingBlockEntity.this.showInventorySettings = value;
                }
            }
        }

        public int method_17389() {
            return 5;
        }
    };
    public final IPlatformFluidHandler<?> fluidTank = FactoryAPIPlatform.getFluidHandlerApi((long)this.LiquidCapacity(), (class_2586)this, fs -> SmeltingBlockEntity.getBurnTime(new class_1799((class_1935)fs.getFluid().method_15774())) > 0, (SlotsIdentifier)SlotsIdentifier.LAVA, (TransportState)TransportState.INSERT);
    public final IPlatformFluidHandler<?> xpTank = FactoryAPIPlatform.getFluidHandlerApi((long)(2L * FluidStack.bucketAmount()), (class_2586)this, xp -> xp.getFluid().method_15780(Config.getLiquidXP()), (SlotsIdentifier)SlotsIdentifier.GENERIC, (TransportState)TransportState.EXTRACT);
    public final IPlatformEnergyStorage<?> energyStorage = FactoryAPIPlatform.getEnergyStorageApi((int)this.EnergyCapacity(), (class_2586)this);
    class_6862<class_1792> ore = this.getItemTag(new class_2960(Platform.isForge() ? "forge" : "c", "ores"));

    public int[] FUEL() {
        int[] inputs = new int[]{1};
        if (this.hasUpgradeType((UpgradeItem)((Object)Registration.STORAGE.get()))) {
            inputs = new int[]{1, 7};
        }
        return inputs;
    }

    public int HEATER() {
        return this.FUEL()[0];
    }

    public int[] UPGRADES() {
        return new int[]{3, 4, 5};
    }

    public int FINPUT() {
        return this.INPUTS()[0];
    }

    public int LINPUT() {
        return this.INPUTS()[this.INPUTS().length - 1];
    }

    public int FOUTPUT() {
        return this.OUTPUTS()[0];
    }

    public int LOUTPUT() {
        return this.OUTPUTS()[this.OUTPUTS().length - 1];
    }

    public int[] INPUTS() {
        int[] inputs = new int[]{0};
        if (this.hasUpgradeType((UpgradeItem)((Object)Registration.STORAGE.get()))) {
            inputs = new int[]{0, 6};
        }
        return inputs;
    }

    public int[] OUTPUTS() {
        int[] outputs = new int[]{2};
        if (this.hasUpgradeType((UpgradeItem)((Object)Registration.STORAGE.get()))) {
            outputs = new int[]{2, 8};
        }
        return outputs;
    }

    public int[] FSLOTS() {
        return ArrayUtils.addAll((int[])this.ISLOTS(), (int[])this.OUTPUTS());
    }

    public int[] ISLOTS() {
        return ArrayUtils.addAll((int[])this.INPUTS(), (int[])this.FUEL());
    }

    public int EnergyUse() {
        return 500;
    }

    public long LiquidCapacity() {
        return 4L * FluidStack.bucketAmount();
    }

    public int EnergyCapacity() {
        return 16000;
    }

    public boolean isForge() {
        return this instanceof ForgeBlockEntity;
    }

    public SmeltingBlockEntity(class_2338 pos, class_2680 state, Supplier<Integer> cookTime) {
        super((class_2591)Registration.BLOCK_ENTITIES.getRegistrar().get(state.method_26204().arch$registryName()), pos, state);
        this.defaultCookTime = cookTime;
        this.recipeType = class_3956.field_17546;
        this.furnaceSettings = new FactoryUpgradeSettings(() -> this.getUpgradeTypeSlotItem((UpgradeItem)((Object)((Object)Registration.FACTORY.get())))){

            @Override
            public void onChanged() {
                if (SmeltingBlockEntity.this.hasUpgradeType((UpgradeItem)((Object)Registration.FACTORY.get()))) {
                    SmeltingBlockEntity.this.inventory.method_5447(SmeltingBlockEntity.this.getUpgradeTypeSlot((UpgradeItem)((Object)Registration.FACTORY.get())), (class_1799)this.factory.get());
                }
                SmeltingBlockEntity.this.method_5431();
            }
        };
    }

    private int getFromCache(LRUCache<class_1792, Optional<class_1874>> c, class_1792 key) {
        if (c == null) {
            return 0;
        }
        if (c.get(key) == null) {
            return 0;
        }
        return ((Optional)c.get(key)).orElse(null) == null ? 0 : ((class_1874)((Optional)c.get(key)).orElse(null)).method_8167();
    }

    public boolean hasRecipe(class_1799 stack) {
        return this.grabRecipe(stack).isPresent();
    }

    protected LRUCache<class_1792, Optional<class_1874>> getCache() {
        LRUCache[] caches = new LRUCache[]{this.cache, this.blasting_cache, this.smoking_cache};
        return caches[this.getUpdatedType() >= 3 ? 0 : this.getUpdatedType()];
    }

    private Optional<class_1874> getRecipe(class_1799 stack, class_3956 recipeType) {
        return this.field_11863.method_8433().method_8132(recipeType, (class_1263)new class_1277(new class_1799[]{stack}), this.field_11863);
    }

    private Optional<class_1874> grabRecipe(class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1739) {
            return Optional.empty();
        }
        Optional<class_1874> recipe = (Optional<class_1874>)this.getCache().get(item);
        if (recipe == null) {
            recipe = this.getRecipe(stack, this.recipeType);
            this.getCache().put(item, recipe);
        }
        return recipe;
    }

    public boolean hasXPTank() {
        return this.hasUpgrade((UpgradeItem)((Object)Registration.XP.get()));
    }

    public boolean hasEnder() {
        return this.hasUpgradeType((UpgradeItem)((Object)Registration.FUEL.get()));
    }

    public int getEnderMultiplier() {
        if (this.hasEnder()) {
            return ((FuelEfficiencyUpgradeItem)this.getUpgradeTypeSlotItem((UpgradeItem)((UpgradeItem)((Object)Registration.FUEL.get()))).method_7909()).getMultiplier;
        }
        return 1;
    }

    public boolean isLiquid() {
        return this.hasUpgrade((UpgradeItem)((Object)Registration.LIQUID.get()));
    }

    private boolean isEnergy() {
        return this.hasUpgrade((UpgradeItem)((Object)Registration.ENERGY.get())) && this.energyStorage.getEnergyStored() >= this.EnergyUse();
    }

    public int getCookTime() {
        if (this.hasUpgrade((UpgradeItem)((Object)Registration.GENERATOR.get())) || this.arraySlotAllEmpty(this.INPUTS())) {
            return Optional.ofNullable(this.defaultCookTime).orElse(() -> this.totalCookTime).get();
        }
        int speed = this.getSpeed();
        if (speed == -1) {
            return -1;
        }
        return Math.max(1, speed);
    }

    protected int getSpeed() {
        int j = 0;
        int length = this.INPUTS().length;
        for (int i : this.INPUTS()) {
            int iC;
            class_1799 stack = this.inventory.method_5438(i);
            int cache = this.getFromCache(this.getCache(), stack.method_7909());
            int n = iC = cache <= 0 ? this.grabRecipe(stack).map(class_1874::method_8167).orElse(-1) : cache;
            if (iC <= 0) {
                --length;
                continue;
            }
            j += iC;
        }
        int n = j = length <= 0 ? 0 : j / length;
        if (j < this.defaultCookTime.get()) {
            return (int)((float)j * ((float)this.defaultCookTime.get().intValue() / 200.0f));
        }
        return this.defaultCookTime.get();
    }

    public List<UpgradeItem> getUpgrades() {
        ArrayList<UpgradeItem> list = new ArrayList<UpgradeItem>();
        for (int slot : this.UPGRADES()) {
            class_1792 class_17922 = this.inventory.method_5438(slot).method_7909();
            if (!(class_17922 instanceof UpgradeItem)) continue;
            UpgradeItem upg = (UpgradeItem)class_17922;
            list.add(upg);
        }
        return list;
    }

    public boolean hasUpgrade(UpgradeItem upg) {
        for (int slot : this.UPGRADES()) {
            if (!((Object)((Object)upg)).equals(this.inventory.method_5438(slot).method_7909()) || !upg.isEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean hasUpgradeType(UpgradeItem upg) {
        return this.getUpgradeTypeSlot(upg) >= 0;
    }

    public class_1799 getUpgradeTypeSlotItem(UpgradeItem upg) {
        int i = this.getUpgradeTypeSlot(upg);
        return i < 0 ? class_1799.field_8037 : this.inventory.method_5438(i);
    }

    public int getUpgradeTypeSlot(UpgradeItem upg) {
        for (int slot : this.UPGRADES()) {
            UpgradeItem upgradeItem;
            class_1792 class_17922 = this.inventory.method_5438(slot).method_7909();
            if (!(class_17922 instanceof UpgradeItem) || !(upgradeItem = (UpgradeItem)class_17922).isEnabled() || !upg.isSameType(upgradeItem)) continue;
            return slot;
        }
        return -1;
    }

    public class_1799 getUpgradeSlotItem(class_1792 upg) {
        for (int slot : this.UPGRADES()) {
            if (upg != this.inventory.method_5438(slot).method_7909()) continue;
            return this.inventory.method_5438(slot);
        }
        return class_1799.field_8037;
    }

    public static int getFluidBurnTime(FluidStack stack) {
        return stack == null ? 0 : FuelRegistry.get((class_1799)stack.getFluid().method_15774().method_7854());
    }

    public void forceUpdateAllStates() {
        class_2680 state = this.field_11863.method_8320(this.field_11867);
        if (((Boolean)state.method_11654((class_2769)class_2741.field_12548)).booleanValue() != this.isBurning()) {
            this.field_11863.method_8652(this.field_11867, (class_2680)state.method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(this.isBurning())), 3);
        }
    }

    public int correspondentOutputSlot(int input) {
        return this.hasUpgradeType((UpgradeItem)((Object)Registration.STORAGE.get())) ? Arrays.stream(this.OUTPUTS()).filter(i -> this.canSmelt(this.irecipeSlot(input).orElse(null), input, i)).min().orElse(-1) : this.FOUTPUT() - this.FINPUT() + input;
    }

    public void trySmelt() {
        if (this.hasUpgradeType((UpgradeItem)((Object)Registration.STORAGE.get()))) {
            int i = this.correspondentOutputSlot(this.FINPUT());
            if (i >= 0) {
                this.smeltItem(this.irecipeSlot(this.FINPUT()).orElse(null), this.FINPUT(), i);
            }
        } else {
            for (int i : this.INPUTS()) {
                if (!this.canSmelt(this.irecipeSlot(i).orElse(null), i, this.correspondentOutputSlot(i))) continue;
                this.smeltItem(this.irecipeSlot(i).orElse(null), i, this.correspondentOutputSlot(i));
            }
        }
    }

    public int getUpdatedType() {
        return this.hasUpgrade((UpgradeItem)((Object)Registration.BLAST.get())) ? 1 : (this.hasUpgrade((UpgradeItem)((Object)Registration.SMOKE.get())) ? 2 : (this.hasUpgrade((UpgradeItem)((Object)Registration.GENERATOR.get())) ? 3 : 0));
    }

    @Override
    public class_2561 method_5476() {
        String tier = this.method_11010().method_26204().arch$registryName().method_12832().split("_")[0];
        return this.getUpdatedType() != 0 ? class_2561.method_43469((String)("tooltip.betterfurnacesreforged." + tier + "_tier"), (Object[])new Object[]{this.getUpdatedType() == 1 ? class_2246.field_16333.method_9518().getString() : (this.getUpdatedType() == 2 ? class_2246.field_16334.method_9518().getString() : (this.getUpdatedType() == 3 ? class_2561.method_43471((String)"tooltip.betterfurnacesreforged.generator").getString() : ""))}) : super.method_5476();
    }

    public Optional<class_1874> irecipeSlot(int input) {
        if (!ArrayUtils.contains((int[])this.INPUTS(), (int)input)) {
            return Optional.empty();
        }
        if (!this.inventory.method_5438(input).method_7960()) {
            return this.grabRecipe(this.inventory.method_5438(input));
        }
        return Optional.empty();
    }

    public boolean hasArraySlotSpace(int[] slots) {
        for (int i : slots) {
            boolean noFull;
            boolean bl = noFull = this.inventory.method_5438(i).method_7947() < this.inventory.method_5438(i).method_7914() && !this.inventory.method_5438(i).method_7960();
            if (noFull) continue;
            return true;
        }
        return false;
    }

    public boolean arraySlotFilled(int[] slots, boolean isFilled) {
        for (int i : slots) {
            boolean filled = this.inventory.method_5438(i).method_7960();
            if (!isFilled) {
                boolean bl = filled = !filled;
            }
            if (filled) continue;
            return true;
        }
        return false;
    }

    public boolean arraySlotAllEmpty(int[] slots) {
        for (int i : slots) {
            boolean empty = this.inventory.method_5438(i).method_7960();
            if (empty) continue;
            return false;
        }
        return true;
    }

    public boolean canGeneratorWork() {
        if (this.hasUpgrade((UpgradeItem)((Object)Registration.GENERATOR.get()))) {
            class_1799 stack = this.getUpgradeSlotItem((class_1792)Registration.GENERATOR.get());
            return ItemContainerUtil.isFluidContainer((class_1799)stack) && ItemContainerUtil.getFluid((class_1799)stack).getAmount() > 0L && this.energyStorage.getSpace() > 0;
        }
        return false;
    }

    public boolean smeltValid() {
        if (!this.hasUpgrade((UpgradeItem)((Object)Registration.GENERATOR.get()))) {
            for (int i : this.INPUTS()) {
                if (!this.canSmelt(this.irecipeSlot(i).orElse(null), i, this.correspondentOutputSlot(i))) continue;
                return true;
            }
        }
        return false;
    }

    public static void tick(class_1937 level, class_2338 worldPosition, class_2680 blockState, SmeltingBlockEntity e) {
        boolean wasBurning = e.isBurning();
        boolean flag1 = false;
        boolean flag2 = false;
        if (e.isBurning()) {
            --e.furnaceBurnTime;
        }
        if (e.hasXPTank()) {
            e.grantStoredRecipeExperience(level, null);
        }
        if (!e.hasUpgradeType((UpgradeItem)((Object)Registration.FACTORY.get())) && e.showOrientation) {
            e.showOrientation = false;
        }
        class_1799 fuel = e.inventory.method_5438(e.FUEL()[0]);
        if (e.hasUpgrade((UpgradeItem)((Object)Registration.COLOR.get()))) {
            if (!((Boolean)level.method_8320(e.method_11016()).method_11654((class_2769)SmeltingBlock.COLORED)).booleanValue()) {
                level.method_8652(e.method_11016(), (class_2680)level.method_8320(e.method_11016()).method_11657((class_2769)SmeltingBlock.COLORED, (Comparable)Boolean.valueOf(true)), 3);
            }
        } else if (((Boolean)level.method_8320(e.method_11016()).method_11654((class_2769)SmeltingBlock.COLORED)).booleanValue()) {
            level.method_8652(e.method_11016(), (class_2680)level.method_8320(e.method_11016()).method_11657((class_2769)SmeltingBlock.COLORED, (Comparable)Boolean.valueOf(false)), 3);
        }
        int updatedType = e.getUpdatedType();
        class_3956[] recipeTypes = new class_3956[]{class_3956.field_17546, class_3956.field_17547, class_3956.field_17548};
        if (updatedType == 3) {
            for (int i : new int[]{e.FINPUT(), e.FOUTPUT()}) {
                class_1799 stack = e.inventory.method_5438(i);
                if (stack.method_7960()) continue;
                class_1264.method_5449((class_1937)level, (double)e.method_11016().method_10263(), (double)(e.method_11016().method_10264() + 1), (double)e.method_11016().method_10260(), (class_1799)stack);
            }
        } else if (e.recipeType != recipeTypes[updatedType]) {
            e.recipeType = recipeTypes[updatedType];
        }
        if (!e.isForge() && (Integer)level.method_8320(e.method_11016()).method_11654((class_2769)SmeltingBlock.TYPE) != updatedType) {
            level.method_8652(e.method_11016(), (class_2680)level.method_8320(e.method_11016()).method_11657((class_2769)SmeltingBlock.TYPE, (Comparable)Integer.valueOf(updatedType)), 3);
        }
        if (!level.field_9236) {
            ItemContainerUtil.ItemFluidContext context;
            long amount;
            int mode;
            int get_cook_time = e.getCookTime();
            ++e.timer;
            if (e.hasUpgrade((UpgradeItem)((Object)Registration.GENERATOR.get()))) {
                BetterFurnacesPlatform.transferEnergySides(e);
            }
            if (e.hasUpgradeType((UpgradeItem)((Object)Registration.STORAGE.get()))) {
                int added;
                class_1799 storageFuel;
                int added2;
                class_1799 storageInput = e.inventory.method_5438(6);
                if (!storageInput.method_7960() && (added2 = e.addOrSetItem(storageInput, (class_1263)e.inventory, e.FINPUT())) > 0) {
                    e.inventory.extractItem(6, added2, false);
                }
                if (!(storageFuel = e.inventory.method_5438(7)).method_7960() && (added = e.addOrSetItem(storageFuel, (class_1263)e.inventory, e.FUEL()[0])) > 0) {
                    e.inventory.extractItem(7, added, false);
                }
            } else if (!e.isForge()) {
                for (int i : new int[]{6, 7, 8}) {
                    class_1799 stack = e.inventory.method_5438(i);
                    if (stack.method_7960()) continue;
                    class_1264.method_5449((class_1937)level, (double)e.method_11016().method_10263(), (double)(e.method_11016().method_10264() + 1), (double)e.method_11016().method_10260(), (class_1799)stack);
                }
            }
            if (e.hasUpgrade((UpgradeItem)((Object)Registration.ENERGY.get())) && ItemContainerUtil.isEnergyContainer((class_1799)fuel) && ItemContainerUtil.getEnergy((class_1799)fuel) > 0 && e.energyStorage.getSpace() > 0) {
                e.energyStorage.receiveEnergy(ItemContainerUtil.extractEnergy((int)e.energyStorage.getSpace(), (class_1799)fuel).contextEnergy(), false);
                e.inventory.method_5447(e.FUEL()[0], fuel);
            }
            if (e.totalCookTime != get_cook_time) {
                e.totalCookTime = get_cook_time;
            }
            if ((mode = e.getRedstoneSetting()) != 0) {
                if (mode == 2) {
                    int i = 0;
                    for (class_2350 side : class_2350.values()) {
                        if (level.method_49808(worldPosition.method_10081(side.method_10163()), side) <= 0) continue;
                        ++i;
                    }
                    if (i != 0) {
                        e.cookTime = 0;
                        e.furnaceBurnTime = 0;
                        e.forceUpdateAllStates();
                        return;
                    }
                }
                if (mode == 1) {
                    boolean flag = false;
                    for (class_2350 side : class_2350.values()) {
                        if (level.method_49808(worldPosition.method_10081(side.method_10163()), side) <= 0) continue;
                        flag = true;
                    }
                    if (!flag) {
                        e.cookTime = 0;
                        e.furnaceBurnTime = 0;
                        e.forceUpdateAllStates();
                        return;
                    }
                }
                for (i = 0; i < class_2350.values().length; ++i) {
                    e.provides[i] = e.method_11010().method_26203((class_1922)e.field_11863, worldPosition, class_2350.values()[i]);
                }
            } else {
                for (i = 0; i < class_2350.values().length; ++i) {
                    e.provides[i] = 0;
                }
            }
            if (e.doesNeedUpdateSend()) {
                e.onUpdateSent();
            }
            if (e.isLiquid() && ItemContainerUtil.isFluidContainer((class_1799)fuel) && SmeltingBlockEntity.isItemFuel(ItemContainerUtil.getFluid((class_1799)fuel).getFluid().method_15774().method_7854()) && (amount = e.fluidTank.fill((context = ItemContainerUtil.drainItem((long)e.fluidTank.getTotalSpace(), (class_1799)fuel)).fluidStack(), false)) > 0L) {
                level.method_43128(null, (double)worldPosition.method_10263(), (double)worldPosition.method_10264(), (double)worldPosition.method_10260(), class_3417.field_15202, class_3419.field_15248, 0.6f, 0.8f);
                e.inventory.method_5447(e.FUEL()[0], context.container());
            }
            if ((e.isBurning() || !fuel.method_7960() || e.isLiquid() || e.isEnergy() && !e.canGeneratorWork()) && (e.arraySlotFilled(e.INPUTS(), true) || e.canGeneratorWork())) {
                boolean valid;
                boolean bl = valid = e.smeltValid() || e.canGeneratorWork();
                if (!e.isBurning() && valid) {
                    if (e.isLiquid() && !e.fluidTank.getFluidStack().isEmpty() && SmeltingBlockEntity.getFluidBurnTime(e.fluidTank.getFluidStack()) > 0) {
                        int fluidAmount = 200 * (int)FluidStack.bucketAmount() / SmeltingBlockEntity.getFluidBurnTime(e.fluidTank.getFluidStack());
                        if (e.fluidTank.getFluidStack().getAmount() >= (long)fluidAmount) {
                            e.recipesUsed = e.furnaceBurnTime = e.getEnderMultiplier() * get_cook_time;
                            e.fluidTank.drain((long)fluidAmount, false);
                        }
                    } else if (e.isEnergy()) {
                        e.recipesUsed = e.furnaceBurnTime = e.getEnderMultiplier() * get_cook_time;
                        for (int a : e.INPUTS()) {
                            e.energyStorage.consumeEnergy(e.EnergyUse() * e.OreProcessingMultiplier(e.inventory.method_5438(a)), false);
                        }
                    } else {
                        e.recipesUsed = e.furnaceBurnTime = e.getEnderMultiplier() * SmeltingBlockEntity.getBurnTime(fuel) * get_cook_time / 200;
                    }
                    if (e.isBurning()) {
                        flag1 = true;
                        if (e.hasEnder() && e.hasUpgrade((UpgradeItem)((Object)Registration.FUEL.get()))) {
                            e.breakDurabilityItem(e.getUpgradeSlotItem((class_1792)Registration.FUEL.get()));
                        }
                        if (!(e.isLiquid() && e.fluidTank.getFluidStack().getAmount() >= 10L || e.isEnergy())) {
                            if (ItemContainerUtil.isFluidContainer((class_1799)fuel)) {
                                ItemContainerUtil.ItemFluidContext context2 = ItemContainerUtil.drainItem((long)e.fluidTank.getTotalSpace(), (class_1799)fuel);
                                e.inventory.method_5447(e.FUEL()[0], context2.container());
                            }
                            if (!fuel.method_7960() && SmeltingBlockEntity.isItemFuel(fuel)) {
                                fuel.method_7934(1);
                                if (e.hasUpgrade((UpgradeItem)((Object)Registration.FUEL.get()))) {
                                    e.breakDurabilityItem(e.getUpgradeSlotItem((class_1792)Registration.FUEL.get()));
                                }
                            }
                        }
                    }
                }
                if (e.isBurning() && valid) {
                    ++e.cookTime;
                    if (e.hasUpgrade((UpgradeItem)((Object)Registration.GENERATOR.get()))) {
                        ItemContainerUtil.ItemFluidContext context3 = ItemContainerUtil.drainItem((long)(FluidStack.bucketAmount() / 1000L), (class_1799)e.getUpgradeSlotItem((class_1792)Registration.GENERATOR.get()));
                        if (!context3.fluidStack().isEmpty()) {
                            e.inventory.method_5447(e.getUpgradeTypeSlot((UpgradeItem)((Object)Registration.GENERATOR.get())), context3.container());
                        }
                        e.energyStorage.receiveEnergy(Math.round(500.0f / (float)get_cook_time), false);
                    }
                    if (e.cookTime >= e.totalCookTime) {
                        e.cookTime = 0;
                        e.totalCookTime = e.getCookTime();
                        if (!e.hasUpgrade((UpgradeItem)((Object)Registration.GENERATOR.get()))) {
                            e.trySmelt();
                            if (e.hasUpgradeType((UpgradeItem)((Object)Registration.FACTORY.get()))) {
                                BetterFurnacesPlatform.smeltingAutoIO(e);
                            }
                        }
                        flag1 = true;
                    }
                } else {
                    e.cookTime = 0;
                }
            } else if (!e.isBurning() && e.cookTime > 0) {
                e.cookTime = class_3532.method_15340((int)(e.cookTime - 2), (int)0, (int)e.totalCookTime);
            }
            if (wasBurning != e.isBurning()) {
                flag1 = true;
                e.field_11863.method_8652(e.field_11867, (class_2680)e.field_11863.method_8320(e.field_11867).method_11657((class_2769)class_2741.field_12548, (Comparable)Boolean.valueOf(e.isBurning())), 3);
            }
            if (e.timer % 24 == 0 && e.hasUpgradeType((UpgradeItem)((Object)Registration.FACTORY.get())) && e.cookTime <= 0) {
                if (e.arraySlotFilled(e.INPUTS(), false)) {
                    BetterFurnacesPlatform.smeltingAutoIO(e);
                    flag1 = true;
                } else if (e.hasArraySlotSpace(e.INPUTS())) {
                    BetterFurnacesPlatform.smeltingAutoIO(e);
                    flag1 = true;
                }
                if (e.arraySlotFilled(e.OUTPUTS(), true)) {
                    BetterFurnacesPlatform.smeltingAutoIO(e);
                    flag1 = true;
                }
                if (e.inventory.method_5438(e.FUEL()[0]).method_7960() && !e.isLiquid() && !e.isEnergy()) {
                    BetterFurnacesPlatform.smeltingAutoIO(e);
                    flag1 = true;
                } else if (e.inventory.method_5438(e.FUEL()[0]).method_7947() < e.inventory.method_5438(e.FUEL()[0]).method_7914() || ItemContainerUtil.isFluidContainer((class_1799)fuel) && ItemContainerUtil.getFluid((class_1799)fuel).getAmount() < e.fluidTank.getTotalSpace()) {
                    BetterFurnacesPlatform.smeltingAutoIO(e);
                    flag1 = true;
                }
            }
        }
        if (flag1) {
            e.method_5431();
        }
    }

    public Color getColor() {
        if (this.getUpgradeSlotItem((class_1792)Registration.COLOR.get()).method_7960()) {
            return Color.WHITE;
        }
        class_2487 nbt = this.getUpgradeSlotItem((class_1792)Registration.COLOR.get()).method_7969();
        return new Color(nbt.method_10550("red"), nbt.method_10550("green"), nbt.method_10550("blue"));
    }

    public int getSettingBottom() {
        return this.furnaceSettings.get(this.getIndexBottom());
    }

    public int getSettingTop() {
        return this.furnaceSettings.get(this.getIndexTop());
    }

    public int getSettingFront() {
        return this.furnaceSettings.get(this.getIndexFront());
    }

    public int getSettingBack() {
        return this.furnaceSettings.get(this.getIndexBack());
    }

    public int getSettingLeft() {
        return this.furnaceSettings.get(this.getIndexLeft());
    }

    public int getSettingRight() {
        return this.furnaceSettings.get(this.getIndexRight());
    }

    protected BlockSide[] getSidesOrder() {
        return BlockSide.values();
    }

    public int getIndexBottom() {
        return BlockSide.BOTTOM.blockStateToFacing(this.method_11010(), this.getSidesOrder()).ordinal();
    }

    public int getIndexTop() {
        return BlockSide.TOP.blockStateToFacing(this.method_11010(), this.getSidesOrder()).ordinal();
    }

    public int getIndexFront() {
        return BlockSide.FRONT.blockStateToFacing(this.method_11010(), this.getSidesOrder()).ordinal();
    }

    public int getIndexBack() {
        return BlockSide.BACK.blockStateToFacing(this.method_11010(), this.getSidesOrder()).ordinal();
    }

    public int getIndexLeft() {
        return BlockSide.LEFT.blockStateToFacing(this.method_11010(), this.getSidesOrder()).ordinal();
    }

    public int getIndexRight() {
        return BlockSide.RIGHT.blockStateToFacing(this.method_11010(), this.getSidesOrder()).ordinal();
    }

    public int getAutoInput() {
        return this.furnaceSettings.get(6);
    }

    public int getAutoOutput() {
        return this.furnaceSettings.get(7);
    }

    public int getRedstoneSetting() {
        return this.furnaceSettings.get(8);
    }

    public int getRedstoneComSub() {
        return this.furnaceSettings.get(9);
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private class_6862<class_1792> getItemTag(class_2960 resourceLocation) {
        return class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)resourceLocation);
    }

    private boolean hasRawOreTag(class_1799 stack) {
        if (Config.checkRawOresName.get().booleanValue()) {
            return stack.method_7909().arch$registryName().method_12832().startsWith("raw_");
        }
        if (Platform.isForge()) {
            return stack.method_31573(this.getItemTag(new class_2960("forge", "raw_materials")));
        }
        if (stack.method_31573(this.getItemTag(new class_2960("c", "raw_materials")))) {
            return true;
        }
        for (class_6862 tag : stack.method_40133().toList()) {
            if (!tag.comp_327().toString().contains("raw_") || !tag.comp_327().toString().contains("_ores")) continue;
            return true;
        }
        return false;
    }

    protected boolean isOre(class_1799 input) {
        if (Config.checkCommonOresName.get().booleanValue()) {
            return input.method_7909().arch$registryName().method_12832().endsWith("_ore");
        }
        return input.method_31573(this.ore);
    }

    protected boolean isRaw(class_1799 input) {
        return this.hasRawOreTag(input);
    }

    protected int OreProcessingMultiplier(class_1799 input) {
        if (this.hasUpgradeType((UpgradeItem)((Object)Registration.ORE_PROCESSING.get()))) {
            OreProcessingUpgradeItem oreup = (OreProcessingUpgradeItem)this.getUpgradeTypeSlotItem((UpgradeItem)((Object)Registration.ORE_PROCESSING.get())).method_7909();
            if (this.isRaw(input) && oreup.acceptRaw || this.isOre(input) && oreup.acceptOre) {
                return oreup.getMultiplier;
            }
        } else if (input.method_7960()) {
            return 0;
        }
        return 1;
    }

    public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
        return new SmeltingMenu((class_3917)Registration.FURNACE_CONTAINER.get(), i, this.field_11863, this.method_11016(), playerInventory, playerEntity, this.fields);
    }

    protected boolean canSmelt(@Nullable class_1860<?> recipe, int INPUT, int OUTPUT) {
        class_1799 recipeOutput;
        class_1799 input = this.getInv().method_5438(INPUT);
        if (OUTPUT >= 0 && !input.method_7960() && recipe != null && !(recipeOutput = recipe.method_8110((class_5455)class_5455.field_40585)).method_7960()) {
            class_1799 output = this.getInv().method_5438(OUTPUT);
            if (output.method_7960()) {
                return true;
            }
            if (!class_1799.method_31577((class_1799)output, (class_1799)recipeOutput)) {
                return false;
            }
            return output.method_7947() + recipeOutput.method_7947() * this.OreProcessingMultiplier(input) <= output.method_7914();
        }
        return false;
    }

    private class_1799 getResult(@Nullable class_1860<?> recipe, class_1799 input) {
        class_1799 out = recipe.method_8110((class_5455)class_5455.field_40585).method_7972();
        out.method_7939(out.method_7947() * this.OreProcessingMultiplier(input));
        return out;
    }

    protected int addOrSetItem(class_1799 stack, class_1263 inv, int index) {
        class_1799 slotStack = inv.method_5438(index);
        if (slotStack.method_7960()) {
            inv.method_5447(index, stack.method_7972());
            return Math.min(inv.method_5444(), stack.method_7947());
        }
        int resultCount = slotStack.method_7947() + stack.method_7947();
        int maxStack = Math.min(inv.method_5444(), slotStack.method_7914());
        if (slotStack.method_31574(stack.method_7909()) && slotStack.method_7947() < maxStack) {
            if (resultCount <= maxStack) {
                slotStack.method_7933(Math.max(stack.method_7947(), 1));
                return Math.max(stack.method_7947(), 1);
            }
            int count = maxStack - slotStack.method_7947();
            slotStack.method_7939(maxStack);
            return count;
        }
        return 0;
    }

    protected void smeltItem(@Nullable class_1860<?> recipe, int INPUT, int OUTPUT) {
        this.timer = 0;
        if (recipe != null && this.canSmelt(recipe, INPUT, OUTPUT)) {
            class_1799 input = this.getInv().method_5438(INPUT);
            if (this.addOrSetItem(this.getResult(recipe, input), (class_1263)this.inventory, OUTPUT) > 0 && this.hasUpgrade((UpgradeItem)((Object)Registration.ORE_PROCESSING.get())) && this.isOre(input)) {
                this.breakDurabilityItem(this.getUpgradeSlotItem((class_1792)Registration.ORE_PROCESSING.get()));
            }
            this.checkXP(recipe);
            if (!this.field_11863.field_9236) {
                this.method_7662(recipe);
            }
            class_1799 fuel = this.inventory.method_5438(this.FUEL()[0]);
            if (input.method_7909() == class_2246.field_10562.method_8389() && !fuel.method_7960() && ItemContainerUtil.isFluidContainer((class_1799)fuel)) {
                ItemContainerUtil.fillItem((class_1799)fuel, (FluidStack)FluidStack.create((class_3611)class_3612.field_15910, (long)1000L));
                this.inventory.method_5447(this.FUEL()[0], fuel);
            }
            if (Platform.isModLoaded((String)"pmmo")) {
                ProjectMMO.burnEvent(input, this.field_11863, this.field_11867);
            }
            input.method_7934(1);
        }
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.furnaceBurnTime = tag.method_10550("BurnTime");
        this.cookTime = tag.method_10550("CookTime");
        this.totalCookTime = tag.method_10550("CookTimeTotal");
        this.timer = 0;
        this.recipesUsed = SmeltingBlockEntity.getBurnTime(this.getInv().method_5438(1));
        this.fluidTank.deserializeTag((class_2520)tag.method_10562("fluidTank"));
        this.xpTank.deserializeTag((class_2520)tag.method_10562("xpTank"));
        class_2487 compoundnbt = tag.method_10562("RecipesUsed");
        this.energyStorage.deserializeTag((class_2520)tag.method_10562("energy"));
        for (String s : compoundnbt.method_10541()) {
            this.recipes.put((Object)new class_2960(s), compoundnbt.method_10550(s));
        }
        this.showInventorySettings = tag.method_10550("ShowInvSettings");
        this.showOrientation = tag.method_10577("ShowOrientation");
    }

    @Override
    public void method_11007(class_2487 tag) {
        tag.method_10569("BurnTime", this.furnaceBurnTime);
        tag.method_10569("CookTime", this.cookTime);
        tag.method_10569("CookTimeTotal", this.totalCookTime);
        tag.method_10566("fluidTank", this.fluidTank.serializeTag());
        tag.method_10566("xpTank", this.xpTank.serializeTag());
        tag.method_10566("energy", this.energyStorage.serializeTag());
        tag.method_10569("ShowInvSettings", this.showInventorySettings);
        tag.method_10556("ShowOrientation", this.showOrientation);
        class_2487 compoundnbt = new class_2487();
        this.recipes.forEach((recipeId, craftedAmount) -> compoundnbt.method_10569(recipeId.toString(), craftedAmount.intValue()));
        tag.method_10566("RecipesUsed", (class_2520)compoundnbt);
        super.method_11007(tag);
    }

    protected static int getBurnTime(class_1799 stack) {
        if (stack.method_7960()) {
            return 0;
        }
        return FuelRegistry.get((class_1799)stack);
    }

    public static boolean isItemFuel(class_1799 stack) {
        return SmeltingBlockEntity.getBurnTime(stack) > 0;
    }

    public <T extends IPlatformHandlerApi<?>> ArbitrarySupplier<T> getStorage(Storages.Storage<T> storage, class_2350 facing) {
        if (storage == Storages.FLUID) {
            if (facing == null || !this.hasUpgrade((UpgradeItem)((Object)Registration.GENERATOR.get())) && !this.hasXPTank() || facing.ordinal() == this.getIndexTop() || facing.ordinal() == this.getIndexBottom()) {
                if (this.isLiquid()) {
                    return () -> this.fluidTank;
                }
            } else {
                if (this.hasUpgrade((UpgradeItem)((Object)Registration.GENERATOR.get()))) {
                    class_1799 gen = this.getUpgradeSlotItem((class_1792)Registration.GENERATOR.get());
                    return () -> {
                        IPlatformFluidHandler iPlatformFluidHandler;
                        class_1792 patt37574$temp = gen.method_7909();
                        if (patt37574$temp instanceof GeneratorUpgradeItem) {
                            GeneratorUpgradeItem item = (GeneratorUpgradeItem)patt37574$temp;
                            iPlatformFluidHandler = item.getFluidStorage(gen);
                        } else {
                            iPlatformFluidHandler = null;
                        }
                        return iPlatformFluidHandler;
                    };
                }
                if (this.hasXPTank()) {
                    return () -> this.xpTank;
                }
            }
        }
        if (storage == Storages.ITEM) {
            if (facing != null) {
                return () -> FactoryAPIPlatform.filteredOf((IPlatformItemHandler)this.inventory, (class_2350)facing, (int[])((int[])this.getSlotsTransport(facing).key()), (TransportState)((TransportState)this.getSlotsTransport(facing).value()));
            }
            return () -> this.inventory;
        }
        if (storage == Storages.ENERGY && (this.hasUpgrade((UpgradeItem)((Object)Registration.ENERGY.get())) || this.hasUpgrade((UpgradeItem)((Object)Registration.GENERATOR.get())))) {
            return () -> FactoryAPIPlatform.filteredOf(this.energyStorage, (TransportState)TransportState.ofBoolean((boolean)true, (!this.hasUpgrade((UpgradeItem)((Object)((Object)Registration.GENERATOR.get()))) ? 1 : 0) != 0));
        }
        return ArbitrarySupplier.empty();
    }

    @Override
    public Pair<int[], TransportState> getSlotsTransport(class_2350 side) {
        if (this.hasUpgradeType((UpgradeItem)((Object)Registration.FACTORY.get()))) {
            if (this.furnaceSettings.get(side.ordinal()) == 1) {
                return Pair.of((Object)this.ISLOTS(), (Object)TransportState.INSERT);
            }
            if (this.furnaceSettings.get(side.ordinal()) == 2) {
                return Pair.of((Object)this.OUTPUTS(), (Object)TransportState.EXTRACT_INSERT);
            }
            if (this.furnaceSettings.get(side.ordinal()) == 3) {
                return Pair.of((Object)this.FSLOTS(), (Object)TransportState.EXTRACT_INSERT);
            }
            if (this.furnaceSettings.get(side.ordinal()) == 4) {
                return Pair.of((Object)new int[]{this.FUEL()[0]}, (Object)TransportState.EXTRACT_INSERT);
            }
        } else {
            if (side == class_2350.field_11036) {
                return Pair.of((Object)this.INPUTS(), (Object)TransportState.INSERT);
            }
            if (side == class_2350.field_11033) {
                return Pair.of((Object)this.OUTPUTS(), (Object)TransportState.EXTRACT);
            }
            return Pair.of((Object)new int[]{this.FUEL()[0]}, (Object)TransportState.EXTRACT_INSERT);
        }
        return Pair.of((Object)new int[0], (Object)TransportState.NONE);
    }

    @Override
    public boolean IcanExtractItem(int index, class_1799 stack) {
        if (this.hasUpgradeType((UpgradeItem)((Object)Registration.FACTORY.get()))) {
            return !ArrayUtils.contains((int[])this.INPUTS(), (int)index) && !ArrayUtils.contains((int[])this.UPGRADES(), (int)index) && (!ArrayUtils.contains((int[])this.FUEL(), (int)index) || !SmeltingBlockEntity.isItemFuel(stack) && (!ItemContainerUtil.isEnergyContainer((class_1799)stack) || ItemContainerUtil.getEnergy((class_1799)stack) <= 0));
        }
        return ArrayUtils.contains((int[])this.OUTPUTS(), (int)index);
    }

    @Override
    public void addSlots(class_2371<FactoryItemSlot> slots, @Nullable class_1657 player) {
        slots.add((Object)new SlotInput(this, 0, 54, 18, s -> !this.hasUpgrade((UpgradeItem)((Object)((Object)Registration.GENERATOR.get())))));
        slots.add((Object)new SlotFuel(this, 1, 54, 54));
        slots.add((Object)new SlotOutput(player, this, 2, 116, 35, s -> !this.hasUpgrade((UpgradeItem)((Object)((Object)Registration.GENERATOR.get())))));
        slots.add((Object)new SlotUpgrade(this, 3, 8, 18));
        slots.add((Object)new SlotUpgrade(this, 4, 8, 36));
        slots.add((Object)new SlotUpgrade(this, 5, 8, 54));
        slots.add((Object)new SlotInput(this, 6, 36, 18, s -> this.hasUpgradeType((UpgradeItem)((Object)((Object)Registration.STORAGE.get())))));
        slots.add((Object)new SlotFuel(this, 7, 36, 54, s -> this.hasUpgradeType((UpgradeItem)((Object)((Object)Registration.STORAGE.get())))));
        slots.add((Object)new SlotOutput(player, this, 8, 138, 35, s -> this.hasUpgradeType((UpgradeItem)((Object)((Object)Registration.STORAGE.get())))));
    }

    public void checkXP(@Nullable class_1860<?> recipe) {
        if (!this.field_11863.field_9236) {
            boolean flag2 = false;
            if (this.recipes.size() > Config.furnaceXPDropValue.get()) {
                this.grantStoredRecipeExperience(this.field_11863, new class_243((double)(this.field_11867.method_10263() + this.rand.nextInt(2) - 1), (double)this.field_11867.method_10264(), (double)(this.field_11867.method_10260() + this.rand.nextInt(2) - 1)));
                this.recipes.clear();
            } else {
                for (Object2IntMap.Entry entry : this.recipes.object2IntEntrySet()) {
                    if (!this.field_11863.method_8433().method_8130((class_2960)entry.getKey()).isPresent() || entry.getIntValue() <= Config.furnaceXPDropValue2.get()) continue;
                    if (!flag2) {
                        this.grantStoredRecipeExperience(this.field_11863, new class_243((double)(this.field_11867.method_10263() + this.rand.nextInt(2) - 1), (double)this.field_11867.method_10264(), (double)(this.field_11867.method_10260() + this.rand.nextInt(2) - 1)));
                    }
                    flag2 = true;
                }
                if (flag2) {
                    this.recipes.clear();
                }
            }
        }
    }

    public void method_7662(@Nullable class_1860<?> recipe) {
        if (recipe != null) {
            class_2960 resourcelocation = recipe.method_8114();
            this.recipes.addTo((Object)resourcelocation, 1);
        }
    }

    public class_1860<?> method_7663() {
        return null;
    }

    public void unlockRecipes(class_1657 player) {
        List<class_1860<?>> list = this.grantStoredRecipeExperience(player.method_37908(), player.method_19538());
        player.method_7254(list);
        this.recipes.clear();
    }

    public List<class_1860<?>> grantStoredRecipeExperience(class_1937 level, class_243 worldPosition) {
        ArrayList list = Lists.newArrayList();
        this.recipes.object2IntEntrySet().fastForEach(entry -> level.method_8433().method_8130((class_2960)entry.getKey()).ifPresent(h -> {
            list.add(h);
            if (this.hasXPTank()) {
                int amountLiquidXp = class_3532.method_15375((float)((float)entry.getIntValue() * ((class_1874)h).method_8171())) * 5;
                if (amountLiquidXp >= 1) {
                    this.xpTank.fill(FluidStack.create((class_3611)Config.getLiquidXP(), (long)((long)amountLiquidXp * FluidStack.bucketAmount() / 1000L)), false);
                    this.recipes.clear();
                }
            } else if (worldPosition != null) {
                SmeltingBlockEntity.splitAndSpawnExperience(level, worldPosition, entry.getIntValue(), ((class_1874)h).method_8171());
            }
        }));
        return list;
    }

    private static void splitAndSpawnExperience(class_1937 level, class_243 worldPosition, int craftedAmount, float experience) {
        int i = class_3532.method_15375((float)((float)craftedAmount * experience));
        float f = class_3532.method_22450((float)((float)craftedAmount * experience));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int j = class_1303.method_5918((int)i);
            i -= j;
            level.method_8649((class_1297)new class_1303(level, worldPosition.field_1352, worldPosition.field_1351, worldPosition.field_1350, j));
        }
    }

    public void method_7683(class_1662 helper) {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            helper.method_7400(this.inventory.method_5438(i));
        }
    }

    protected boolean doesNeedUpdateSend() {
        return !Arrays.equals(this.provides, this.lastProvides);
    }

    public void onUpdateSent() {
        System.arraycopy(this.provides, 0, this.lastProvides, 0, this.provides.length);
        this.field_11863.method_8452(this.field_11867, this.method_11010().method_26204());
    }
}

