/*
 * Decompiled with CFR 0.152.
 */
package net.cristellib.builtinpacks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.cristellib.CristelLib;
import net.cristellib.builtinpacks.UnsafeByteArrayOutputStream;
import net.cristellib.config.ConfigUtil;
import net.minecraft.class_2960;
import net.minecraft.class_3258;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3518;
import net.minecraft.class_7367;
import net.minecraft.class_7663;
import net.minecraft.class_7701;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RuntimePack
implements class_3262 {
    public static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final Lock waiting = new ReentrantLock();
    private final Map<class_2960, Supplier<byte[]>> data = new ConcurrentHashMap<class_2960, Supplier<byte[]>>();
    private final Map<List<String>, Supplier<byte[]>> root = new ConcurrentHashMap<List<String>, Supplier<byte[]>>();
    public final int packVersion;
    private final String name;

    public RuntimePack(String name, int version, @Nullable Path imageFile) {
        byte[] image;
        this.packVersion = version;
        this.name = name;
        if (imageFile != null && (image = RuntimePack.extractImageBytes(imageFile)) != null) {
            this.addRootResource("pack.png", image);
        }
    }

    public byte[] addStructureSet(class_2960 identifier, JsonObject set) {
        return this.addDataForJsonLocation("worldgen/structure_set", identifier, set);
    }

    public byte[] addBiome(class_2960 identifier, JsonObject biome) {
        return this.addDataForJsonLocation("worldgen/biome", identifier, biome);
    }

    public byte[] addStructure(class_2960 identifier, JsonObject structure) {
        return this.addDataForJsonLocation("worldgen/structure", identifier, structure);
    }

    public byte[] addLootTable(class_2960 identifier, JsonObject table) {
        return this.addDataForJsonLocation("loot_tables", identifier, table);
    }

    public byte @Nullable [] addDataForJsonLocationFromPath(String prefix, class_2960 identifier, String fromSubPath, String fromModID) {
        JsonElement jsonElement = ConfigUtil.getElement(fromModID, fromSubPath);
        if (jsonElement instanceof JsonObject) {
            JsonObject object = (JsonObject)jsonElement;
            return this.addDataForJsonLocation(prefix, identifier, object);
        }
        return null;
    }

    public byte[] addDataForJsonLocation(String prefix, class_2960 identifier, JsonObject object) {
        return this.addAndSerializeDataForLocation(prefix, "json", identifier, object);
    }

    public byte[] addAndSerializeDataForLocation(String prefix, String end, class_2960 identifier, JsonObject object) {
        return this.addData(new class_2960(identifier.method_12836(), prefix + "/" + identifier.method_12832() + "." + end), RuntimePack.serializeJson(object));
    }

    public byte[] addData(class_2960 path, byte[] data) {
        this.data.put(path, () -> data);
        return data;
    }

    public void removeData(class_2960 path) {
        this.data.remove(path);
    }

    public static byte @Nullable [] extractImageBytes(Path imageName) {
        try {
            InputStream stream = Files.newInputStream(imageName.toAbsolutePath(), new OpenOption[0]);
            return stream.readAllBytes();
        }
        catch (IOException e) {
            CristelLib.LOGGER.warn("Couldn't get image for path: " + imageName, (Throwable)e);
            return null;
        }
    }

    public static byte[] serializeJson(JsonObject object) {
        UnsafeByteArrayOutputStream ubaos = new UnsafeByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)ubaos, StandardCharsets.UTF_8);
        GSON.toJson((JsonElement)object, (Appendable)writer);
        try {
            writer.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return ubaos.getBytes();
    }

    public byte[] addRootResource(String path, byte[] data) {
        this.root.put(Arrays.asList(path.split("/")), () -> data);
        return data;
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        this.lock();
        Supplier<byte[]> supplier = this.root.get(Arrays.asList(strings));
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    private void lock() {
        if (!this.waiting.tryLock()) {
            this.waiting.lock();
        }
    }

    @Nullable
    public class_7367<InputStream> method_14405(@NotNull class_3264 packType, @NotNull class_2960 id) {
        this.lock();
        Supplier<byte[]> supplier = this.data.get(id);
        if (supplier == null) {
            this.waiting.unlock();
            return null;
        }
        this.waiting.unlock();
        return () -> new ByteArrayInputStream((byte[])supplier.get());
    }

    public void method_14408(@NotNull class_3264 packType, @NotNull String namespace, @NotNull String prefix, @NotNull class_3262.class_7664 resourceOutput) {
        this.lock();
        for (class_2960 identifier : this.data.keySet()) {
            Supplier<byte[]> supplier = this.data.get(identifier);
            if (supplier == null) {
                this.waiting.unlock();
                continue;
            }
            if (!identifier.method_12836().equals(namespace) || !identifier.method_12832().contains(prefix + "/")) continue;
            class_7367 inputSupplier = () -> new ByteArrayInputStream((byte[])supplier.get());
            resourceOutput.accept((Object)identifier, (Object)inputSupplier);
        }
        this.waiting.unlock();
    }

    public Set<String> method_14406(@NotNull class_3264 packType) {
        this.lock();
        HashSet<String> namespaces = new HashSet<String>();
        for (class_2960 identifier : this.data.keySet()) {
            namespaces.add(identifier.method_12836());
        }
        this.waiting.unlock();
        return namespaces;
    }

    @Nullable
    public <T> T method_14407(@NotNull class_3270<T> metadataSectionSerializer) {
        InputStream stream = null;
        try {
            class_7367<InputStream> supplier = this.method_14410("pack.mcmeta");
            if (supplier != null) {
                stream = (InputStream)supplier.get();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (stream != null) {
            return (T)class_3258.method_14392(metadataSectionSerializer, (InputStream)stream);
        }
        if (metadataSectionSerializer.method_14420().equals("pack")) {
            JsonObject object = new JsonObject();
            object.addProperty("pack_format", (Number)this.packVersion);
            object.addProperty("description", this.name);
            return (T)metadataSectionSerializer.method_14421(object);
        }
        if (metadataSectionSerializer.method_14420().equals("features")) {
            return (T)metadataSectionSerializer.method_14421(class_7663.field_39996.method_45251((Object)new class_7663(class_7701.field_40183)));
        }
        CristelLib.LOGGER.debug("'" + metadataSectionSerializer.method_14420() + "' is an unsupported metadata key");
        return null;
    }

    public boolean hasResource(class_2960 location) {
        return this.data.containsKey(location);
    }

    public boolean method_45178() {
        return true;
    }

    public String method_14409() {
        return this.name;
    }

    public void close() {
        CristelLib.LOGGER.debug("Closing RDP: " + this.name);
    }

    public void load(Path dir) throws IOException {
        Stream<Path> stream = Files.walk(dir, new FileVisitOption[0]);
        for (Path file : () -> stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(dir::relativize).iterator()) {
            String s = file.toString();
            if (s.startsWith("data")) {
                String path = s.substring("data".length() + 1);
                this.load(path, this.data, Files.readAllBytes(file));
                continue;
            }
            if (s.startsWith("assets")) continue;
            byte[] data = Files.readAllBytes(file);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    public void load(ZipInputStream stream) throws IOException {
        ZipEntry entry;
        while ((entry = stream.getNextEntry()) != null) {
            String s = entry.toString();
            if (s.startsWith("data")) {
                String path = s.substring("data".length() + 1);
                this.load(path, this.data, this.read(entry, stream));
                continue;
            }
            if (s.startsWith("assets")) continue;
            byte[] data = this.read(entry, stream);
            this.root.put(Arrays.asList(s.split("/")), () -> data);
        }
    }

    protected byte[] read(ZipEntry entry, InputStream stream) throws IOException {
        byte[] data = new byte[Math.toIntExact(entry.getSize())];
        if (stream.read(data) != data.length) {
            throw new IOException("Zip stream was cut off! (maybe incorrect zip entry length? maybe u didn't flush your stream?)");
        }
        return data;
    }

    protected void load(String fullPath, Map<class_2960, Supplier<byte[]>> map, byte[] data) {
        int sep = fullPath.indexOf(47);
        String namespace = fullPath.substring(0, sep);
        String path = fullPath.substring(sep + 1);
        map.put(new class_2960(namespace, path), () -> data);
    }

    @Nullable
    public JsonObject getResource(class_2960 location) {
        JsonObject jsonObject;
        class_7367<InputStream> stream = this.method_14405(class_3264.field_14190, location);
        try {
            jsonObject = class_3518.method_15255((Reader)new BufferedReader(new InputStreamReader((InputStream)stream.get())));
        }
        catch (IOException | NullPointerException ex) {
            CristelLib.LOGGER.error("Couldn't get JsonObject from location: " + location, (Throwable)ex);
            return null;
        }
        return jsonObject;
    }
}

